/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.McrCheckUtil;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfMcrNumber;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StructureTreeCopier {
    private static List<PdfName> ignoreKeysForCopy = new ArrayList<PdfName>();
    private static List<PdfName> ignoreKeysForClone = new ArrayList<PdfName>();

    StructureTreeCopier() {
    }

    public static void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument) {
        if (!destDocument.isTagged()) {
            return;
        }
        StructureTreeCopier.copyTo(destDocument, page2page, callingDocument, false);
    }

    public static void copyTo(PdfDocument destDocument, int insertBeforePage, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument) {
        if (!destDocument.isTagged()) {
            return;
        }
        StructureTreeCopier.copyTo(destDocument, insertBeforePage, page2page, callingDocument, false);
    }

    public static void move(PdfDocument document, PdfPage from, int insertBefore) {
        int destStruct;
        if (!document.isTagged() || insertBefore < 1 || insertBefore > document.getNumberOfPages() + 1) {
            return;
        }
        int fromNum = document.getPageNumber(from);
        if (fromNum == 0 || fromNum == insertBefore || fromNum + 1 == insertBefore) {
            return;
        }
        int currStruct = 0;
        if (fromNum > insertBefore) {
            destStruct = currStruct = StructureTreeCopier.separateStructure(document, 1, insertBefore, 0);
            currStruct = StructureTreeCopier.separateStructure(document, insertBefore, fromNum, currStruct);
            currStruct = StructureTreeCopier.separateStructure(document, fromNum, fromNum + 1, currStruct);
        } else {
            currStruct = StructureTreeCopier.separateStructure(document, 1, fromNum, 0);
            currStruct = StructureTreeCopier.separateStructure(document, fromNum, fromNum + 1, currStruct);
            destStruct = currStruct = StructureTreeCopier.separateStructure(document, fromNum + 1, insertBefore, currStruct);
        }
        HashSet<PdfDictionary> topsToMove = new HashSet<PdfDictionary>();
        Collection<PdfMcr> mcrs = document.getStructTreeRoot().getPageMarkedContentReferences(from);
        if (mcrs != null) {
            for (PdfMcr mcr : mcrs) {
                PdfDictionary top = StructureTreeCopier.getTopmostParent(mcr);
                if (top == null) continue;
                if (top.isFlushed()) {
                    throw new PdfException("Cannot move flushed tag");
                }
                topsToMove.add(top);
            }
        }
        ArrayList<PdfDictionary> orderedTopsToMove = new ArrayList<PdfDictionary>();
        PdfArray tops = document.getStructTreeRoot().getKidsObject();
        for (int i = 0; i < tops.size(); ++i) {
            PdfDictionary top = tops.getAsDictionary(i);
            if (!topsToMove.contains(top)) continue;
            orderedTopsToMove.add(top);
            tops.remove(i);
            if (i >= destStruct) continue;
            --destStruct;
        }
        for (PdfDictionary top : orderedTopsToMove) {
            document.getStructTreeRoot().addKidObject(destStruct++, top);
        }
    }

    private static int separateStructure(PdfDocument document, int beforePage) {
        return StructureTreeCopier.separateStructure(document, 1, beforePage, 0);
    }

    private static int separateStructure(PdfDocument document, int startPage, int beforePage, int startPageStructTopIndex) {
        int i;
        if (!document.isTagged() || 1 > startPage || startPage > beforePage || beforePage > document.getNumberOfPages() + 1) {
            return -1;
        }
        if (beforePage == startPage) {
            return startPageStructTopIndex;
        }
        if (beforePage == document.getNumberOfPages() + 1) {
            return document.getStructTreeRoot().getKidsObject().size();
        }
        HashSet<PdfObject> firstPartElems = new HashSet<PdfObject>();
        for (int i2 = startPage; i2 < beforePage; ++i2) {
            PdfPage pageOfFirstHalf = document.getPage(i2);
            Collection<PdfMcr> pageMcrs = document.getStructTreeRoot().getPageMarkedContentReferences(pageOfFirstHalf);
            if (pageMcrs == null) continue;
            for (PdfMcr mcr : pageMcrs) {
                firstPartElems.add((PdfObject)mcr.getPdfObject());
                PdfDictionary top = StructureTreeCopier.addAllParentsToSet(mcr, firstPartElems);
                if (top == null || !top.isFlushed()) continue;
                throw new PdfException("Tag from the existing tag structure is flushed. Cannot add copied page tags.");
            }
        }
        ArrayList<PdfDictionary> clonedTops = new ArrayList<PdfDictionary>();
        PdfArray tops = document.getStructTreeRoot().getKidsObject();
        int lastTopBefore = startPageStructTopIndex - 1;
        for (i = 0; i < tops.size(); ++i) {
            PdfDictionary top = tops.getAsDictionary(i);
            if (!firstPartElems.contains(top)) continue;
            lastTopBefore = i;
            LastClonedAncestor lastCloned = new LastClonedAncestor();
            lastCloned.ancestor = top;
            PdfDictionary topClone = top.clone(ignoreKeysForClone);
            topClone.put(PdfName.P, (PdfObject)document.getStructTreeRoot().getPdfObject());
            lastCloned.clone = topClone;
            StructureTreeCopier.separateKids(top, firstPartElems, lastCloned, document);
            if (!topClone.containsKey(PdfName.K)) continue;
            topClone.makeIndirect(document);
            clonedTops.add(topClone);
        }
        for (i = 0; i < clonedTops.size(); ++i) {
            document.getStructTreeRoot().addKidObject(lastTopBefore + 1 + i, (PdfDictionary)clonedTops.get(i));
        }
        return lastTopBefore + 1;
    }

    private static void copyTo(PdfDocument destDocument, int insertBeforePage, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument, boolean copyFromDestDocument) {
        if (!destDocument.isTagged()) {
            return;
        }
        int insertIndex = StructureTreeCopier.separateStructure(destDocument, insertBeforePage);
        if (insertIndex > 0) {
            StructureTreeCopier.copyTo(destDocument, page2page, callingDocument, copyFromDestDocument, insertIndex);
        }
    }

    private static void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument, boolean copyFromDestDocument) {
        StructureTreeCopier.copyTo(destDocument, page2page, callingDocument, copyFromDestDocument, -1);
    }

    private static void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument, boolean copyFromDestDocument, int insertIndex) {
        CopyStructureResult copiedStructure = StructureTreeCopier.copyStructure(destDocument, page2page, callingDocument, copyFromDestDocument);
        PdfStructTreeRoot destStructTreeRoot = destDocument.getStructTreeRoot();
        destStructTreeRoot.makeIndirect(destDocument);
        for (PdfDictionary copied : copiedStructure.getTopsList()) {
            destStructTreeRoot.addKidObject(insertIndex, copied);
            if (insertIndex <= -1) continue;
            ++insertIndex;
        }
        if (!copyFromDestDocument) {
            if (!copiedStructure.getCopiedNamespaces().isEmpty()) {
                destStructTreeRoot.getNamespacesObject().addAll(copiedStructure.getCopiedNamespaces());
            }
            PdfDictionary srcRoleMap = callingDocument.getStructTreeRoot().getRoleMap();
            PdfDictionary destRoleMap = destStructTreeRoot.getRoleMap();
            for (Map.Entry<PdfName, PdfObject> mappingEntry : srcRoleMap.entrySet()) {
                if (!destRoleMap.containsKey(mappingEntry.getKey())) {
                    destRoleMap.put(mappingEntry.getKey(), mappingEntry.getValue());
                    continue;
                }
                if (mappingEntry.getValue().equals(destRoleMap.get(mappingEntry.getKey()))) continue;
                String srcMapping = mappingEntry.getKey() + " -> " + mappingEntry.getValue();
                String destMapping = mappingEntry.getKey() + " -> " + destRoleMap.get(mappingEntry.getKey());
                Logger logger = LoggerFactory.getLogger(StructureTreeCopier.class);
                logger.warn(MessageFormat.format("Role mapping \"{0}\" from source document is not copied. Destination document already has \"{1}\" mapping.", srcMapping, destMapping));
            }
        }
    }

    private static CopyStructureResult copyStructure(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument, boolean copyFromDestDocument) {
        PdfDocument fromDocument = copyFromDestDocument ? destDocument : callingDocument;
        HashMap topsToFirstDestPage = new HashMap();
        HashSet<PdfObject> objectsToCopy = new HashSet<PdfObject>();
        HashMap<PdfDictionary, PdfDictionary> page2pageDictionaries = new HashMap<PdfDictionary, PdfDictionary>();
        for (Map.Entry<PdfPage, PdfPage> entry : page2page.entrySet()) {
            page2pageDictionaries.put((PdfDictionary)entry.getKey().getPdfObject(), (PdfDictionary)entry.getValue().getPdfObject());
            Collection<PdfMcr> mcrs = fromDocument.getStructTreeRoot().getPageMarkedContentReferences(entry.getKey());
            if (mcrs == null) continue;
            for (PdfMcr mcr : mcrs) {
                PdfDictionary top;
                if (mcr instanceof PdfMcrDictionary || mcr instanceof PdfObjRef) {
                    objectsToCopy.add((PdfObject)mcr.getPdfObject());
                }
                if ((top = StructureTreeCopier.addAllParentsToSet(mcr, objectsToCopy)) == null) continue;
                if (top.isFlushed()) {
                    throw new PdfException("Cannot copy flushed tag.");
                }
                if (topsToFirstDestPage.containsKey(top)) continue;
                topsToFirstDestPage.put(top, entry.getValue().getPdfObject());
            }
        }
        ArrayList<PdfDictionary> topsInOriginalOrder = new ArrayList<PdfDictionary>();
        for (IStructureNode kid : fromDocument.getStructTreeRoot().getKids()) {
            PdfDictionary kidObject;
            if (kid == null || !topsToFirstDestPage.containsKey(kidObject = (PdfDictionary)((PdfStructElem)kid).getPdfObject())) continue;
            topsInOriginalOrder.add(kidObject);
        }
        StructElemCopyingParams structElemCopyingParams = new StructElemCopyingParams(objectsToCopy, destDocument, page2pageDictionaries, copyFromDestDocument);
        PdfStructTreeRoot destStructTreeRoot = destDocument.getStructTreeRoot();
        destStructTreeRoot.makeIndirect(destDocument);
        ArrayList<PdfDictionary> copiedTops = new ArrayList<PdfDictionary>();
        for (PdfDictionary top : topsInOriginalOrder) {
            PdfDictionary copied = StructureTreeCopier.copyObject(top, (PdfDictionary)topsToFirstDestPage.get(top), false, structElemCopyingParams);
            copiedTops.add(copied);
        }
        return new CopyStructureResult(copiedTops, structElemCopyingParams.getCopiedNamespaces());
    }

    private static PdfDictionary copyObject(PdfDictionary source, PdfDictionary destPage, boolean parentChangePg, StructElemCopyingParams copyingParams) {
        PdfDictionary copied;
        if (copyingParams.isCopyFromDestDocument()) {
            PdfDictionary pg;
            copied = source.clone(ignoreKeysForClone);
            if (source.isIndirect()) {
                copied.makeIndirect(copyingParams.getToDocument());
            }
            if ((pg = source.getAsDictionary(PdfName.Pg)) != null && copyingParams.isCopyFromDestDocument()) {
                if (pg != destPage) {
                    copied.put(PdfName.Pg, destPage);
                    parentChangePg = true;
                } else {
                    parentChangePg = false;
                }
            }
        } else {
            PdfDictionary pg;
            PdfDictionary nsDict;
            copied = source.copyTo(copyingParams.getToDocument(), ignoreKeysForCopy, true);
            PdfDictionary obj = source.getAsDictionary(PdfName.Obj);
            if (obj != null) {
                obj = obj.copyTo(copyingParams.getToDocument(), Arrays.asList(PdfName.P), false);
                copied.put(PdfName.Obj, obj);
            }
            if ((nsDict = source.getAsDictionary(PdfName.NS)) != null) {
                PdfDictionary copiedNsDict = StructureTreeCopier.copyNamespaceDict(nsDict, copyingParams);
                copied.put(PdfName.NS, copiedNsDict);
            }
            if ((pg = source.getAsDictionary(PdfName.Pg)) != null) {
                PdfDictionary pageAnalog = copyingParams.getPage2page().get(pg);
                if (pageAnalog == null) {
                    pageAnalog = destPage;
                    parentChangePg = true;
                } else {
                    parentChangePg = false;
                }
                copied.put(PdfName.Pg, pageAnalog);
            }
        }
        PdfObject k = source.get(PdfName.K);
        PdfDictionary lastCopiedTrPage = null;
        if (k != null) {
            if (k.isArray()) {
                PdfArray kArr = (PdfArray)k;
                PdfArray newArr = new PdfArray();
                for (int i = 0; i < kArr.size(); ++i) {
                    PdfObject copiedKid = StructureTreeCopier.copyObjectKid(kArr.get(i), copied, destPage, parentChangePg, copyingParams, lastCopiedTrPage);
                    if (copiedKid == null) continue;
                    newArr.add(copiedKid);
                    if (!(copiedKid instanceof PdfDictionary) || !PdfName.TR.equals(((PdfDictionary)copiedKid).getAsName(PdfName.S))) continue;
                    lastCopiedTrPage = destPage;
                }
                if (!newArr.isEmpty()) {
                    if (newArr.size() == 1) {
                        copied.put(PdfName.K, newArr.get(0));
                    } else {
                        copied.put(PdfName.K, newArr);
                    }
                }
            } else {
                PdfObject copiedKid = StructureTreeCopier.copyObjectKid(k, copied, destPage, parentChangePg, copyingParams, lastCopiedTrPage);
                if (copiedKid != null) {
                    copied.put(PdfName.K, copiedKid);
                }
            }
        }
        return copied;
    }

    private static PdfObject copyObjectKid(PdfObject kid, PdfDictionary copiedParent, PdfDictionary destPage, boolean parentChangePg, StructElemCopyingParams copyingParams, PdfDictionary lastCopiedTrPage) {
        if (kid.isNumber()) {
            if (!parentChangePg) {
                copyingParams.getToDocument().getStructTreeRoot().getParentTreeHandler().registerMcr(new PdfMcrNumber((PdfNumber)kid, new PdfStructElem(copiedParent)));
                return kid;
            }
        } else if (kid.isDictionary()) {
            PdfDictionary kidAsDict = (PdfDictionary)kid;
            if (copyingParams.getObjectsToCopy().contains(kidAsDict) || StructureTreeCopier.shouldTableElementBeCopied(kidAsDict, copiedParent)) {
                PdfDictionary destination = destPage;
                if (PdfName.TR.equals(kidAsDict.getAsName(PdfName.S)) && !copyingParams.getObjectsToCopy().contains(kidAsDict)) {
                    if (McrCheckUtil.isTrContainsMcr(kidAsDict)) {
                        return null;
                    }
                    if (lastCopiedTrPage == null) {
                        return null;
                    }
                    destination = lastCopiedTrPage;
                }
                boolean hasParent = kidAsDict.containsKey(PdfName.P);
                PdfDictionary copiedKid = StructureTreeCopier.copyObject(kidAsDict, destination, parentChangePg, copyingParams);
                if (hasParent) {
                    copiedKid.put(PdfName.P, copiedParent);
                } else {
                    PdfMcr mcr;
                    if (copiedKid.containsKey(PdfName.Obj)) {
                        mcr = new PdfObjRef(copiedKid, new PdfStructElem(copiedParent));
                        PdfDictionary contentItemObject = copiedKid.getAsDictionary(PdfName.Obj);
                        if (PdfName.Link.equals(contentItemObject.getAsName(PdfName.Subtype)) && !contentItemObject.containsKey(PdfName.P)) {
                            return null;
                        }
                        contentItemObject.put(PdfName.StructParent, new PdfNumber(copyingParams.getToDocument().getNextStructParentIndex()));
                    } else {
                        mcr = new PdfMcrDictionary(copiedKid, new PdfStructElem(copiedParent));
                    }
                    copyingParams.getToDocument().getStructTreeRoot().getParentTreeHandler().registerMcr(mcr);
                }
                return copiedKid;
            }
        }
        return null;
    }

    static boolean shouldTableElementBeCopied(PdfDictionary obj, PdfDictionary parent) {
        PdfName role = obj.getAsName(PdfName.S);
        return (PdfName.TD.equals(role) || PdfName.TH.equals(role)) && PdfName.TR.equals(parent.get(PdfName.S)) || PdfName.TR.equals(role);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static PdfDictionary copyNamespaceDict(PdfDictionary srcNsDict, StructElemCopyingParams copyingParams) {
        List<PdfName> excludeKeys = Collections.singletonList(PdfName.RoleMapNS);
        PdfDocument toDocument = copyingParams.getToDocument();
        PdfDictionary copiedNsDict = srcNsDict.copyTo(toDocument, excludeKeys, false);
        copyingParams.addCopiedNamespace(copiedNsDict);
        PdfDictionary srcRoleMapNs = srcNsDict.getAsDictionary(PdfName.RoleMapNS);
        PdfDictionary copiedRoleMap = copiedNsDict.getAsDictionary(PdfName.RoleMapNS);
        if (srcRoleMapNs != null && copiedRoleMap == null) {
            copiedRoleMap = new PdfDictionary();
            copiedNsDict.put(PdfName.RoleMapNS, copiedRoleMap);
            for (Map.Entry<PdfName, PdfObject> entry : srcRoleMapNs.entrySet()) {
                PdfObject copiedMapping;
                block5: {
                    if (entry.getValue().isArray()) {
                        PdfArray srcMappingArray = (PdfArray)entry.getValue();
                        if (srcMappingArray.size() > 1 && srcMappingArray.get(1).isDictionary()) {
                            PdfArray copiedMappingArray = new PdfArray();
                            copiedMappingArray.add(srcMappingArray.get(0).copyTo(toDocument));
                            PdfDictionary copiedNamespace = StructureTreeCopier.copyNamespaceDict(srcMappingArray.getAsDictionary(1), copyingParams);
                            copiedMappingArray.add(copiedNamespace);
                            copiedMapping = copiedMappingArray;
                            break block5;
                        } else {
                            Logger logger = LoggerFactory.getLogger(StructureTreeCopier.class);
                            logger.warn(MessageFormat.format("Role mapping for \"{0}\" from source document is not copied. Mapping to namespace is in an invalid form (should be [PdfName, PdfDictionary]).", entry.getKey().toString()));
                            continue;
                        }
                    }
                    copiedMapping = entry.getValue().copyTo(toDocument);
                }
                PdfName copiedRoleFrom = (PdfName)entry.getKey().copyTo(toDocument);
                copiedRoleMap.put(copiedRoleFrom, copiedMapping);
            }
        }
        return copiedNsDict;
    }

    private static void separateKids(PdfDictionary structElem, Set<PdfObject> firstPartElems, LastClonedAncestor lastCloned, PdfDocument document) {
        PdfObject k = structElem.get(PdfName.K);
        if (!k.isArray()) {
            if (k.isDictionary() && PdfStructElem.isStructElem((PdfDictionary)k)) {
                StructureTreeCopier.separateKids((PdfDictionary)k, firstPartElems, lastCloned, document);
            }
        } else {
            PdfArray kids = (PdfArray)k;
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kid = kids.get(i);
                PdfDictionary dictKid = null;
                if (kid.isDictionary()) {
                    dictKid = (PdfDictionary)kid;
                }
                if (dictKid != null && PdfStructElem.isStructElem(dictKid)) {
                    if (firstPartElems.contains(kid)) {
                        StructureTreeCopier.separateKids((PdfDictionary)kid, firstPartElems, lastCloned, document);
                        continue;
                    }
                    if (dictKid.isFlushed()) {
                        throw new PdfException("Tag from the existing tag structure is flushed. Cannot add copied page tags.");
                    }
                    if (!dictKid.containsKey(PdfName.K)) continue;
                    StructureTreeCopier.cloneParents(structElem, lastCloned, document);
                    kids.remove(i--);
                    PdfStructElem.addKidObject(lastCloned.clone, -1, kid);
                    continue;
                }
                if (firstPartElems.contains(kid)) continue;
                StructureTreeCopier.cloneParents(structElem, lastCloned, document);
                PdfMcr mcr = dictKid != null ? (dictKid.get(PdfName.Type).equals(PdfName.MCR) ? new PdfMcrDictionary(dictKid, new PdfStructElem(lastCloned.clone)) : new PdfObjRef(dictKid, new PdfStructElem(lastCloned.clone))) : new PdfMcrNumber((PdfNumber)kid, new PdfStructElem(lastCloned.clone));
                kids.remove(i--);
                PdfStructElem.addKidObject(lastCloned.clone, -1, kid);
                document.getStructTreeRoot().getParentTreeHandler().registerMcr(mcr);
            }
        }
        if (lastCloned.ancestor == structElem) {
            lastCloned.ancestor = lastCloned.ancestor.getAsDictionary(PdfName.P);
            lastCloned.clone = lastCloned.clone.getAsDictionary(PdfName.P);
        }
    }

    private static void cloneParents(PdfDictionary structElem, LastClonedAncestor lastCloned, PdfDocument document) {
        if (lastCloned.ancestor != structElem) {
            PdfDictionary structElemClone;
            PdfDictionary currClone = structElemClone = (PdfDictionary)structElem.clone(ignoreKeysForClone).makeIndirect(document);
            PdfDictionary currElem = structElem;
            while (currElem.get(PdfName.P) != lastCloned.ancestor) {
                PdfDictionary parent = currElem.getAsDictionary(PdfName.P);
                PdfDictionary parentClone = (PdfDictionary)parent.clone(ignoreKeysForClone).makeIndirect(document);
                currClone.put(PdfName.P, parentClone);
                parentClone.put(PdfName.K, currClone);
                currClone = parentClone;
                currElem = parent;
            }
            PdfStructElem.addKidObject(lastCloned.clone, -1, currClone);
            lastCloned.clone = structElemClone;
            lastCloned.ancestor = structElem;
        }
    }

    private static PdfDictionary addAllParentsToSet(PdfMcr mcr, Set<PdfObject> set) {
        List<PdfDictionary> allParents = StructureTreeCopier.retrieveParents(mcr, true);
        set.addAll(allParents);
        return allParents.isEmpty() ? null : allParents.get(allParents.size() - 1);
    }

    private static PdfDictionary getTopmostParent(PdfMcr mcr) {
        return StructureTreeCopier.retrieveParents(mcr, false).get(0);
    }

    private static List<PdfDictionary> retrieveParents(PdfMcr mcr, boolean all) {
        PdfDictionary current;
        ArrayList<PdfDictionary> parents = new ArrayList<PdfDictionary>();
        IStructureNode firstParent = mcr.getParent();
        PdfDictionary previous = null;
        PdfDictionary pdfDictionary = current = firstParent instanceof PdfStructElem ? (PdfDictionary)((PdfStructElem)firstParent).getPdfObject() : null;
        while (current != null && !PdfName.StructTreeRoot.equals(current.getAsName(PdfName.Type))) {
            if (all) {
                parents.add(current);
            }
            current = (previous = current).isFlushed() ? null : previous.getAsDictionary(PdfName.P);
        }
        if (!all) {
            parents.add(previous);
        }
        return parents;
    }

    static {
        ignoreKeysForCopy.add(PdfName.K);
        ignoreKeysForCopy.add(PdfName.P);
        ignoreKeysForCopy.add(PdfName.Pg);
        ignoreKeysForCopy.add(PdfName.Obj);
        ignoreKeysForCopy.add(PdfName.NS);
        ignoreKeysForClone.add(PdfName.K);
        ignoreKeysForClone.add(PdfName.P);
    }

    private static class CopyStructureResult {
        private final List<PdfDictionary> topsList;
        private final Set<PdfObject> copiedNamespaces;

        public CopyStructureResult(List<PdfDictionary> topsList, Set<PdfObject> copiedNamespaces) {
            this.topsList = topsList;
            this.copiedNamespaces = copiedNamespaces;
        }

        public Set<PdfObject> getCopiedNamespaces() {
            return this.copiedNamespaces;
        }

        public List<PdfDictionary> getTopsList() {
            return this.topsList;
        }
    }

    private static class StructElemCopyingParams {
        private final Set<PdfObject> objectsToCopy;
        private final PdfDocument toDocument;
        private final Map<PdfDictionary, PdfDictionary> page2page;
        private final boolean copyFromDestDocument;
        private final Set<PdfObject> copiedNamespaces;

        public StructElemCopyingParams(Set<PdfObject> objectsToCopy, PdfDocument toDocument, Map<PdfDictionary, PdfDictionary> page2page, boolean copyFromDestDocument) {
            this.objectsToCopy = objectsToCopy;
            this.toDocument = toDocument;
            this.page2page = page2page;
            this.copyFromDestDocument = copyFromDestDocument;
            this.copiedNamespaces = new LinkedHashSet<PdfObject>();
        }

        public Set<PdfObject> getObjectsToCopy() {
            return this.objectsToCopy;
        }

        public PdfDocument getToDocument() {
            return this.toDocument;
        }

        public Map<PdfDictionary, PdfDictionary> getPage2page() {
            return this.page2page;
        }

        public boolean isCopyFromDestDocument() {
            return this.copyFromDestDocument;
        }

        public void addCopiedNamespace(PdfDictionary copiedNs) {
            this.copiedNamespaces.add(copiedNs);
        }

        public Set<PdfObject> getCopiedNamespaces() {
            return this.copiedNamespaces;
        }
    }

    static class LastClonedAncestor {
        PdfDictionary ancestor;
        PdfDictionary clone;

        LastClonedAncestor() {
        }
    }
}

