/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.clipper;

import com.itextpdf.kernel.pdf.canvas.parser.clipper.Edge;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.IClipper;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Path;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Paths;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class ClipperBase
implements IClipper {
    private static final long LOW_RANGE = 0x3FFFFFFFL;
    private static final long HI_RANGE = 0x3FFFFFFFFFFFFFFFL;
    protected LocalMinima minimaList;
    protected LocalMinima currentLM;
    private final List<List<Edge>> edges;
    protected boolean useFullRange;
    protected boolean hasOpenPaths;
    protected final boolean preserveCollinear;
    private static final Logger LOGGER = Logger.getLogger(IClipper.class.getName());

    private static void initEdge(Edge e, Edge eNext, Edge ePrev, Point.LongPoint pt) {
        e.next = eNext;
        e.prev = ePrev;
        e.setCurrent(new Point.LongPoint(pt));
        e.outIdx = -1;
    }

    private static void initEdge2(Edge e, IClipper.PolyType polyType) {
        if (e.getCurrent().getY() >= e.next.getCurrent().getY()) {
            e.setBot(new Point.LongPoint(e.getCurrent()));
            e.setTop(new Point.LongPoint(e.next.getCurrent()));
        } else {
            e.setTop(new Point.LongPoint(e.getCurrent()));
            e.setBot(new Point.LongPoint(e.next.getCurrent()));
        }
        e.updateDeltaX();
        e.polyTyp = polyType;
    }

    private static boolean rangeTest(Point.LongPoint Pt, boolean useFullRange) {
        if (useFullRange) {
            if (Pt.getX() > 0x3FFFFFFFFFFFFFFFL || Pt.getY() > 0x3FFFFFFFFFFFFFFFL || -Pt.getX() > 0x3FFFFFFFFFFFFFFFL || -Pt.getY() > 0x3FFFFFFFFFFFFFFFL) {
                throw new IllegalStateException("Coordinate outside allowed range");
            }
        } else if (Pt.getX() > 0x3FFFFFFFL || Pt.getY() > 0x3FFFFFFFL || -Pt.getX() > 0x3FFFFFFFL || -Pt.getY() > 0x3FFFFFFFL) {
            return ClipperBase.rangeTest(Pt, true);
        }
        return useFullRange;
    }

    private static Edge removeEdge(Edge e) {
        e.prev.next = e.next;
        e.next.prev = e.prev;
        Edge result = e.next;
        e.prev = null;
        return result;
    }

    protected ClipperBase(boolean preserveCollinear) {
        this.preserveCollinear = preserveCollinear;
        this.minimaList = null;
        this.currentLM = null;
        this.hasOpenPaths = false;
        this.edges = new ArrayList<List<Edge>>();
    }

    @Override
    public boolean addPath(Path pg, IClipper.PolyType polyType, boolean Closed) {
        Edge eStart;
        int highI;
        if (!Closed && polyType == IClipper.PolyType.CLIP) {
            throw new IllegalStateException("AddPath: Open paths must be subject.");
        }
        if (Closed) {
            for (highI = pg.size() - 1; highI > 0 && ((Point.LongPoint)pg.get(highI)).equals(pg.get(0)); --highI) {
            }
        }
        while (highI > 0 && ((Point.LongPoint)pg.get(highI)).equals(pg.get(highI - 1))) {
            --highI;
        }
        if (Closed && highI < 2 || !Closed && highI < 1) {
            return false;
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(highI + 1);
        for (int i = 0; i <= highI; ++i) {
            edges.add(new Edge());
        }
        boolean IsFlat = true;
        ((Edge)edges.get(1)).setCurrent(new Point.LongPoint((Point.LongPoint)pg.get(1)));
        this.useFullRange = ClipperBase.rangeTest((Point.LongPoint)pg.get(0), this.useFullRange);
        this.useFullRange = ClipperBase.rangeTest((Point.LongPoint)pg.get(highI), this.useFullRange);
        ClipperBase.initEdge((Edge)edges.get(0), (Edge)edges.get(1), (Edge)edges.get(highI), (Point.LongPoint)pg.get(0));
        ClipperBase.initEdge((Edge)edges.get(highI), (Edge)edges.get(0), (Edge)edges.get(highI - 1), (Point.LongPoint)pg.get(highI));
        for (int i = highI - 1; i >= 1; --i) {
            this.useFullRange = ClipperBase.rangeTest((Point.LongPoint)pg.get(i), this.useFullRange);
            ClipperBase.initEdge((Edge)edges.get(i), (Edge)edges.get(i + 1), (Edge)edges.get(i - 1), (Point.LongPoint)pg.get(i));
        }
        Edge e = eStart = (Edge)edges.get(0);
        Edge eLoopStop = eStart;
        while (true) {
            if (e.getCurrent().equals(e.next.getCurrent()) && (Closed || !e.next.equals(eStart))) {
                if (e == e.next) break;
                if (e == eStart) {
                    eStart = e.next;
                }
                eLoopStop = e = ClipperBase.removeEdge(e);
                continue;
            }
            if (e.prev == e.next) break;
            if (Closed && Point.slopesEqual(e.prev.getCurrent(), e.getCurrent(), e.next.getCurrent(), this.useFullRange) && (!this.isPreserveCollinear() || !Point.isPt2BetweenPt1AndPt3(e.prev.getCurrent(), e.getCurrent(), e.next.getCurrent()))) {
                if (e == eStart) {
                    eStart = e.next;
                }
                e = ClipperBase.removeEdge(e);
                eLoopStop = e = e.prev;
                continue;
            }
            e = e.next;
            if (e == eLoopStop || !Closed && e.next == eStart) break;
        }
        if (!Closed && e == e.next || Closed && e.prev == e.next) {
            return false;
        }
        if (!Closed) {
            this.hasOpenPaths = true;
            eStart.prev.outIdx = -2;
        }
        e = eStart;
        do {
            ClipperBase.initEdge2(e, polyType);
            e = e.next;
            if (!IsFlat || e.getCurrent().getY() == eStart.getCurrent().getY()) continue;
            IsFlat = false;
        } while (e != eStart);
        if (IsFlat) {
            if (Closed) {
                return false;
            }
            e.prev.outIdx = -2;
            LocalMinima locMin = new LocalMinima();
            locMin.next = null;
            locMin.y = e.getBot().getY();
            locMin.leftBound = null;
            locMin.rightBound = e;
            locMin.rightBound.side = Edge.Side.RIGHT;
            locMin.rightBound.windDelta = 0;
            while (true) {
                if (e.getBot().getX() != e.prev.getTop().getX()) {
                    e.reverseHorizontal();
                }
                if (e.next.outIdx == -2) break;
                e.nextInLML = e.next;
                e = e.next;
            }
            this.insertLocalMinima(locMin);
            this.edges.add(edges);
            return true;
        }
        this.edges.add(edges);
        Edge EMin = null;
        if (e.prev.getBot().equals(e.prev.getTop())) {
            e = e.next;
        }
        while ((e = e.findNextLocMin()) != EMin) {
            boolean leftBoundIsForward;
            if (EMin == null) {
                EMin = e;
            }
            LocalMinima locMin = new LocalMinima();
            locMin.next = null;
            locMin.y = e.getBot().getY();
            if (e.deltaX < e.prev.deltaX) {
                locMin.leftBound = e.prev;
                locMin.rightBound = e;
                leftBoundIsForward = false;
            } else {
                locMin.leftBound = e;
                locMin.rightBound = e.prev;
                leftBoundIsForward = true;
            }
            locMin.leftBound.side = Edge.Side.LEFT;
            locMin.rightBound.side = Edge.Side.RIGHT;
            locMin.leftBound.windDelta = !Closed ? 0 : (locMin.leftBound.next == locMin.rightBound ? -1 : 1);
            locMin.rightBound.windDelta = -locMin.leftBound.windDelta;
            e = this.processBound(locMin.leftBound, leftBoundIsForward);
            if (e.outIdx == -2) {
                e = this.processBound(e, leftBoundIsForward);
            }
            Edge E2 = this.processBound(locMin.rightBound, !leftBoundIsForward);
            if (E2.outIdx == -2) {
                E2 = this.processBound(E2, !leftBoundIsForward);
            }
            if (locMin.leftBound.outIdx == -2) {
                locMin.leftBound = null;
            } else if (locMin.rightBound.outIdx == -2) {
                locMin.rightBound = null;
            }
            this.insertLocalMinima(locMin);
            if (leftBoundIsForward) continue;
            e = E2;
        }
        return true;
    }

    @Override
    public boolean addPaths(Paths ppg, IClipper.PolyType polyType, boolean closed) {
        boolean result = false;
        for (int i = 0; i < ppg.size(); ++i) {
            if (!this.addPath((Path)ppg.get(i), polyType, closed)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public void clear() {
        this.disposeLocalMinimaList();
        this.edges.clear();
        this.useFullRange = false;
        this.hasOpenPaths = false;
    }

    private void disposeLocalMinimaList() {
        while (this.minimaList != null) {
            LocalMinima tmpLm = this.minimaList.next;
            this.minimaList = null;
            this.minimaList = tmpLm;
        }
        this.currentLM = null;
    }

    private void insertLocalMinima(LocalMinima newLm) {
        if (this.minimaList == null) {
            this.minimaList = newLm;
        } else if (newLm.y >= this.minimaList.y) {
            newLm.next = this.minimaList;
            this.minimaList = newLm;
        } else {
            LocalMinima tmpLm = this.minimaList;
            while (tmpLm.next != null && newLm.y < tmpLm.next.y) {
                tmpLm = tmpLm.next;
            }
            newLm.next = tmpLm.next;
            tmpLm.next = newLm;
        }
    }

    public boolean isPreserveCollinear() {
        return this.preserveCollinear;
    }

    protected void popLocalMinima() {
        LOGGER.entering(ClipperBase.class.getName(), "popLocalMinima");
        if (this.currentLM == null) {
            return;
        }
        this.currentLM = this.currentLM.next;
    }

    private Edge processBound(Edge e, boolean LeftBoundIsForward) {
        Edge EStart;
        Edge result = e;
        if (result.outIdx == -2) {
            e = result;
            if (LeftBoundIsForward) {
                while (e.getTop().getY() == e.next.getBot().getY()) {
                    e = e.next;
                }
                while (e != result && e.deltaX == -3.4E38) {
                    e = e.prev;
                }
            } else {
                while (e.getTop().getY() == e.prev.getBot().getY()) {
                    e = e.prev;
                }
                while (e != result && e.deltaX == -3.4E38) {
                    e = e.next;
                }
            }
            if (e == result) {
                result = LeftBoundIsForward ? e.next : e.prev;
            } else {
                e = LeftBoundIsForward ? result.next : result.prev;
                LocalMinima locMin = new LocalMinima();
                locMin.next = null;
                locMin.y = e.getBot().getY();
                locMin.leftBound = null;
                locMin.rightBound = e;
                e.windDelta = 0;
                result = this.processBound(e, LeftBoundIsForward);
                this.insertLocalMinima(locMin);
            }
            return result;
        }
        if (e.deltaX == -3.4E38) {
            EStart = LeftBoundIsForward ? e.prev : e.next;
            if (EStart.deltaX == -3.4E38) {
                if (EStart.getBot().getX() != e.getBot().getX() && EStart.getTop().getX() != e.getBot().getX()) {
                    e.reverseHorizontal();
                }
            } else if (EStart.getBot().getX() != e.getBot().getX()) {
                e.reverseHorizontal();
            }
        }
        EStart = e;
        if (LeftBoundIsForward) {
            while (result.getTop().getY() == result.next.getBot().getY() && result.next.outIdx != -2) {
                result = result.next;
            }
            if (result.deltaX == -3.4E38 && result.next.outIdx != -2) {
                Edge Horz = result;
                while (Horz.prev.deltaX == -3.4E38) {
                    Horz = Horz.prev;
                }
                if (Horz.prev.getTop().getX() > result.next.getTop().getX()) {
                    result = Horz.prev;
                }
            }
            while (e != result) {
                e.nextInLML = e.next;
                if (e.deltaX == -3.4E38 && e != EStart && e.getBot().getX() != e.prev.getTop().getX()) {
                    e.reverseHorizontal();
                }
                e = e.next;
            }
            if (e.deltaX == -3.4E38 && e != EStart && e.getBot().getX() != e.prev.getTop().getX()) {
                e.reverseHorizontal();
            }
            result = result.next;
        } else {
            while (result.getTop().getY() == result.prev.getBot().getY() && result.prev.outIdx != -2) {
                result = result.prev;
            }
            if (result.deltaX == -3.4E38 && result.prev.outIdx != -2) {
                Edge Horz = result;
                while (Horz.next.deltaX == -3.4E38) {
                    Horz = Horz.next;
                }
                if (Horz.next.getTop().getX() == result.prev.getTop().getX() || Horz.next.getTop().getX() > result.prev.getTop().getX()) {
                    result = Horz.next;
                }
            }
            while (e != result) {
                e.nextInLML = e.prev;
                if (e.deltaX == -3.4E38 && e != EStart && e.getBot().getX() != e.next.getTop().getX()) {
                    e.reverseHorizontal();
                }
                e = e.prev;
            }
            if (e.deltaX == -3.4E38 && e != EStart && e.getBot().getX() != e.next.getTop().getX()) {
                e.reverseHorizontal();
            }
            result = result.prev;
        }
        return result;
    }

    protected static Path.OutRec parseFirstLeft(Path.OutRec FirstLeft) {
        while (FirstLeft != null && FirstLeft.getPoints() == null) {
            FirstLeft = FirstLeft.firstLeft;
        }
        return FirstLeft;
    }

    protected void reset() {
        this.currentLM = this.minimaList;
        if (this.currentLM == null) {
            return;
        }
        LocalMinima lm = this.minimaList;
        while (lm != null) {
            Edge e = lm.leftBound;
            if (e != null) {
                e.setCurrent(new Point.LongPoint(e.getBot()));
                e.side = Edge.Side.LEFT;
                e.outIdx = -1;
            }
            if ((e = lm.rightBound) != null) {
                e.setCurrent(new Point.LongPoint(e.getBot()));
                e.side = Edge.Side.RIGHT;
                e.outIdx = -1;
            }
            lm = lm.next;
        }
    }

    protected class Scanbeam {
        long y;
        Scanbeam next;

        protected Scanbeam() {
        }
    }

    protected class LocalMinima {
        long y;
        Edge leftBound;
        Edge rightBound;
        LocalMinima next;

        protected LocalMinima() {
        }
    }
}

