/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2023 Apryse Group NV
    Authors: Apryse Software.

    This program is offered under a commercial and under the AGPL license.
    For commercial licensing, contact us at https://itextpdf.com/sales.  For AGPL licensing, see below.

    AGPL licensing:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.itextpdf.kernel.pdf.colorspace;

import com.itextpdf.kernel.pdf.PdfName;

public abstract class PdfDeviceCs extends PdfColorSpace {

    private static final long serialVersionUID = 6884911248656287064L;

	@Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    protected PdfDeviceCs(PdfName pdfObject) {
        super(pdfObject);
    }

    public static class Gray extends PdfDeviceCs {

        private static final long serialVersionUID = 2722906212276665191L;

		public Gray() {
            super(PdfName.DeviceGray);
        }

        @Override
        public int getNumberOfComponents() {
            return 1;
        }
    }

    public static class Rgb extends PdfDeviceCs {

        private static final long serialVersionUID = -1605044540582561428L;

		public Rgb() {
            super(PdfName.DeviceRGB);
        }

        @Override
        public int getNumberOfComponents() {
            return 3;
        }
    }

    public static class Cmyk extends PdfDeviceCs {

        private static final long serialVersionUID = 2615036909699704719L;

		public Cmyk() {
            super(PdfName.DeviceCMYK);
        }

        @Override
        public int getNumberOfComponents() {
            return 4;
        }
    }
}
