/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.annot.BorderStyleUtil;
import com.itextpdf.kernel.pdf.annot.InteriorColorUtil;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;

public class PdfSquareAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = 5577194318058336359L;

    public PdfSquareAnnotation(Rectangle rect) {
        super(rect);
    }

    @Deprecated
    public PdfSquareAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Square;
    }

    @Override
    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    @Override
    public PdfSquareAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return (PdfSquareAnnotation)this.put(PdfName.BS, borderStyle);
    }

    @Override
    public PdfSquareAnnotation setBorderStyle(PdfName style) {
        return this.setBorderStyle(BorderStyleUtil.setStyle(this.getBorderStyle(), style));
    }

    @Override
    public PdfSquareAnnotation setDashPattern(PdfArray dashPattern) {
        return this.setBorderStyle(BorderStyleUtil.setDashPattern(this.getBorderStyle(), dashPattern));
    }

    @Override
    public PdfArray getRectangleDifferences() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.RD);
    }

    @Override
    public PdfSquareAnnotation setRectangleDifferences(PdfArray rect) {
        return (PdfSquareAnnotation)this.put(PdfName.RD, rect);
    }

    @Override
    public PdfDictionary getBorderEffect() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BE);
    }

    @Override
    public PdfSquareAnnotation setBorderEffect(PdfDictionary borderEffect) {
        return (PdfSquareAnnotation)this.put(PdfName.BE, borderEffect);
    }

    @Override
    public Color getInteriorColor() {
        return InteriorColorUtil.parseInteriorColor(((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.IC));
    }

    @Override
    public PdfSquareAnnotation setInteriorColor(PdfArray interiorColor) {
        return (PdfSquareAnnotation)this.put(PdfName.IC, interiorColor);
    }

    @Override
    public PdfSquareAnnotation setInteriorColor(float[] interiorColor) {
        return this.setInteriorColor(new PdfArray(interiorColor));
    }
}

