/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotationAppearance;
import com.itextpdf.kernel.pdf.annot.PdfCaretAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfCircleAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFileAttachmentAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFreeTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfInkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLineAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolyGeomAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPopupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPrinterMarkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfRedactAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfScreenAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfSoundAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfSquareAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfStampAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTrapNetworkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWatermarkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;

public abstract class PdfAnnotation
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -6555705164241587799L;
    public static final int INVISIBLE = 1;
    public static final int HIDDEN = 2;
    public static final int PRINT = 4;
    public static final int NO_ZOOM = 8;
    public static final int NO_ROTATE = 16;
    public static final int NO_VIEW = 32;
    public static final int READ_ONLY = 64;
    public static final int LOCKED = 128;
    public static final int TOGGLE_NO_VIEW = 256;
    public static final int LOCKED_CONTENTS = 512;
    public static final PdfName HIGHLIGHT_NONE = PdfName.N;
    public static final PdfName HIGHLIGHT_INVERT = PdfName.I;
    public static final PdfName HIGHLIGHT_OUTLINE = PdfName.O;
    public static final PdfName HIGHLIGHT_PUSH = PdfName.P;
    public static final PdfName HIGHLIGHT_TOGGLE = PdfName.T;
    public static final PdfName STYLE_SOLID = PdfName.S;
    public static final PdfName STYLE_DASHED = PdfName.D;
    public static final PdfName STYLE_BEVELED = PdfName.B;
    public static final PdfName STYLE_INSET = PdfName.I;
    public static final PdfName STYLE_UNDERLINE = PdfName.U;
    public static final PdfString Marked = new PdfString("Marked");
    public static final PdfString Unmarked = new PdfString("Unmarked");
    public static final PdfString Accepted = new PdfString("Accepted");
    public static final PdfString Rejected = new PdfString("Rejected");
    public static final PdfString Canceled = new PdfString("Cancelled");
    public static final PdfString Completed = new PdfString("Completed");
    public static final PdfString None = new PdfString("None");
    public static final PdfString MarkedModel = new PdfString("Marked");
    public static final PdfString ReviewModel = new PdfString("Review");
    protected PdfPage page;

    public static PdfAnnotation makeAnnotation(PdfObject pdfObject) {
        PdfAnnotation annotation = null;
        if (pdfObject.isIndirectReference()) {
            pdfObject = ((PdfIndirectReference)pdfObject).getRefersTo();
        }
        if (pdfObject.isDictionary()) {
            PdfDictionary dictionary = (PdfDictionary)pdfObject;
            PdfName subtype = dictionary.getAsName(PdfName.Subtype);
            if (PdfName.Link.equals(subtype)) {
                annotation = new PdfLinkAnnotation((PdfDictionary)pdfObject);
            } else if (PdfName.Popup.equals(subtype)) {
                annotation = new PdfPopupAnnotation((PdfDictionary)pdfObject);
            } else if (PdfName.Widget.equals(subtype)) {
                annotation = new PdfWidgetAnnotation((PdfDictionary)pdfObject);
            } else if (PdfName.Screen.equals(subtype)) {
                annotation = new PdfScreenAnnotation((PdfDictionary)pdfObject);
            } else {
                if (PdfName._3D.equals(subtype)) {
                    throw new UnsupportedOperationException();
                }
                if (PdfName.Highlight.equals(subtype) || PdfName.Underline.equals(subtype) || PdfName.Squiggly.equals(subtype) || PdfName.StrikeOut.equals(subtype)) {
                    annotation = new PdfTextMarkupAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Caret.equals(subtype)) {
                    annotation = new PdfCaretAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Text.equals(subtype)) {
                    annotation = new PdfTextAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Sound.equals(subtype)) {
                    annotation = new PdfSoundAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Stamp.equals(subtype)) {
                    annotation = new PdfStampAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.FileAttachment.equals(subtype)) {
                    annotation = new PdfFileAttachmentAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Ink.equals(subtype)) {
                    annotation = new PdfInkAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.PrinterMark.equals(subtype)) {
                    annotation = new PdfPrinterMarkAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.TrapNet.equals(subtype)) {
                    annotation = new PdfTrapNetworkAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.FreeText.equals(subtype)) {
                    annotation = new PdfFreeTextAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Square.equals(subtype)) {
                    annotation = new PdfSquareAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Circle.equals(subtype)) {
                    annotation = new PdfCircleAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Line.equals(subtype)) {
                    annotation = new PdfLineAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Polygon.equals(subtype) || PdfName.PolyLine.equals(subtype)) {
                    annotation = new PdfPolyGeomAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Redact.equals(subtype)) {
                    annotation = new PdfRedactAnnotation((PdfDictionary)pdfObject);
                } else if (PdfName.Watermark.equals(subtype)) {
                    annotation = new PdfWatermarkAnnotation((PdfDictionary)pdfObject);
                }
            }
        }
        return annotation;
    }

    @Deprecated
    public static PdfAnnotation makeAnnotation(PdfObject pdfObject, PdfAnnotation parent) {
        PdfAnnotation annotation = PdfAnnotation.makeAnnotation(pdfObject);
        if (annotation instanceof PdfPopupAnnotation) {
            PdfPopupAnnotation popup = (PdfPopupAnnotation)annotation;
            if (parent != null) {
                popup.setParent(parent);
            }
        }
        return annotation;
    }

    protected PdfAnnotation(Rectangle rect) {
        this(new PdfDictionary());
        this.put(PdfName.Rect, new PdfArray(rect));
        this.put(PdfName.Subtype, this.getSubtype());
    }

    protected PdfAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
        PdfAnnotation.markObjectAsIndirect(this.getPdfObject());
    }

    public abstract PdfName getSubtype();

    public void setLayer(IPdfOCG layer) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.OC, layer.getIndirectReference());
    }

    public PdfAnnotation setAction(PdfAction action) {
        return this.put(PdfName.A, (PdfObject)action.getPdfObject());
    }

    public PdfAnnotation setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction(this, key, action);
        return this;
    }

    public PdfString getContents() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Contents);
    }

    public PdfAnnotation setContents(PdfString contents) {
        return this.put(PdfName.Contents, contents);
    }

    public PdfAnnotation setContents(String contents) {
        return this.setContents(new PdfString(contents));
    }

    public PdfDictionary getPageObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.P);
    }

    public PdfPage getPage() {
        if (this.page == null && ((PdfDictionary)this.getPdfObject()).isIndirect()) {
            PdfIndirectReference annotationIndirectReference = ((PdfDictionary)this.getPdfObject()).getIndirectReference();
            PdfDocument doc = annotationIndirectReference.getDocument();
            PdfDictionary pageDictionary = this.getPageObject();
            if (pageDictionary != null) {
                this.page = doc.getPage(pageDictionary);
            } else {
                block0: for (int i = 1; i <= doc.getNumberOfPages(); ++i) {
                    PdfPage docPage = doc.getPage(i);
                    for (PdfAnnotation annot : docPage.getAnnotations()) {
                        if (!((PdfDictionary)annot.getPdfObject()).getIndirectReference().equals(annotationIndirectReference)) continue;
                        this.page = docPage;
                        continue block0;
                    }
                }
            }
        }
        return this.page;
    }

    public PdfAnnotation setPage(PdfPage page) {
        this.page = page;
        return this.put(PdfName.P, (PdfObject)page.getPdfObject());
    }

    public PdfString getName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.NM);
    }

    public PdfAnnotation setName(PdfString name) {
        return this.put(PdfName.NM, name);
    }

    public PdfString getDate() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.M);
    }

    public PdfAnnotation setDate(PdfString date) {
        return this.put(PdfName.M, date);
    }

    public int getFlags() {
        PdfNumber f = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.F);
        if (f != null) {
            return f.intValue();
        }
        return 0;
    }

    public PdfAnnotation setFlags(int flags) {
        return this.put(PdfName.F, new PdfNumber(flags));
    }

    public PdfAnnotation setFlag(int flag) {
        int flags = this.getFlags();
        return this.setFlags(flags |= flag);
    }

    public PdfAnnotation resetFlag(int flag) {
        int flags = this.getFlags();
        return this.setFlags(flags &= ~flag);
    }

    public boolean hasFlag(int flag) {
        if (flag == 0) {
            return false;
        }
        if ((flag & flag - 1) != 0) {
            throw new IllegalArgumentException("Only one flag must be checked at once.");
        }
        int flags = this.getFlags();
        return (flags & flag) != 0;
    }

    public PdfDictionary getAppearanceDictionary() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AP);
    }

    public PdfDictionary getAppearanceObject(PdfName appearanceType) {
        PdfObject apObject;
        PdfDictionary ap = this.getAppearanceDictionary();
        if (ap != null && (apObject = ap.get(appearanceType)) instanceof PdfDictionary) {
            return (PdfDictionary)apObject;
        }
        return null;
    }

    public PdfDictionary getNormalAppearanceObject() {
        return this.getAppearanceObject(PdfName.N);
    }

    public PdfDictionary getRolloverAppearanceObject() {
        return this.getAppearanceObject(PdfName.R);
    }

    public PdfDictionary getDownAppearanceObject() {
        return this.getAppearanceObject(PdfName.D);
    }

    public PdfAnnotation setAppearance(PdfName appearanceType, PdfDictionary appearance) {
        PdfDictionary ap = this.getAppearanceDictionary();
        if (ap == null) {
            ap = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.AP, ap);
        }
        ap.put(appearanceType, appearance);
        return this;
    }

    public PdfAnnotation setNormalAppearance(PdfDictionary appearance) {
        return this.setAppearance(PdfName.N, appearance);
    }

    public PdfAnnotation setRolloverAppearance(PdfDictionary appearance) {
        return this.setAppearance(PdfName.R, appearance);
    }

    public PdfAnnotation setDownAppearance(PdfDictionary appearance) {
        return this.setAppearance(PdfName.D, appearance);
    }

    public PdfAnnotation setAppearance(PdfName appearanceType, PdfAnnotationAppearance appearance) {
        return this.setAppearance(appearanceType, (PdfDictionary)appearance.getPdfObject());
    }

    public PdfAnnotation setNormalAppearance(PdfAnnotationAppearance appearance) {
        return this.setAppearance(PdfName.N, appearance);
    }

    public PdfAnnotation setRolloverAppearance(PdfAnnotationAppearance appearance) {
        return this.setAppearance(PdfName.R, appearance);
    }

    public PdfAnnotation setDownAppearance(PdfAnnotationAppearance appearance) {
        return this.setAppearance(PdfName.D, appearance);
    }

    public PdfName getAppearanceState() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.AS);
    }

    public PdfAnnotation setAppearanceState(PdfName as) {
        return this.put(PdfName.AS, as);
    }

    public PdfArray getBorder() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Border);
    }

    public PdfAnnotation setBorder(PdfArray border) {
        return this.put(PdfName.Border, border);
    }

    public PdfArray getColorObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.C);
    }

    public PdfAnnotation setColor(PdfArray color) {
        return this.put(PdfName.C, color);
    }

    public PdfAnnotation setColor(float[] color) {
        return this.setColor(new PdfArray(color));
    }

    public PdfAnnotation setColor(Color color) {
        return this.setColor(new PdfArray(color.getColorValue()));
    }

    public int getStructParentIndex() {
        PdfNumber n = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.StructParent);
        if (n == null) {
            return -1;
        }
        return n.intValue();
    }

    public PdfAnnotation setStructParentIndex(int structParentIndex) {
        return this.put(PdfName.StructParent, new PdfNumber(structParentIndex));
    }

    public boolean getOpen() {
        PdfBoolean open = ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.Open);
        return open != null && open.getValue();
    }

    public PdfAnnotation setOpen(boolean open) {
        return this.put(PdfName.Open, new PdfBoolean(open));
    }

    public PdfArray getQuadPoints() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.QuadPoints);
    }

    public PdfAnnotation setQuadPoints(PdfArray quadPoints) {
        return this.put(PdfName.QuadPoints, quadPoints);
    }

    public PdfAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return this.put(PdfName.BS, borderStyle);
    }

    public PdfAnnotation setBorderStyle(PdfName style) {
        PdfDictionary styleDict = this.getBorderStyle();
        if (null == styleDict) {
            styleDict = new PdfDictionary();
        }
        styleDict.put(PdfName.S, style);
        return this.setBorderStyle(styleDict);
    }

    public PdfAnnotation setDashPattern(PdfArray dashPattern) {
        PdfDictionary styleDict = this.getBorderStyle();
        if (null == styleDict) {
            styleDict = new PdfDictionary();
        }
        styleDict.put(PdfName.D, dashPattern);
        return this.setBorderStyle(styleDict);
    }

    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    public PdfAnnotation setTitle(PdfString title) {
        return this.put(PdfName.T, title);
    }

    public PdfString getTitle() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.T);
    }

    public PdfAnnotation setAppearanceCharacteristics(PdfDictionary characteristics) {
        return this.put(PdfName.MK, characteristics);
    }

    public PdfDictionary getAppearanceCharacteristics() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK);
    }

    public PdfDictionary getAction() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.A);
    }

    public PdfDictionary getAdditionalAction() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AA);
    }

    public PdfAnnotation setRectangle(PdfArray array) {
        return this.put(PdfName.Rect, array);
    }

    public PdfArray getRectangle() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Rect);
    }

    public PdfAnnotation put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    public PdfAnnotation remove(PdfName key) {
        ((PdfDictionary)this.getPdfObject()).remove(key);
        return this;
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }
}

