/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfNumTree;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfPagesTree;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.collection.PdfCollection;
import com.itextpdf.kernel.pdf.layer.PdfOCProperties;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitDestination;
import com.itextpdf.kernel.pdf.navigation.PdfStringDestination;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCatalog
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -1354567597112193418L;
    private final PdfPagesTree pageTree;
    protected Map<PdfName, PdfNameTree> nameTrees = new HashMap<PdfName, PdfNameTree>();
    protected PdfNumTree pageLabels;
    protected PdfOCProperties ocProperties;
    private static final String OutlineRoot = "Outlines";
    private PdfOutline outlines;
    private Map<PdfObject, List<PdfOutline>> pagesWithOutlines = new HashMap<PdfObject, List<PdfOutline>>();
    private boolean outlineMode;

    protected PdfCatalog(PdfDictionary pdfObject) {
        super(pdfObject);
        if (pdfObject == null) {
            throw new PdfException("Document has no PDF Catalog object.");
        }
        PdfCatalog.ensureObjectIsAddedToDocument(pdfObject);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Catalog);
        this.setForbidRelease();
        this.pageTree = new PdfPagesTree(this);
    }

    protected PdfCatalog(PdfDocument pdfDocument) {
        this(new PdfDictionary().makeIndirect(pdfDocument));
    }

    public PdfOCProperties getOCProperties(boolean createIfNotExists) {
        if (this.ocProperties != null) {
            return this.ocProperties;
        }
        PdfDictionary ocPropertiesDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.OCProperties);
        if (ocPropertiesDict != null) {
            if (this.getDocument().getWriter() != null) {
                ocPropertiesDict.makeIndirect(this.getDocument());
            }
            this.ocProperties = new PdfOCProperties(ocPropertiesDict);
        } else if (createIfNotExists) {
            this.ocProperties = new PdfOCProperties(this.getDocument());
        }
        return this.ocProperties;
    }

    public PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    @Override
    public void flush() {
        Logger logger = LoggerFactory.getLogger(PdfDocument.class);
        logger.warn("PdfCatalog cannot be flushed manually");
    }

    public PdfCatalog setOpenAction(PdfDestination destination) {
        return this.put(PdfName.OpenAction, (PdfObject)destination.getPdfObject());
    }

    public PdfCatalog setOpenAction(PdfAction action) {
        return this.put(PdfName.OpenAction, (PdfObject)action.getPdfObject());
    }

    public PdfCatalog setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction(this, key, action);
        return this;
    }

    public PdfCatalog setPageMode(PdfName pageMode) {
        if (pageMode.equals(PdfName.UseNone) || pageMode.equals(PdfName.UseOutlines) || pageMode.equals(PdfName.UseThumbs) || pageMode.equals(PdfName.FullScreen) || pageMode.equals(PdfName.UseOC) || pageMode.equals(PdfName.UseAttachments)) {
            return this.put(PdfName.PageMode, pageMode);
        }
        return this;
    }

    public PdfName getPageMode() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.PageMode);
    }

    public PdfCatalog setPageLayout(PdfName pageLayout) {
        if (pageLayout.equals(PdfName.SinglePage) || pageLayout.equals(PdfName.OneColumn) || pageLayout.equals(PdfName.TwoColumnLeft) || pageLayout.equals(PdfName.TwoColumnRight) || pageLayout.equals(PdfName.TwoPageLeft) || pageLayout.equals(PdfName.TwoPageRight)) {
            return this.put(PdfName.PageLayout, pageLayout);
        }
        return this;
    }

    public PdfName getPageLayout() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.PageLayout);
    }

    public PdfCatalog setViewerPreferences(PdfViewerPreferences preferences) {
        return this.put(PdfName.ViewerPreferences, (PdfObject)preferences.getPdfObject());
    }

    public PdfViewerPreferences getViewerPreferences() {
        PdfDictionary viewerPreferences = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.ViewerPreferences);
        if (viewerPreferences != null) {
            return new PdfViewerPreferences(viewerPreferences);
        }
        return null;
    }

    public PdfNameTree getNameTree(PdfName treeType) {
        PdfNameTree tree = this.nameTrees.get(treeType);
        if (tree == null) {
            tree = new PdfNameTree(this, treeType);
            this.nameTrees.put(treeType, tree);
        }
        return tree;
    }

    public PdfNumTree getPageLabelsTree(boolean createIfNotExists) {
        if (this.pageLabels == null && (((PdfDictionary)this.getPdfObject()).containsKey(PdfName.PageLabels) || createIfNotExists)) {
            this.pageLabels = new PdfNumTree(this, PdfName.PageLabels);
        }
        return this.pageLabels;
    }

    public void setLang(PdfString lang) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Lang, lang);
    }

    public PdfString getLang(PdfName lang) {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Lang);
    }

    public void addDeveloperExtension(PdfDeveloperExtension extension) {
        PdfDictionary extensions = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Extensions);
        if (extensions == null) {
            extensions = new PdfDictionary();
            this.put(PdfName.Extensions, extensions);
        } else {
            PdfDictionary existingExtensionDict = extensions.getAsDictionary(extension.getPrefix());
            int diff = extension.getBaseVersion().compareTo(existingExtensionDict.getAsName(PdfName.BaseVersion));
            if (diff < 0) {
                return;
            }
            diff = extension.getExtensionLevel() - existingExtensionDict.getAsNumber(PdfName.ExtensionLevel).intValue();
            if (diff <= 0) {
                return;
            }
        }
        extensions.put(extension.getPrefix(), extension.getDeveloperExtensions());
    }

    public PdfCatalog setCollection(PdfCollection collection) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Collection, (PdfObject)collection.getPdfObject());
        return this;
    }

    public PdfCatalog put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    public PdfCatalog remove(PdfName key) {
        ((PdfDictionary)this.getPdfObject()).remove(key);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected boolean isOCPropertiesMayHaveChanged() {
        return this.ocProperties != null;
    }

    PdfPagesTree getPageTree() {
        return this.pageTree;
    }

    Map<PdfObject, List<PdfOutline>> getPagesWithOutlines() {
        return this.pagesWithOutlines;
    }

    void addNamedDestination(String key, PdfObject value) {
        this.addNameToNameTree(key, value, PdfName.Dests);
    }

    void addNameToNameTree(String key, PdfObject value, PdfName treeType) {
        this.getNameTree(treeType).addEntry(key, value);
    }

    PdfOutline getOutlines(boolean updateOutlines) {
        if (this.outlines != null && !updateOutlines) {
            return this.outlines;
        }
        if (this.outlines != null) {
            this.outlines.clear();
            this.pagesWithOutlines.clear();
        }
        this.outlineMode = true;
        PdfNameTree destsTree = this.getNameTree(PdfName.Dests);
        PdfDictionary outlineRoot = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Outlines);
        if (outlineRoot == null) {
            if (null == this.getDocument().getWriter()) {
                return null;
            }
            this.outlines = new PdfOutline(this.getDocument());
        } else {
            this.outlines = new PdfOutline(OutlineRoot, outlineRoot, this.getDocument());
            this.getNextItem(outlineRoot.getAsDictionary(PdfName.First), this.outlines, destsTree.getNames());
        }
        return this.outlines;
    }

    boolean hasOutlines() {
        return ((PdfDictionary)this.getPdfObject()).containsKey(PdfName.Outlines);
    }

    boolean isOutlineMode() {
        return this.outlineMode;
    }

    void removeOutlines(PdfPage page) {
        if (this.getDocument().getWriter() == null) {
            return;
        }
        if (this.hasOutlines()) {
            this.getOutlines(false);
            if (this.pagesWithOutlines.size() > 0 && this.pagesWithOutlines.get(page.getPdfObject()) != null) {
                for (PdfOutline outline : this.pagesWithOutlines.get(page.getPdfObject())) {
                    outline.removeOutline();
                }
            }
        }
    }

    void addRootOutline(PdfOutline outline) {
        if (!this.outlineMode) {
            return;
        }
        if (this.pagesWithOutlines.size() == 0) {
            this.put(PdfName.Outlines, outline.getContent());
        }
    }

    PdfDestination copyDestination(PdfObject dest, Map<PdfPage, PdfPage> page2page, PdfDocument toDocument) {
        PdfDestination d;
        block3: {
            String name;
            PdfNameTree destsTree;
            Map<String, PdfObject> dests;
            PdfArray array;
            block2: {
                d = null;
                if (!dest.isArray()) break block2;
                PdfObject pageObject = ((PdfArray)dest).get(0);
                for (PdfPage oldPage : page2page.keySet()) {
                    if (oldPage.getPdfObject() != pageObject) continue;
                    PdfArray array2 = new PdfArray((PdfArray)dest);
                    array2.set(0, (PdfObject)page2page.get(oldPage).getPdfObject());
                    d = new PdfExplicitDestination(array2);
                }
                break block3;
            }
            if (!dest.isString() || (array = (PdfArray)(dests = (destsTree = this.getNameTree(PdfName.Dests)).getNames()).get(name = ((PdfString)dest).toUnicodeString())) == null) break block3;
            PdfObject pageObject = array.get(0);
            for (PdfPage oldPage : page2page.keySet()) {
                if (oldPage.getPdfObject() != pageObject) continue;
                array.set(0, (PdfObject)page2page.get(oldPage).getPdfObject());
                d = new PdfStringDestination(name);
                toDocument.addNamedDestination(name, array);
            }
        }
        return d;
    }

    private void addOutlineToPage(PdfOutline outline, Map<String, PdfObject> names) {
        PdfObject pageObj = outline.getDestination().getDestinationPage(names);
        if (pageObj != null) {
            List<PdfOutline> outs = this.pagesWithOutlines.get(pageObj);
            if (outs == null) {
                outs = new ArrayList<PdfOutline>();
                this.pagesWithOutlines.put(pageObj, outs);
            }
            outs.add(outline);
        }
    }

    private void getNextItem(PdfDictionary item, PdfOutline parent, Map<String, PdfObject> names) {
        if (null == item) {
            return;
        }
        PdfOutline outline = new PdfOutline(item.getAsString(PdfName.Title).toUnicodeString(), item, parent);
        PdfObject dest = item.get(PdfName.Dest);
        if (dest != null) {
            PdfDestination destination = PdfDestination.makeDestination(dest);
            outline.setDestination(destination);
            this.addOutlineToPage(outline, names);
        }
        parent.getAllChildren().add(outline);
        PdfDictionary processItem = item.getAsDictionary(PdfName.First);
        if (processItem != null) {
            this.getNextItem(processItem, outline, names);
        }
        if ((processItem = item.getAsDictionary(PdfName.Next)) != null) {
            this.getNextItem(processItem, parent, names);
        }
    }
}

