/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IPdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfMcrNumber;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.BackedAccessibleProperties;
import com.itextpdf.kernel.pdf.tagutils.DummyAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagReference;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TagTreePointer
implements Serializable {
    private static final long serialVersionUID = 3774218733446157411L;
    private TagStructureContext tagStructureContext;
    private PdfStructElem currentStructElem;
    private PdfPage currentPage;
    private PdfStream contentStream;
    private int nextNewKidIndex = -1;

    public TagTreePointer(PdfDocument document) {
        this.tagStructureContext = document.getTagStructureContext();
        this.setCurrentStructElem(this.tagStructureContext.getRootTag());
    }

    public TagTreePointer(TagTreePointer tagPointer) {
        this.tagStructureContext = tagPointer.tagStructureContext;
        this.setCurrentStructElem(tagPointer.getCurrentStructElem());
        this.currentPage = tagPointer.currentPage;
        this.contentStream = tagPointer.contentStream;
    }

    public TagTreePointer setPageForTagging(PdfPage page) {
        if (page.isFlushed()) {
            throw new PdfException("The page has been already flushed.");
        }
        this.currentPage = page;
        return this;
    }

    public PdfPage getCurrentPage() {
        return this.currentPage;
    }

    public TagTreePointer setContentStreamForTagging(PdfStream contentStream) {
        this.contentStream = contentStream;
        return this;
    }

    public PdfStream getCurrentContentStream() {
        return this.contentStream;
    }

    public PdfDocument getDocument() {
        return this.tagStructureContext.getDocument();
    }

    public TagTreePointer addTag(PdfName role) {
        this.addTag(-1, role);
        return this;
    }

    public TagTreePointer addTag(int index, PdfName role) {
        this.addTag(index, new DummyAccessibleElement(role, null));
        return this;
    }

    public TagTreePointer addTag(IAccessibleElement element) {
        this.addTag(element, false);
        return this;
    }

    public TagTreePointer addTag(IAccessibleElement element, boolean keepConnectedToTag) {
        this.addTag(-1, element, keepConnectedToTag);
        return this;
    }

    public TagTreePointer addTag(int index, IAccessibleElement element) {
        this.addTag(index, element, false);
        return this;
    }

    public TagTreePointer addTag(int index, IAccessibleElement element, boolean keepConnectedToTag) {
        this.tagStructureContext.throwExceptionIfRoleIsInvalid(element.getRole());
        if (!this.tagStructureContext.isElementConnectedToTag(element)) {
            this.setNextNewKidIndex(index);
            this.setCurrentStructElem(this.addNewKid(element, keepConnectedToTag));
        } else {
            PdfStructElem connectedStruct = this.tagStructureContext.getStructConnectedToModel(element);
            if (connectedStruct.getParent() != null && this.getCurrentStructElem().getPdfObject() == ((PdfStructElem)connectedStruct.getParent()).getPdfObject()) {
                this.setCurrentStructElem(connectedStruct);
            } else {
                this.tagStructureContext.removeElementConnectionToTag(element);
                this.setNextNewKidIndex(index);
                this.setCurrentStructElem(this.addNewKid(element, keepConnectedToTag));
            }
        }
        return this;
    }

    public TagTreePointer addAnnotationTag(PdfAnnotation annotation) {
        this.throwExceptionIfCurrentPageIsNotInited();
        PdfObjRef kid = new PdfObjRef(annotation, this.getCurrentStructElem());
        if (!this.ensureElementPageEqualsKidPage(this.getCurrentStructElem(), (PdfDictionary)this.currentPage.getPdfObject())) {
            ((PdfDictionary)kid.getPdfObject()).put(PdfName.Pg, (PdfObject)this.currentPage.getPdfObject());
        }
        this.addNewKid(kid);
        return this;
    }

    public TagTreePointer setNextNewKidIndex(int nextNewKidIndex) {
        if (nextNewKidIndex > -1) {
            this.nextNewKidIndex = nextNewKidIndex;
        }
        return this;
    }

    public boolean isElementConnectedToTag(IAccessibleElement element) {
        return this.tagStructureContext.isElementConnectedToTag(element);
    }

    public TagStructureContext removeElementConnectionToTag(IAccessibleElement element) {
        return this.tagStructureContext.removeElementConnectionToTag(element);
    }

    public TagTreePointer removeTag() {
        IPdfStructElem parentElem = this.getCurrentStructElem().getParent();
        if (parentElem instanceof PdfStructTreeRoot) {
            throw new PdfException("Cannot remove document root tag.");
        }
        List<IPdfStructElem> kids = this.getCurrentStructElem().getKids();
        PdfStructElem parent = (PdfStructElem)parentElem;
        if (parent.isFlushed()) {
            throw new PdfException("Cannot remove tag, because its parent is flushed.");
        }
        int removedKidIndex = parent.removeKid(this.getCurrentStructElem());
        ((PdfDictionary)this.getCurrentStructElem().getPdfObject()).getIndirectReference().setFree();
        for (IPdfStructElem kid : kids) {
            if (kid instanceof PdfStructElem) {
                parent.addKid(removedKidIndex++, (PdfStructElem)kid);
                continue;
            }
            PdfMcr mcr = this.prepareMcrForMovingToNewParent((PdfMcr)kid, parent);
            parent.addKid(removedKidIndex++, mcr);
        }
        this.setCurrentStructElem(parent);
        return this;
    }

    public TagTreePointer relocateKid(int kidIndex, TagTreePointer pointerToNewParent) {
        if (this.getDocument() != pointerToNewParent.getDocument()) {
            throw new PdfException("Tag cannot be moved to the another document's tag structure.");
        }
        IPdfStructElem removedKid = this.getCurrentStructElem().removeKid(kidIndex);
        if (removedKid instanceof PdfStructElem) {
            pointerToNewParent.addNewKid((PdfStructElem)removedKid);
        } else if (removedKid instanceof PdfMcr) {
            PdfMcr mcrKid = this.prepareMcrForMovingToNewParent((PdfMcr)removedKid, pointerToNewParent.getCurrentStructElem());
            pointerToNewParent.addNewKid(mcrKid);
        }
        return this;
    }

    public TagReference getTagReference() {
        return this.getTagReference(-1);
    }

    public TagReference getTagReference(int index) {
        return new TagReference(this.getCurrentStructElem(), this, index);
    }

    public TagTreePointer moveToRoot() {
        this.setCurrentStructElem(this.tagStructureContext.getRootTag());
        return this;
    }

    public TagTreePointer moveToParent() {
        if (this.getCurrentStructElem().getPdfObject() == this.tagStructureContext.getRootTag().getPdfObject()) {
            throw new PdfException("Cannot move to parent current element is root.");
        }
        IPdfStructElem parent = this.getCurrentStructElem().getParent();
        if (parent == null) {
            this.moveToRoot();
        } else {
            this.setCurrentStructElem((PdfStructElem)parent);
        }
        return this;
    }

    public TagTreePointer moveToKid(int kidIndex) {
        IPdfStructElem kid = this.getCurrentStructElem().getKids().get(kidIndex);
        if (!(kid instanceof PdfStructElem)) {
            if (kid instanceof PdfMcr) {
                throw new PdfException("Cannot move to marked content reference.");
            }
            throw new PdfException("Cannot move to flushed kid.");
        }
        this.setCurrentStructElem((PdfStructElem)kid);
        return this;
    }

    public TagTreePointer moveToKid(PdfName role) {
        this.moveToKid(0, role);
        return this;
    }

    public TagTreePointer moveToKid(int n, PdfName role) {
        if (PdfName.MCR.equals(role)) {
            throw new PdfException("Cannot move to marked content reference.");
        }
        List<IPdfStructElem> kids = this.getCurrentStructElem().getKids();
        int k = 0;
        for (int i = 0; i < kids.size(); ++i) {
            if (kids.get(i) == null || !kids.get(i).getRole().equals(role) || kids.get(i) instanceof PdfMcr || k++ != n) continue;
            this.moveToKid(i);
            return this;
        }
        throw new PdfException("No kid with such role.");
    }

    public TagTreePointer moveToTag(IAccessibleElement element) {
        this.tagStructureContext.moveTagPointerToTag(element, this);
        return this;
    }

    public List<PdfName> getKidsRoles() {
        ArrayList<PdfName> roles = new ArrayList<PdfName>();
        List<IPdfStructElem> kids = this.getCurrentStructElem().getKids();
        for (IPdfStructElem kid : kids) {
            if (kid == null) {
                roles.add(null);
                continue;
            }
            if (kid instanceof PdfStructElem) {
                roles.add(kid.getRole());
                continue;
            }
            roles.add(PdfName.MCR);
        }
        return roles;
    }

    public TagTreePointer flushTag() {
        if (this.getCurrentStructElem().getPdfObject() == this.tagStructureContext.getRootTag().getPdfObject()) {
            throw new PdfException("Cannot flush document root tag before document is closed.");
        }
        IPdfStructElem parent = this.tagStructureContext.flushTag(this.getCurrentStructElem());
        if (parent != null) {
            this.setCurrentStructElem((PdfStructElem)parent);
        } else {
            this.setCurrentStructElem(this.tagStructureContext.getRootTag());
        }
        return this;
    }

    public IAccessibleElement getConnectedElement(boolean createIfNotExist) {
        IAccessibleElement element = this.tagStructureContext.getModelConnectedToStruct(this.getCurrentStructElem());
        if (element == null && createIfNotExist) {
            element = new DummyAccessibleElement(this.getRole(), this.getProperties());
            this.tagStructureContext.saveConnectionBetweenStructAndModel(element, this.getCurrentStructElem());
        }
        return element;
    }

    public AccessibilityProperties getProperties() {
        PdfStructElem currElem = this.getCurrentStructElem();
        IAccessibleElement model = this.tagStructureContext.getModelConnectedToStruct(currElem);
        if (model != null) {
            return model.getAccessibilityProperties();
        }
        return new BackedAccessibleProperties(currElem);
    }

    public PdfName getRole() {
        IAccessibleElement model = this.tagStructureContext.getModelConnectedToStruct(this.getCurrentStructElem());
        if (model != null) {
            return model.getRole();
        }
        return this.getCurrentStructElem().getRole();
    }

    public TagTreePointer setRole(PdfName role) {
        IAccessibleElement connectedElement = this.tagStructureContext.getModelConnectedToStruct(this.getCurrentStructElem());
        if (connectedElement != null) {
            connectedElement.setRole(role);
        } else {
            this.getCurrentStructElem().setRole(role);
        }
        return this;
    }

    int createNextMcidForStructElem(PdfStructElem elem, int index) {
        PdfMcr mcr;
        this.throwExceptionIfCurrentPageIsNotInited();
        if (!this.markedContentNotInPageStream() && this.ensureElementPageEqualsKidPage(elem, (PdfDictionary)this.currentPage.getPdfObject())) {
            mcr = new PdfMcrNumber(this.currentPage, elem);
        } else {
            mcr = new PdfMcrDictionary(this.currentPage, elem);
            if (this.markedContentNotInPageStream()) {
                ((PdfDictionary)mcr.getPdfObject()).put(PdfName.Stm, this.contentStream);
            }
        }
        elem.addKid(index, mcr);
        return mcr.getMcid();
    }

    TagTreePointer setCurrentStructElem(PdfStructElem structElem) {
        this.currentStructElem = structElem;
        return this;
    }

    PdfStructElem getCurrentStructElem() {
        if (this.currentStructElem.isFlushed()) {
            throw new PdfException("TagTreePointer is in invalid state: it points at flushed element. Use TagTreePointer#moveToRoot.");
        }
        if (((PdfDictionary)this.currentStructElem.getPdfObject()).getIndirectReference() == null) {
            throw new PdfException("TagTreePointer is in invalid state: it points at removed element use TagTreePointer#moveToRoot.");
        }
        return this.currentStructElem;
    }

    private int getNextNewKidPosition() {
        int nextPos = this.nextNewKidIndex;
        this.nextNewKidIndex = -1;
        return nextPos;
    }

    private PdfStructElem addNewKid(IAccessibleElement element, boolean keepConnectedToTag) {
        PdfStructElem kid = new PdfStructElem(this.getDocument(), element.getRole());
        if (keepConnectedToTag) {
            this.tagStructureContext.saveConnectionBetweenStructAndModel(element, kid);
        }
        if (!keepConnectedToTag && element.getAccessibilityProperties() != null) {
            element.getAccessibilityProperties().setToStructElem(kid);
        }
        return this.addNewKid(kid);
    }

    private PdfStructElem addNewKid(PdfStructElem kid) {
        return this.getCurrentStructElem().addKid(this.getNextNewKidPosition(), kid);
    }

    private PdfMcr addNewKid(PdfMcr kid) {
        return this.getCurrentStructElem().addKid(this.getNextNewKidPosition(), kid);
    }

    private PdfMcr prepareMcrForMovingToNewParent(PdfMcr mcrKid, PdfStructElem newParent) {
        Object mcrObject = mcrKid.getPdfObject();
        PdfDictionary mcrPage = mcrKid.getPageObject();
        PdfDictionary mcrDict = null;
        if (!((PdfObject)mcrObject).isNumber()) {
            mcrDict = (PdfDictionary)mcrObject;
        }
        if (!(mcrDict != null && mcrDict.containsKey(PdfName.Pg) || this.ensureElementPageEqualsKidPage(newParent, mcrPage))) {
            if (mcrDict == null) {
                mcrDict = new PdfDictionary();
                mcrDict.put(PdfName.Type, PdfName.MCR);
                mcrDict.put(PdfName.MCID, (PdfObject)mcrKid.getPdfObject());
            }
            mcrDict.put(PdfName.Pg, mcrPage);
        }
        if (mcrDict != null) {
            if (PdfName.MCR.equals(mcrDict.get(PdfName.Type))) {
                mcrKid = new PdfMcrDictionary(mcrDict, newParent);
            } else if (PdfName.OBJR.equals(mcrDict.get(PdfName.Type))) {
                mcrKid = new PdfObjRef(mcrDict, newParent);
            }
        } else {
            mcrKid = new PdfMcrNumber((PdfNumber)mcrObject, newParent);
        }
        return mcrKid;
    }

    private boolean ensureElementPageEqualsKidPage(PdfStructElem elem, PdfDictionary kidPage) {
        PdfObject pageObject = ((PdfDictionary)elem.getPdfObject()).get(PdfName.Pg);
        if (pageObject == null) {
            pageObject = kidPage;
            ((PdfDictionary)elem.getPdfObject()).put(PdfName.Pg, kidPage);
        }
        return kidPage.equals(pageObject);
    }

    private boolean markedContentNotInPageStream() {
        return this.contentStream != null;
    }

    private void throwExceptionIfCurrentPageIsNotInited() {
        if (this.currentPage == null) {
            throw new PdfException("Page is not set for the pdf tag structure.");
        }
    }
}

