/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.xmp.options;

import com.itextpdf.kernel.xmp.XMPException;
import java.util.HashMap;
import java.util.Map;

public abstract class Options {
    private int options = 0;
    private Map optionNames = null;

    public Options() {
    }

    public Options(int options) throws XMPException {
        this.assertOptionsValid(options);
        this.setOptions(options);
    }

    public void clear() {
        this.options = 0;
    }

    public boolean isExactly(int optionBits) {
        return this.getOptions() == optionBits;
    }

    public boolean containsAllOptions(int optionBits) {
        return (this.getOptions() & optionBits) == optionBits;
    }

    public boolean containsOneOf(int optionBits) {
        return (this.getOptions() & optionBits) != 0;
    }

    protected boolean getOption(int optionBit) {
        return (this.options & optionBit) != 0;
    }

    public void setOption(int optionBits, boolean value) {
        this.options = value ? this.options | optionBits : this.options & ~optionBits;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) throws XMPException {
        this.assertOptionsValid(options);
        this.options = options;
    }

    public boolean equals(Object obj) {
        return this.getOptions() == ((Options)obj).getOptions();
    }

    public int hashCode() {
        return this.getOptions();
    }

    public String getOptionsString() {
        if (this.options != 0) {
            StringBuffer sb = new StringBuffer();
            int theBits = this.options;
            while (theBits != 0) {
                int oneLessBit = theBits & theBits - 1;
                int singleBit = theBits ^ oneLessBit;
                String bitName = this.getOptionName(singleBit);
                sb.append(bitName);
                if (oneLessBit != 0) {
                    sb.append(" | ");
                }
                theBits = oneLessBit;
            }
            return sb.toString();
        }
        return "<none>";
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.options);
    }

    protected abstract int getValidOptions();

    protected abstract String defineOptionName(int var1);

    protected void assertConsistency(int options) throws XMPException {
    }

    private void assertOptionsValid(int options) throws XMPException {
        int invalidOptions = options & ~this.getValidOptions();
        if (invalidOptions != 0) {
            throw new XMPException("The option bit(s) 0x" + Integer.toHexString(invalidOptions) + " are invalid!", 103);
        }
        this.assertConsistency(options);
    }

    private String getOptionName(int option) {
        Integer key;
        Map optionsNames = this.procureOptionNames();
        String result = (String)optionsNames.get(key = new Integer(option));
        if (result == null) {
            result = this.defineOptionName(option);
            if (result != null) {
                optionsNames.put(key, result);
            } else {
                result = "<option name not defined>";
            }
        }
        return result;
    }

    private Map procureOptionNames() {
        if (this.optionNames == null) {
            this.optionNames = new HashMap();
        }
        return this.optionNames;
    }
}

