/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.color.DeviceCmyk;
import com.itextpdf.kernel.color.DeviceGray;
import com.itextpdf.kernel.color.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPopupAnnotation;

public abstract class PdfMarkupAnnotation
extends PdfAnnotation {
    private static final long serialVersionUID = 239280278775576458L;
    protected PdfAnnotation inReplyTo = null;
    protected PdfPopupAnnotation popup = null;

    protected PdfMarkupAnnotation(Rectangle rect) {
        super(rect);
    }

    protected PdfMarkupAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfString getText() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.T);
    }

    public PdfMarkupAnnotation setText(PdfString text) {
        return (PdfMarkupAnnotation)this.put(PdfName.T, text);
    }

    public PdfNumber getOpacity() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.CA);
    }

    public PdfMarkupAnnotation setOpacity(PdfNumber ca) {
        return (PdfMarkupAnnotation)this.put(PdfName.CA, ca);
    }

    public PdfObject getRichText() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.RC);
    }

    public PdfMarkupAnnotation setRichText(PdfObject richText) {
        return (PdfMarkupAnnotation)this.put(PdfName.RC, richText);
    }

    public PdfString getCreationDate() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.CreationDate);
    }

    public PdfMarkupAnnotation setCreationDate(PdfString creationDate) {
        return (PdfMarkupAnnotation)this.put(PdfName.CreationDate, creationDate);
    }

    public PdfDictionary getInReplyToObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.IRT);
    }

    public PdfAnnotation getInReplyTo() {
        return this.inReplyTo;
    }

    public PdfMarkupAnnotation setInReplyTo(PdfAnnotation inReplyTo) {
        this.inReplyTo = inReplyTo;
        return (PdfMarkupAnnotation)this.put(PdfName.IRT, (PdfObject)inReplyTo.getPdfObject());
    }

    public PdfMarkupAnnotation setPopup(PdfPopupAnnotation popup) {
        this.popup = popup;
        popup.put(PdfName.Parent, (PdfObject)this.getPdfObject());
        return (PdfMarkupAnnotation)this.put(PdfName.Popup, (PdfObject)popup.getPdfObject());
    }

    public PdfDictionary getPopupObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Popup);
    }

    public PdfPopupAnnotation getPopup() {
        return this.popup;
    }

    public PdfString getSubject() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Subj);
    }

    public PdfMarkupAnnotation setSubject(PdfString subject) {
        return (PdfMarkupAnnotation)this.put(PdfName.Subj, subject);
    }

    public PdfName getReplyType() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.RT);
    }

    public PdfMarkupAnnotation setReplyType(PdfName replyType) {
        return (PdfMarkupAnnotation)this.put(PdfName.RT, replyType);
    }

    public PdfName getIntent() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.IT);
    }

    public PdfMarkupAnnotation setIntent(PdfName intent) {
        return (PdfMarkupAnnotation)this.put(PdfName.IT, intent);
    }

    public PdfDictionary getExternalData() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.ExData);
    }

    public PdfMarkupAnnotation setExternalData(PdfName exData) {
        return (PdfMarkupAnnotation)this.put(PdfName.ExData, exData);
    }

    public PdfMarkupAnnotation setRectangleDifferences(PdfArray rect) {
        return (PdfMarkupAnnotation)this.put(PdfName.RD, rect);
    }

    public PdfArray getRectangleDifferences() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.RD);
    }

    public PdfDictionary getBorderEffect() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BE);
    }

    public PdfMarkupAnnotation setBorderEffect(PdfDictionary borderEffect) {
        return (PdfMarkupAnnotation)this.put(PdfName.BE, borderEffect);
    }

    public Color getInteriorColor() {
        PdfArray color = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.IC);
        if (color == null) {
            return null;
        }
        switch (color.size()) {
            case 1: {
                return new DeviceGray(color.getAsNumber(0).floatValue());
            }
            case 3: {
                return new DeviceRgb(color.getAsNumber(0).floatValue(), color.getAsNumber(1).floatValue(), color.getAsNumber(2).floatValue());
            }
            case 4: {
                return new DeviceCmyk(color.getAsNumber(0).floatValue(), color.getAsNumber(1).floatValue(), color.getAsNumber(2).floatValue(), color.getAsNumber(3).floatValue());
            }
        }
        return null;
    }

    public PdfMarkupAnnotation setInteriorColor(PdfArray interiorColor) {
        return (PdfMarkupAnnotation)this.put(PdfName.IC, interiorColor);
    }

    public PdfMarkupAnnotation setInteriorColor(float[] interiorColor) {
        return this.setInteriorColor(new PdfArray(interiorColor));
    }

    public PdfName getIconName() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Name);
    }

    public PdfMarkupAnnotation setIconName(PdfName name) {
        return (PdfMarkupAnnotation)this.put(PdfName.Name, name);
    }

    public PdfMarkupAnnotation setDefaultAppearance(PdfString appearanceString) {
        return (PdfMarkupAnnotation)this.put(PdfName.DA, appearanceString);
    }

    public PdfString getDefaultAppearance() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
    }

    public int getJustification() {
        PdfNumber q = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Q);
        return q == null ? 0 : q.intValue();
    }

    public PdfMarkupAnnotation setJustification(int justification) {
        return (PdfMarkupAnnotation)this.put(PdfName.Q, new PdfNumber(justification));
    }
}

