/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfName;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class PdfVersion
implements Comparable<PdfVersion>,
Serializable {
    private static final long serialVersionUID = 6168855906667968169L;
    private static final List<PdfVersion> values = new ArrayList<PdfVersion>();
    public static final PdfVersion PDF_1_0 = PdfVersion.createPdfVersion(1, 0);
    public static final PdfVersion PDF_1_1 = PdfVersion.createPdfVersion(1, 0);
    public static final PdfVersion PDF_1_2 = PdfVersion.createPdfVersion(1, 2);
    public static final PdfVersion PDF_1_3 = PdfVersion.createPdfVersion(1, 3);
    public static final PdfVersion PDF_1_4 = PdfVersion.createPdfVersion(1, 4);
    public static final PdfVersion PDF_1_5 = PdfVersion.createPdfVersion(1, 5);
    public static final PdfVersion PDF_1_6 = PdfVersion.createPdfVersion(1, 6);
    public static final PdfVersion PDF_1_7 = PdfVersion.createPdfVersion(1, 7);
    public static final PdfVersion PDF_2_0 = PdfVersion.createPdfVersion(2, 0);
    private int major;
    private int minor;

    private PdfVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public String toString() {
        return MessageFormat.format("PDF-{0}.{1}", this.major, this.minor);
    }

    public PdfName toPdfName() {
        return new PdfName(MessageFormat.format("{0}.{1}", this.major, this.minor));
    }

    public static PdfVersion fromString(String value) {
        for (PdfVersion version : values) {
            if (!version.toString().equals(value)) continue;
            return version;
        }
        throw new IllegalArgumentException("The provided pdf version was not found.");
    }

    public static PdfVersion fromPdfName(PdfName name) {
        for (PdfVersion version : values) {
            if (!version.toPdfName().equals(name)) continue;
            return version;
        }
        throw new IllegalArgumentException("The provided pdf version was not found.");
    }

    @Override
    public int compareTo(PdfVersion o) {
        int majorResult = Integer.compare(this.major, o.major);
        if (majorResult != 0) {
            return majorResult;
        }
        return Integer.compare(this.minor, o.minor);
    }

    private static PdfVersion createPdfVersion(int major, int minor) {
        PdfVersion pdfVersion = new PdfVersion(major, minor);
        values.add(pdfVersion);
        return pdfVersion;
    }
}

