/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import java.io.IOException;
import java.io.OutputStream;

class PdfObjectStream
extends PdfStream {
    private static final long serialVersionUID = -3513488307665597642L;
    public static final int MAX_OBJ_STREAM_SIZE = 200;
    protected PdfNumber size = new PdfNumber(0);
    protected PdfOutputStream indexStream = new PdfOutputStream((OutputStream)new ByteArrayOutputStream());

    public PdfObjectStream(PdfDocument doc) {
        this.makeIndirect(doc);
        this.getOutputStream().document = doc;
        this.put(PdfName.Type, PdfName.ObjStm);
        this.put(PdfName.N, this.size);
        this.put(PdfName.First, new PdfNumber(this.indexStream.getCurrentPos()));
    }

    PdfObjectStream(PdfObjectStream prev) {
        this(prev.getIndirectReference().getDocument());
        ByteArrayOutputStream prevOutputStream = (ByteArrayOutputStream)prev.getOutputStream().getOutputStream();
        prevOutputStream.reset();
        this.initOutputStream((OutputStream)prevOutputStream);
        ByteArrayOutputStream prevIndexStream = (ByteArrayOutputStream)this.indexStream.getOutputStream();
        prevIndexStream.reset();
        this.indexStream = new PdfOutputStream((OutputStream)prevIndexStream);
    }

    public void addObject(PdfObject object) {
        if (this.size.intValue() == 200) {
            throw new PdfException("pdf.object.stream.reach.max.size");
        }
        PdfOutputStream outputStream = this.getOutputStream();
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.indexStream.writeInteger(object.getIndirectReference().getObjNumber()))).writeSpace())).writeLong(outputStream.getCurrentPos()))).writeSpace();
        outputStream.write(object);
        object.getIndirectReference().setObjStreamNumber(this.getIndirectReference().getObjNumber());
        object.getIndirectReference().setIndex(this.size.intValue());
        outputStream.writeSpace();
        this.size.increment();
        ((PdfNumber)this.get(PdfName.First)).setValue(this.indexStream.getCurrentPos());
    }

    public int getSize() {
        return this.size.intValue();
    }

    public PdfOutputStream getIndexStream() {
        return this.indexStream;
    }

    @Override
    protected void releaseContent() {
        this.releaseContent(false);
    }

    private void releaseContent(boolean close) {
        if (close) {
            super.releaseContent();
            try {
                this.indexStream.close();
            }
            catch (IOException e) {
                throw new PdfException("io.exception", e);
            }
            this.indexStream = null;
        }
    }
}

