/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.CidFont;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.font.PdfType1Font;
import com.itextpdf.kernel.font.PdfType3Font;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import java.io.IOException;
import java.util.Set;

public final class PdfFontFactory {
    private static String DEFAULT_ENCODING = "Cp1252";
    private static boolean DEFAULT_EMBEDDING = false;
    private static boolean DEFAULT_CACHED = false;

    public static PdfFont createFont() throws IOException {
        return PdfFontFactory.createFont("Helvetica", "Cp1252");
    }

    public static PdfFont createFont(PdfDictionary fontDictionary) {
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type1, false)) {
            return new PdfType1Font(fontDictionary);
        }
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type0, false)) {
            return new PdfType0Font(fontDictionary);
        }
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.TrueType, false)) {
            return new PdfTrueTypeFont(fontDictionary);
        }
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type3, false)) {
            return new PdfType3Font(fontDictionary);
        }
        throw new PdfException("dict.not.contain.font.data");
    }

    public static PdfFont createFont(String path) throws IOException {
        return PdfFontFactory.createFont(path, null, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(String path, String encoding) throws IOException {
        return PdfFontFactory.createFont(path, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createTtcFont(byte[] ttc, int ttcIndex, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont((byte[])ttc, (int)ttcIndex, (boolean)cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createTtcFont(String ttcPath, int ttcIndex, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont((String)ttcPath, (int)ttcIndex, (boolean)cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createFont(String path, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(path, null, embedded);
    }

    public static PdfFont createFont(String path, String encoding, boolean embedded) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont((String)path);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding, boolean embedded) throws IOException {
        if (fontProgram == null) {
            return null;
        }
        if (fontProgram instanceof Type1Font) {
            return new PdfType1Font((Type1Font)fontProgram, encoding, embedded);
        }
        if (fontProgram instanceof TrueTypeFont) {
            if ("Identity-H".equals(encoding) || "Identity-V".equals(encoding)) {
                return new PdfType0Font((TrueTypeFont)fontProgram, encoding);
            }
            return new PdfTrueTypeFont((TrueTypeFont)fontProgram, encoding, embedded);
        }
        if (fontProgram instanceof CidFont) {
            if (((CidFont)fontProgram).compatibleWith(encoding)) {
                return new PdfType0Font((CidFont)fontProgram, encoding);
            }
            return null;
        }
        return null;
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(FontProgram fontProgram) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING);
    }

    public static PdfFont createFont(byte[] font, String encoding) throws IOException {
        return PdfFontFactory.createFont(font, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(byte[] font, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(font, null, embedded);
    }

    public static PdfFont createFont(byte[] font, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(font, encoding, embedded, DEFAULT_CACHED);
    }

    public static PdfFont createFont(byte[] font, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont(null, (byte[])font, (boolean)cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfType3Font createType3Font(PdfDocument document, boolean colorized) throws IOException {
        return new PdfType3Font(document, colorized);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded, int style, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createRegisteredFont((String)font, (int)style, (boolean)cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded, boolean cached) throws IOException {
        return PdfFontFactory.createRegisteredFont(font, encoding, embedded, -1, cached);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createRegisteredFont(font, encoding, embedded, -1);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded, int style) throws IOException {
        return PdfFontFactory.createRegisteredFont(font, encoding, embedded, style, DEFAULT_CACHED);
    }

    public static PdfFont createRegisteredFont(String font, String encoding) throws IOException {
        return PdfFontFactory.createRegisteredFont(font, encoding, false, -1);
    }

    public static PdfFont createRegisteredFont(String fontName) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, null, false, -1);
    }

    public static void registerFamily(String familyName, String fullName, String path) {
        FontProgramFactory.registerFontFamily((String)familyName, (String)fullName, (String)path);
    }

    public static void register(String path) {
        PdfFontFactory.register(path, null);
    }

    public static void register(String path, String alias) {
        FontProgramFactory.registerFont((String)path, (String)alias);
    }

    public static int registerDirectory(String dir) {
        return FontProgramFactory.registerFontDirectory((String)dir);
    }

    public static int registerSystemDirectories() {
        return FontProgramFactory.registerSystemFontDirectories();
    }

    public static Set<String> getRegisteredFonts() {
        return FontProgramFactory.getRegisteredFonts();
    }

    public static Set<String> getRegisteredFamilies() {
        return FontProgramFactory.getRegisteredFontFamilies();
    }

    public static boolean isRegistered(String fontname) {
        return FontProgramFactory.isRegisteredFont((String)fontname);
    }

    protected static boolean checkFontDictionary(PdfDictionary fontDic, PdfName fontType, boolean isException) {
        if (fontDic == null || fontDic.get(PdfName.Subtype) == null || !fontDic.get(PdfName.Subtype).equals(fontType)) {
            if (isException) {
                throw new PdfException("dict.not.contain.font.data").setMessageParams(fontType.getValue());
            }
            return false;
        }
        return true;
    }
}

