/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.ContextualPositionRule;
import com.itextpdf.io.font.otf.GposLookupType7;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OtfClass;
import com.itextpdf.io.font.otf.PosLookupRecord;
import com.itextpdf.io.font.otf.lookuptype8.PosTableLookup8Format1;
import com.itextpdf.io.font.otf.lookuptype8.PosTableLookup8Format2;
import com.itextpdf.io.font.otf.lookuptype8.PosTableLookup8Format3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GposLookupType8
extends GposLookupType7 {
    protected GposLookupType8(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws com.itextpdf.io.exceptions.IOException, IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.subTables = new ArrayList();
        this.readSubTables();
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        short substFormat = this.openReader.rf.readShort();
        switch (substFormat) {
            case 1: {
                this.readSubTableFormat1(subTableLocation);
                break;
            }
            case 2: {
                this.readSubTableFormat2(subTableLocation);
                break;
            }
            case 3: {
                this.readSubTableFormat3(subTableLocation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad subtable format identifier: " + substFormat);
            }
        }
    }

    @Override
    protected void readSubTableFormat2(int subTableLocation) throws IOException {
        int coverageOffset = this.openReader.rf.readUnsignedShort();
        int backtrackClassDefOffset = this.openReader.rf.readUnsignedShort();
        int inputClassDefOffset = this.openReader.rf.readUnsignedShort();
        int lookaheadClassDefOffset = this.openReader.rf.readUnsignedShort();
        int chainPosClassSetCount = this.openReader.rf.readUnsignedShort();
        int[] chainPosClassSetOffsets = this.openReader.readUShortArray(chainPosClassSetCount, subTableLocation);
        HashSet<Integer> coverageGlyphIds = new HashSet<Integer>(this.openReader.readCoverageFormat(subTableLocation + coverageOffset));
        OtfClass backtrackClassDefinition = this.openReader.readClassDefinition(subTableLocation + backtrackClassDefOffset);
        OtfClass inputClassDefinition = this.openReader.readClassDefinition(subTableLocation + inputClassDefOffset);
        OtfClass lookaheadClassDefinition = this.openReader.readClassDefinition(subTableLocation + lookaheadClassDefOffset);
        PosTableLookup8Format2 t = new PosTableLookup8Format2(this.openReader, this.lookupFlag, coverageGlyphIds, backtrackClassDefinition, inputClassDefinition, lookaheadClassDefinition);
        for (int i = 0; i < chainPosClassSetCount; ++i) {
            List<ContextualPositionRule> posClassSet = Collections.emptyList();
            if (chainPosClassSetOffsets[i] != 0) {
                this.openReader.rf.seek(chainPosClassSetOffsets[i]);
                int chainPosClassRuleCount = this.openReader.rf.readUnsignedShort();
                int[] chainPosClassRuleOffsets = this.openReader.readUShortArray(chainPosClassRuleCount, chainPosClassSetOffsets[i]);
                posClassSet = new ArrayList<ContextualPositionRule>(chainPosClassRuleCount);
                for (int j = 0; j < chainPosClassRuleCount; ++j) {
                    this.openReader.rf.seek(chainPosClassRuleOffsets[j]);
                    int backtrackClassCount = this.openReader.rf.readUnsignedShort();
                    int[] backtrackClassIds = this.openReader.readUShortArray(backtrackClassCount);
                    int inputClassCount = this.openReader.rf.readUnsignedShort();
                    int[] inputClassIds = this.openReader.readUShortArray(inputClassCount - 1);
                    int lookAheadClassCount = this.openReader.rf.readUnsignedShort();
                    int[] lookAheadClassIds = this.openReader.readUShortArray(lookAheadClassCount);
                    int substCount = this.openReader.rf.readUnsignedShort();
                    PosLookupRecord[] posLookupRecords = this.openReader.readPosLookupRecords(substCount);
                    PosTableLookup8Format2.PosRuleFormat2 rule = new PosTableLookup8Format2.PosRuleFormat2(t, backtrackClassIds, inputClassIds, lookAheadClassIds, posLookupRecords);
                    posClassSet.add(rule);
                }
            }
            t.addPosClassSet(posClassSet);
        }
        this.subTables.add(t);
    }

    private void readSubTableFormat1(int subTableLocation) throws IOException {
        HashMap<Integer, List<ContextualPositionRule>> posMap = new HashMap<Integer, List<ContextualPositionRule>>();
        int coverageOffset = this.openReader.rf.readUnsignedShort();
        int chainPosRuleSetCount = this.openReader.rf.readUnsignedShort();
        int[] chainPosRuleSetOffsets = this.openReader.readUShortArray(chainPosRuleSetCount, subTableLocation);
        List<Integer> coverageGlyphIds = this.openReader.readCoverageFormat(subTableLocation + coverageOffset);
        for (int i = 0; i < chainPosRuleSetCount; ++i) {
            this.openReader.rf.seek(chainPosRuleSetOffsets[i]);
            int chainPosRuleCount = this.openReader.rf.readUnsignedShort();
            int[] chainPosRuleOffsets = this.openReader.readUShortArray(chainPosRuleCount, chainPosRuleSetOffsets[i]);
            ArrayList<PosTableLookup8Format1.PosRuleFormat1> chainPosRuleSet = new ArrayList<PosTableLookup8Format1.PosRuleFormat1>(chainPosRuleCount);
            for (int j = 0; j < chainPosRuleCount; ++j) {
                this.openReader.rf.seek(chainPosRuleOffsets[j]);
                int backtrackGlyphCount = this.openReader.rf.readUnsignedShort();
                int[] backtrackGlyphIds = this.openReader.readUShortArray(backtrackGlyphCount);
                int inputGlyphCount = this.openReader.rf.readUnsignedShort();
                int[] inputGlyphIds = this.openReader.readUShortArray(inputGlyphCount - 1);
                int lookAheadGlyphCount = this.openReader.rf.readUnsignedShort();
                int[] lookAheadGlyphIds = this.openReader.readUShortArray(lookAheadGlyphCount);
                int posCount = this.openReader.rf.readUnsignedShort();
                PosLookupRecord[] posLookupRecords = this.openReader.readPosLookupRecords(posCount);
                chainPosRuleSet.add(new PosTableLookup8Format1.PosRuleFormat1(backtrackGlyphIds, inputGlyphIds, lookAheadGlyphIds, posLookupRecords));
            }
            posMap.put(coverageGlyphIds.get(i), chainPosRuleSet);
        }
        this.subTables.add(new PosTableLookup8Format1(this.openReader, this.lookupFlag, posMap));
    }

    private void readSubTableFormat3(int subTableLocation) throws IOException {
        int backtrackGlyphCount = this.openReader.rf.readUnsignedShort();
        int[] backtrackCoverageOffsets = this.openReader.readUShortArray(backtrackGlyphCount, subTableLocation);
        int inputGlyphCount = this.openReader.rf.readUnsignedShort();
        int[] inputCoverageOffsets = this.openReader.readUShortArray(inputGlyphCount, subTableLocation);
        int lookaheadGlyphCount = this.openReader.rf.readUnsignedShort();
        int[] lookaheadCoverageOffsets = this.openReader.readUShortArray(lookaheadGlyphCount, subTableLocation);
        int posCount = this.openReader.rf.readUnsignedShort();
        PosLookupRecord[] posLookupRecords = this.openReader.readPosLookupRecords(posCount);
        ArrayList<Set<Integer>> backtrackCoverages = new ArrayList<Set<Integer>>(backtrackGlyphCount);
        this.openReader.readCoverages(backtrackCoverageOffsets, backtrackCoverages);
        ArrayList<Set<Integer>> inputCoverages = new ArrayList<Set<Integer>>(inputGlyphCount);
        this.openReader.readCoverages(inputCoverageOffsets, inputCoverages);
        ArrayList<Set<Integer>> lookaheadCoverages = new ArrayList<Set<Integer>>(lookaheadGlyphCount);
        this.openReader.readCoverages(lookaheadCoverageOffsets, lookaheadCoverages);
        PosTableLookup8Format3.PosRuleFormat3 rule = new PosTableLookup8Format3.PosRuleFormat3(backtrackCoverages, inputCoverages, lookaheadCoverages, posLookupRecords);
        this.subTables.add(new PosTableLookup8Format3(this.openReader, this.lookupFlag, rule));
    }
}

