/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.element.SvgImage;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.xobject.SvgImageXObject;

public class SvgProcessingUtil {
    private final ResourceResolver resourceResolver;

    public SvgProcessingUtil(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Deprecated
    public Image createImageFromProcessingResult(ISvgProcessorResult result, PdfDocument pdfDocument) {
        SvgImageXObject xObject = (SvgImageXObject)this.createXObjectFromProcessingResult(result, pdfDocument);
        return new SvgImage(xObject);
    }

    @Deprecated
    public Image createSvgImageFromProcessingResult(ISvgProcessorResult result) {
        return this.createImageFromProcessingResult(result, null);
    }

    @Deprecated
    public PdfFormXObject createXObjectFromProcessingResult(ISvgProcessorResult result, PdfDocument pdfDocument) {
        ISvgNodeRenderer topSvgRenderer = result.getRootRenderer();
        float[] wh = SvgConverter.extractWidthAndHeight((ISvgNodeRenderer)topSvgRenderer);
        float width = wh[0];
        float height = wh[1];
        SvgImageXObject svgImageXObject = new SvgImageXObject(new Rectangle(0.0f, 0.0f, width, height), result, this.resourceResolver);
        if (pdfDocument != null) {
            svgImageXObject.generate(pdfDocument);
        }
        return svgImageXObject;
    }

    public SvgImageXObject createXObjectFromProcessingResult(ISvgProcessorResult result, ProcessorContext context, boolean generateAbsolutelySizedSvg) {
        float em = context.getCssContext().getCurrentFontSize();
        SvgDrawContext svgContext = new SvgDrawContext(this.resourceResolver, result.getFontProvider());
        svgContext.getCssContext().setRootFontSize(context.getCssContext().getRootFontSize());
        if (SvgProcessingUtil.isSvgRelativeSized(result.getRootRenderer(), context)) {
            return new SvgImageXObject(result, svgContext, em, context.getPdfDocument());
        }
        Rectangle bbox = SvgCssUtils.extractWidthAndHeight((ISvgNodeRenderer)result.getRootRenderer(), (float)em, (SvgDrawContext)svgContext);
        SvgImageXObject svgImageXObject = new SvgImageXObject(bbox, result, this.resourceResolver);
        if (context.getPdfDocument() != null && generateAbsolutelySizedSvg) {
            svgImageXObject.generate(context.getPdfDocument());
        }
        return svgImageXObject;
    }

    private static boolean isSvgRelativeSized(ISvgNodeRenderer rootRenderer, ProcessorContext context) {
        float em = context.getCssContext().getCurrentFontSize();
        float rem = context.getCssContext().getRootFontSize();
        String widthStr = rootRenderer.getAttribute("width");
        UnitValue width = CssDimensionParsingUtils.parseLengthValueToPt((String)widthStr, (float)em, (float)rem);
        String heightStr = rootRenderer.getAttribute("height");
        UnitValue height = CssDimensionParsingUtils.parseLengthValueToPt((String)heightStr, (float)em, (float)rem);
        return width == null || width.isPercentValue() || height == null || height.isPercentValue();
    }
}

