/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.properties.InlineVerticalAlignment;
import com.itextpdf.layout.properties.InlineVerticalAlignmentType;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import java.util.List;
import java.util.Map;

public class VerticalAlignmentApplierUtil {
    private static final double ASCENDER_COEFFICIENT = 0.8;
    private static final double DESCENDER_COEFFICIENT = 0.2;

    private VerticalAlignmentApplierUtil() {
    }

    public static void applyVerticalAlignmentForCells(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String vAlignVal = cssProps.get("vertical-align");
        if (vAlignVal != null) {
            if ("middle".equals(vAlignVal)) {
                element.setProperty(75, (Object)VerticalAlignment.MIDDLE);
            } else if ("bottom".equals(vAlignVal)) {
                element.setProperty(75, (Object)VerticalAlignment.BOTTOM);
            }
        }
    }

    public static void applyVerticalAlignmentForBlocks(Map<String, String> cssProps, IPropertyContainer element, boolean isInlineTag) {
        String display = cssProps.get("display");
        if (isInlineTag || "inline-block".equals(display)) {
            String vAlignVal = cssProps.get("vertical-align");
            if ("middle".equals(vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.MIDDLE));
            } else if ("bottom".equals(vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.BOTTOM));
            } else if ("top".equals(vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.TOP));
            } else if ("text-bottom".equals(vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.TEXT_BOTTOM));
            } else if ("text-top".equals(vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.TEXT_TOP));
            } else if ("super".equals(vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.SUPER));
            } else if ("sub".equals(vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.SUB));
            } else if (CssTypesValidationUtils.isPercentageValue((String)vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.FRACTION, CssDimensionParsingUtils.parseRelativeValue((String)vAlignVal, (float)1.0f)));
            } else if (CssTypesValidationUtils.isValidNumericValue((String)vAlignVal)) {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.FIXED, CssDimensionParsingUtils.parseAbsoluteLength((String)vAlignVal)));
            } else {
                element.setProperty(136, (Object)new InlineVerticalAlignment(InlineVerticalAlignmentType.BASELINE));
            }
        }
    }

    public static void applyVerticalAlignmentForInlines(Map<String, String> cssProps, ProcessorContext context, IStylesContainer stylesContainer, List<IPropertyContainer> childElements) {
        String vAlignVal = cssProps.get("vertical-align");
        if (vAlignVal != null) {
            float textRise = 0.0f;
            if ("sub".equals(vAlignVal) || "super".equals(vAlignVal)) {
                textRise = VerticalAlignmentApplierUtil.calcTextRiseForSupSub(stylesContainer, vAlignVal);
            } else if ("middle".equals(vAlignVal)) {
                textRise = VerticalAlignmentApplierUtil.calcTextRiseForMiddle(stylesContainer);
            } else if ("text-top".equals(vAlignVal)) {
                textRise = VerticalAlignmentApplierUtil.calcTextRiseForTextTop(stylesContainer, context.getCssContext().getRootFontSize());
            } else if ("text-bottom".equals(vAlignVal)) {
                textRise = VerticalAlignmentApplierUtil.calcTextRiseForTextBottom(stylesContainer, context.getCssContext().getRootFontSize());
            } else if (CssTypesValidationUtils.isMetricValue((String)vAlignVal)) {
                textRise = CssDimensionParsingUtils.parseAbsoluteLength((String)vAlignVal);
            } else if (vAlignVal.endsWith("%")) {
                textRise = VerticalAlignmentApplierUtil.calcTextRiseForPercentageValue(stylesContainer, context.getCssContext().getRootFontSize(), vAlignVal);
            }
            if (textRise != 0.0f) {
                for (IPropertyContainer element : childElements) {
                    if (element instanceof Text) {
                        Float effectiveTr = (Float)element.getProperty(72);
                        effectiveTr = effectiveTr != null ? Float.valueOf(effectiveTr.floatValue() + textRise) : Float.valueOf(textRise);
                        element.setProperty(72, (Object)effectiveTr);
                        continue;
                    }
                    if (!(element instanceof IBlockElement)) continue;
                    break;
                }
            }
        }
    }

    private static float calcTextRiseForSupSub(IStylesContainer stylesContainer, String vAlignVal) {
        float parentFontSize = VerticalAlignmentApplierUtil.getParentFontSize(stylesContainer);
        String superscriptPosition = "33%";
        String subscriptPosition = "-20%";
        String relativeValue = "super".equals(vAlignVal) ? superscriptPosition : subscriptPosition;
        return CssDimensionParsingUtils.parseRelativeValue((String)relativeValue, (float)parentFontSize);
    }

    private static float calcTextRiseForMiddle(IStylesContainer stylesContainer) {
        String ownFontSizeStr = (String)stylesContainer.getStyles().get("font-size");
        float fontSize = CssDimensionParsingUtils.parseAbsoluteLength((String)ownFontSizeStr);
        float parentFontSize = VerticalAlignmentApplierUtil.getParentFontSize(stylesContainer);
        double fontMiddleCoefficient = 0.3;
        float elementMidPoint = (float)((double)fontSize * fontMiddleCoefficient);
        float xHeight = parentFontSize / 4.0f;
        return xHeight - elementMidPoint;
    }

    private static float calcTextRiseForTextTop(IStylesContainer stylesContainer, float rootFontSize) {
        String ownFontSizeStr = (String)stylesContainer.getStyles().get("font-size");
        float fontSize = CssDimensionParsingUtils.parseAbsoluteLength((String)ownFontSizeStr);
        String lineHeightStr = (String)stylesContainer.getStyles().get("line-height");
        float lineHeightActualValue = VerticalAlignmentApplierUtil.getLineHeightActualValue(fontSize, rootFontSize, lineHeightStr);
        float parentFontSize = VerticalAlignmentApplierUtil.getParentFontSize(stylesContainer);
        float elementTopEdge = (float)((double)fontSize * 0.8 + (double)((lineHeightActualValue - fontSize) / 2.0f));
        float parentTextTop = (float)((double)parentFontSize * 0.8);
        return parentTextTop - elementTopEdge;
    }

    private static float calcTextRiseForTextBottom(IStylesContainer stylesContainer, float rootFontSize) {
        String ownFontSizeStr = (String)stylesContainer.getStyles().get("font-size");
        float fontSize = CssDimensionParsingUtils.parseAbsoluteLength((String)ownFontSizeStr);
        String lineHeightStr = (String)stylesContainer.getStyles().get("line-height");
        float lineHeightActualValue = VerticalAlignmentApplierUtil.getLineHeightActualValue(fontSize, rootFontSize, lineHeightStr);
        float parentFontSize = VerticalAlignmentApplierUtil.getParentFontSize(stylesContainer);
        float elementBottomEdge = (float)((double)fontSize * 0.2 + (double)((lineHeightActualValue - fontSize) / 2.0f));
        float parentTextBottom = (float)((double)parentFontSize * 0.2);
        return elementBottomEdge - parentTextBottom;
    }

    private static float calcTextRiseForPercentageValue(IStylesContainer stylesContainer, float rootFontSize, String vAlignVal) {
        String ownFontSizeStr = (String)stylesContainer.getStyles().get("font-size");
        float fontSize = CssDimensionParsingUtils.parseAbsoluteLength((String)ownFontSizeStr);
        String lineHeightStr = (String)stylesContainer.getStyles().get("line-height");
        float lineHeightActualValue = VerticalAlignmentApplierUtil.getLineHeightActualValue(fontSize, rootFontSize, lineHeightStr);
        return CssDimensionParsingUtils.parseRelativeValue((String)vAlignVal, (float)lineHeightActualValue);
    }

    private static float getLineHeightActualValue(float fontSize, float rootFontSize, String lineHeightStr) {
        float lineHeightActualValue;
        if (lineHeightStr != null) {
            if ("normal".equals(lineHeightStr) || "auto".equals(lineHeightStr)) {
                lineHeightActualValue = (float)((double)fontSize * 1.2);
            } else {
                UnitValue lineHeightValue = CssDimensionParsingUtils.parseLengthValueToPt((String)lineHeightStr, (float)fontSize, (float)rootFontSize);
                lineHeightActualValue = CssTypesValidationUtils.isNumber((String)lineHeightStr) ? fontSize * lineHeightValue.getValue() : (lineHeightValue.isPointValue() ? lineHeightValue.getValue() : fontSize * lineHeightValue.getValue() / 100.0f);
            }
        } else {
            lineHeightActualValue = (float)((double)fontSize * 1.2);
        }
        return lineHeightActualValue;
    }

    private static float getParentFontSize(IStylesContainer stylesContainer) {
        float parentFontSize;
        if (stylesContainer instanceof INode && ((IElementNode)stylesContainer).parentNode() instanceof IStylesContainer) {
            INode parent = ((IElementNode)stylesContainer).parentNode();
            String parentFontSizeStr = (String)((IStylesContainer)parent).getStyles().get("font-size");
            parentFontSize = CssDimensionParsingUtils.parseAbsoluteLength((String)parentFontSizeStr);
        } else {
            String ownFontSizeStr = (String)stylesContainer.getStyles().get("font-size");
            parentFontSize = CssDimensionParsingUtils.parseAbsoluteLength((String)ownFontSizeStr);
        }
        return parentFontSize;
    }
}

