/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.wrapelement;

import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.RowColHelper;
import com.itextpdf.html2pdf.attach.util.WaitingColgroupsHelper;
import com.itextpdf.html2pdf.attach.wrapelement.ColWrapper;
import com.itextpdf.html2pdf.attach.wrapelement.IWrapElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.tagging.IAccessibleElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableWrapper
implements IWrapElement {
    private List<List<CellWrapper>> rows;
    private List<List<CellWrapper>> headerRows;
    private List<List<CellWrapper>> footerRows;
    private RowColHelper rowShift = new RowColHelper();
    private RowColHelper headerRowShift = new RowColHelper();
    private RowColHelper footerRowShift = new RowColHelper();
    private int numberOfColumns = 0;
    private boolean isRtl = false;
    private Div caption = null;
    private String lang;
    private String footerLang;
    private String headerLang;

    public TableWrapper() {
    }

    public TableWrapper(boolean isRtl) {
        this.isRtl = isRtl;
    }

    public int getRowsSize() {
        return this.rows.size();
    }

    public void newRow() {
        if (this.rows == null) {
            this.rows = new ArrayList<List<CellWrapper>>();
        }
        this.rowShift.newRow();
        this.rows.add(new ArrayList());
    }

    public void newHeaderRow() {
        if (this.headerRows == null) {
            this.headerRows = new ArrayList<List<CellWrapper>>();
        }
        this.headerRowShift.newRow();
        this.headerRows.add(new ArrayList());
    }

    public void newFooterRow() {
        if (this.footerRows == null) {
            this.footerRows = new ArrayList<List<CellWrapper>>();
        }
        this.footerRowShift.newRow();
        this.footerRows.add(new ArrayList());
    }

    public void addHeaderCell(Cell cell) {
        if (this.headerRows == null) {
            this.headerRows = new ArrayList<List<CellWrapper>>();
        }
        if (this.headerRows.size() == 0) {
            this.newHeaderRow();
        }
        this.addCellToTable(cell, this.headerRows, this.headerRowShift);
    }

    public void addFooterCell(Cell cell) {
        if (this.footerRows == null) {
            this.footerRows = new ArrayList<List<CellWrapper>>();
        }
        if (this.footerRows.size() == 0) {
            this.newFooterRow();
        }
        this.addCellToTable(cell, this.footerRows, this.footerRowShift);
    }

    public void addCell(Cell cell) {
        if (this.rows == null) {
            this.rows = new ArrayList<List<CellWrapper>>();
        }
        if (this.rows.size() == 0) {
            this.newRow();
        }
        this.addCellToTable(cell, this.rows, this.rowShift);
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setFooterLang(String footerLang) {
        this.footerLang = footerLang;
    }

    public void setHeaderLang(String headerLang) {
        this.headerLang = headerLang;
    }

    private void addCellToTable(Cell cell, List<List<CellWrapper>> table, RowColHelper tableRowShift) {
        int col = tableRowShift.moveToNextEmptyCol();
        tableRowShift.updateCurrentPosition(cell.getColspan(), cell.getRowspan());
        List<CellWrapper> currentRow = table.get(table.size() - 1);
        currentRow.add(new CellWrapper(col, cell));
        this.numberOfColumns = Math.max(this.numberOfColumns, col + cell.getColspan());
    }

    public void setCaption(Div caption) {
        this.caption = caption;
    }

    public Table toTable(WaitingColgroupsHelper colgroupsHelper) {
        ColWrapper colWrapper;
        Cell cell;
        int j;
        int i;
        Table table = this.numberOfColumns > 0 ? new Table(this.getColWidths(colgroupsHelper)) : new Table(1);
        AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)table, this.lang);
        if (this.headerRows != null) {
            for (i = 0; i < this.headerRows.size(); ++i) {
                if (this.isRtl) {
                    Collections.reverse(this.headerRows.get(i));
                }
                for (j = 0; j < this.headerRows.get(i).size(); ++j) {
                    cell = this.headerRows.get((int)i).get((int)j).cell;
                    colWrapper = colgroupsHelper.getColWrapper(j);
                    if (colWrapper != null && this.headerLang == null && cell.getAccessibilityProperties().getLanguage() == null && colWrapper.getLang() != null) {
                        cell.getAccessibilityProperties().setLanguage(colWrapper.getLang());
                    }
                    table.addHeaderCell(cell);
                }
                if (i == this.headerRows.size() - 1) continue;
                table.getHeader().startNewRow();
            }
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)table.getHeader(), this.headerLang);
        }
        if (this.footerRows != null) {
            for (i = 0; i < this.footerRows.size(); ++i) {
                if (this.isRtl) {
                    Collections.reverse(this.footerRows.get(i));
                }
                for (j = 0; j < this.footerRows.get(i).size(); ++j) {
                    cell = this.footerRows.get((int)i).get((int)j).cell;
                    colWrapper = colgroupsHelper.getColWrapper(j);
                    if (colWrapper != null && this.footerLang == null && cell.getAccessibilityProperties().getLanguage() == null && colWrapper.getLang() != null) {
                        cell.getAccessibilityProperties().setLanguage(colWrapper.getLang());
                    }
                    table.addFooterCell(cell);
                }
                if (i == this.footerRows.size() - 1) continue;
                table.getFooter().startNewRow();
            }
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)table.getFooter(), this.footerLang);
        }
        if (this.rows != null) {
            for (i = 0; i < this.rows.size(); ++i) {
                table.startNewRow();
                if (this.isRtl) {
                    Collections.reverse(this.rows.get(i));
                }
                for (j = 0; j < this.rows.get(i).size(); ++j) {
                    table.addCell(this.rows.get((int)i).get((int)j).cell);
                }
            }
        }
        if (this.caption != null) {
            table.setCaption(this.caption);
        }
        return table;
    }

    private UnitValue[] getColWidths(WaitingColgroupsHelper colgroups) {
        UnitValue[] colWidths = new UnitValue[this.numberOfColumns];
        if (colgroups == null) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                colWidths[i] = null;
            }
        } else {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                colWidths[i] = colgroups.getColWrapper(i) != null ? colgroups.getColWrapper(i).getWidth() : null;
            }
        }
        return colWidths;
    }

    private static class CellWrapper {
        int col;
        Cell cell;

        CellWrapper(int col, Cell cell) {
            this.col = col;
            this.cell = cell;
        }
    }
}

