/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.attach.Attacher;
import com.itextpdf.html2pdf.exceptions.Html2PdfException;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.JsoupHtmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class HtmlConverter {
    private HtmlConverter() {
    }

    public static void convertToPdf(String html, OutputStream pdfStream) {
        HtmlConverter.convertToPdf(html, pdfStream, null);
    }

    public static void convertToPdf(String html, OutputStream pdfStream, ConverterProperties converterProperties) {
        HtmlConverter.convertToPdf(html, new PdfWriter(pdfStream), converterProperties);
    }

    public static void convertToPdf(String html, PdfWriter pdfWriter) {
        HtmlConverter.convertToPdf(html, pdfWriter, null);
    }

    public static void convertToPdf(String html, PdfWriter pdfWriter, ConverterProperties converterProperties) {
        HtmlConverter.convertToPdf(html, new PdfDocument(pdfWriter, new DocumentProperties().setEventCountingMetaInfo(HtmlConverter.resolveMetaInfo(converterProperties))), converterProperties);
    }

    public static void convertToPdf(String html, PdfDocument pdfDocument, ConverterProperties converterProperties) {
        Document document = HtmlConverter.convertToDocument(html, pdfDocument, converterProperties);
        document.setProperty(135, (Object)new MetaInfoContainer(HtmlConverter.resolveMetaInfo(converterProperties)));
        document.close();
    }

    public static void convertToPdf(File htmlFile, File pdfFile) throws IOException {
        HtmlConverter.convertToPdf(htmlFile, pdfFile, null);
    }

    public static void convertToPdf(File htmlFile, File pdfFile, ConverterProperties converterProperties) throws IOException {
        String baseUri;
        if (converterProperties == null) {
            baseUri = FileUtil.getParentDirectoryUri((File)htmlFile);
            converterProperties = new ConverterProperties().setBaseUri(baseUri);
        } else if (converterProperties.getBaseUri() == null) {
            baseUri = FileUtil.getParentDirectoryUri((File)htmlFile);
            converterProperties = new ConverterProperties(converterProperties).setBaseUri(baseUri);
        }
        try (FileInputStream fileInputStream = new FileInputStream(htmlFile.getAbsolutePath());
             FileOutputStream fileOutputStream = new FileOutputStream(pdfFile.getAbsolutePath());){
            HtmlConverter.convertToPdf((InputStream)fileInputStream, (OutputStream)fileOutputStream, converterProperties);
        }
    }

    public static void convertToPdf(InputStream htmlStream, OutputStream pdfStream) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, pdfStream, null);
    }

    public static void convertToPdf(InputStream htmlStream, OutputStream pdfStream, ConverterProperties converterProperties) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfWriter(pdfStream), converterProperties);
    }

    public static void convertToPdf(InputStream htmlStream, PdfDocument pdfDocument) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, pdfDocument, null);
    }

    public static void convertToPdf(InputStream htmlStream, PdfWriter pdfWriter) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfDocument(pdfWriter, new DocumentProperties().setEventCountingMetaInfo(HtmlConverter.createPdf2HtmlMetaInfo())));
    }

    public static void convertToPdf(InputStream htmlStream, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfDocument(pdfWriter, new DocumentProperties().setEventCountingMetaInfo(HtmlConverter.resolveMetaInfo(converterProperties))), converterProperties);
    }

    public static void convertToPdf(InputStream htmlStream, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        Document document = HtmlConverter.convertToDocument(htmlStream, pdfDocument, converterProperties);
        IMetaInfo metaInfo = HtmlConverter.resolveMetaInfo(converterProperties);
        document.setProperty(135, (Object)new MetaInfoContainer(metaInfo));
        document.close();
    }

    public static Document convertToDocument(String html, PdfWriter pdfWriter) {
        return HtmlConverter.convertToDocument(html, pdfWriter, null);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfWriter pdfWriter) throws IOException {
        return HtmlConverter.convertToDocument(htmlStream, pdfWriter, null);
    }

    public static Document convertToDocument(String html, PdfWriter pdfWriter, ConverterProperties converterProperties) {
        return HtmlConverter.convertToDocument(html, new PdfDocument(pdfWriter), converterProperties);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        return HtmlConverter.convertToDocument(htmlStream, new PdfDocument(pdfWriter), converterProperties);
    }

    public static Document convertToDocument(String html, PdfDocument pdfDocument, ConverterProperties converterProperties) {
        if (pdfDocument.getReader() != null) {
            throw new Html2PdfException("PdfDocument should be created in writing mode. Reading and stamping is not allowed");
        }
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(html);
        return Attacher.attach(doc, pdfDocument, converterProperties);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        if (pdfDocument.getReader() != null) {
            throw new Html2PdfException("PdfDocument should be created in writing mode. Reading and stamping is not allowed");
        }
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(htmlStream, converterProperties != null ? converterProperties.getCharset() : null);
        return Attacher.attach(doc, pdfDocument, converterProperties);
    }

    public static List<IElement> convertToElements(String html) {
        return HtmlConverter.convertToElements(html, null);
    }

    public static List<IElement> convertToElements(InputStream htmlStream) throws IOException {
        return HtmlConverter.convertToElements(htmlStream, null);
    }

    public static List<IElement> convertToElements(String html, ConverterProperties converterProperties) {
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(html);
        return Attacher.attach(doc, converterProperties);
    }

    public static List<IElement> convertToElements(InputStream htmlStream, ConverterProperties converterProperties) throws IOException {
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(htmlStream, converterProperties != null ? converterProperties.getCharset() : null);
        return Attacher.attach(doc, converterProperties);
    }

    static IMetaInfo createPdf2HtmlMetaInfo() {
        return new HtmlMetaInfo();
    }

    private static IMetaInfo resolveMetaInfo(ConverterProperties converterProperties) {
        return converterProperties == null ? HtmlConverter.createPdf2HtmlMetaInfo() : converterProperties.getEventMetaInfo();
    }

    private static class HtmlMetaInfo
    implements IMetaInfo {
        private HtmlMetaInfo() {
        }
    }
}

