/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.html;

import com.itextpdf.html2pdf.css.resolve.func.counter.CounterDigitsGlyphStyle;
import com.itextpdf.kernel.numbering.ArmenianNumbering;
import com.itextpdf.kernel.numbering.EnglishAlphabetNumbering;
import com.itextpdf.kernel.numbering.GeorgianNumbering;
import com.itextpdf.kernel.numbering.GreekAlphabetNumbering;
import com.itextpdf.kernel.numbering.RomanNumbering;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;

public final class HtmlUtils {
    private static final String DISC_SYMBOL = "\u2022";
    private static final String CIRCLE_SYMBOL = "\u25e6";
    private static final String SQUARE_SYMBOL = "\u25a0";
    private static final String LATIN_NUMERALS = "abcdefghijklmnopqrstuvwxyz";
    private static final String GREEK_NUMERALS = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    private static final String ROMAN_NUMERALS = "ivxlcdm";
    private static final String GEORGIAN_NUMERALS = "\u10d0\u10d1\u10d2\u10d3\u10d4\u10d5\u10d6\u10f1\u10d7\u10d8\u10d9\u10da\u10db\u10dc\u10f2\u10dd\u10de\u10df\u10e0\u10e1\u10e2\u10f3\u10e4\u10e5\u10e6\u10e7\u10e8\u10e9\u10ea\u10eb\u10ec\u10ed\u10ee\u10f4\u10ef\u10f0\u10f5";
    private static final String ARMENIAN_NUMERALS = "\u0531\u0532\u0533\u0534\u0535\u0536\u0537\u0538\u0539\u053a\u053b\u053c\u053d\u053e\u053f\u0540\u0541\u0542\u0543\u0544\u0545\u0546\u0547\u0548\u0549\u054a\u054b\u054c\u054d\u054e\u054f\u0550\u0551\u0552\u0553\u0554";
    private static final String DEFAULT_NUMERALS = "1234567890";
    private static final int MAX_ROMAN_NUMBER = 3999;

    private HtmlUtils() {
    }

    @Deprecated
    public static boolean isStyleSheetLink(IElementNode headChildElement) {
        return CssUtils.isStyleSheetLink((IElementNode)headChildElement);
    }

    public static String convertNumberAccordingToGlyphStyle(CounterDigitsGlyphStyle glyphStyle, int number) {
        if (glyphStyle == null) {
            return String.valueOf(number);
        }
        switch (glyphStyle) {
            case NONE: {
                return "";
            }
            case DISC: {
                return DISC_SYMBOL;
            }
            case SQUARE: {
                return SQUARE_SYMBOL;
            }
            case CIRCLE: {
                return CIRCLE_SYMBOL;
            }
            case UPPER_ALPHA_AND_LATIN: {
                return number > 0 ? EnglishAlphabetNumbering.toLatinAlphabetNumberUpperCase((int)number) : String.valueOf(number);
            }
            case LOWER_ALPHA_AND_LATIN: {
                return number > 0 ? EnglishAlphabetNumbering.toLatinAlphabetNumberLowerCase((int)number) : String.valueOf(number);
            }
            case LOWER_GREEK: {
                return number > 0 ? GreekAlphabetNumbering.toGreekAlphabetNumberLowerCase((int)number) : String.valueOf(number);
            }
            case LOWER_ROMAN: {
                return number <= 3999 ? RomanNumbering.toRomanLowerCase((int)number) : String.valueOf(number);
            }
            case UPPER_ROMAN: {
                return number <= 3999 ? RomanNumbering.toRomanUpperCase((int)number) : String.valueOf(number);
            }
            case DECIMAL_LEADING_ZERO: {
                return (number < 10 ? "0" : "") + String.valueOf(number);
            }
            case GEORGIAN: {
                return GeorgianNumbering.toGeorgian((int)number);
            }
            case ARMENIAN: {
                return ArmenianNumbering.toArmenian((int)number);
            }
        }
        return String.valueOf(number);
    }

    public static String getAllNumberGlyphsForStyle(CounterDigitsGlyphStyle glyphStyle) {
        if (glyphStyle == null) {
            return DEFAULT_NUMERALS;
        }
        switch (glyphStyle) {
            case NONE: {
                return "";
            }
            case DISC: {
                return DISC_SYMBOL;
            }
            case SQUARE: {
                return SQUARE_SYMBOL;
            }
            case CIRCLE: {
                return CIRCLE_SYMBOL;
            }
            case UPPER_ALPHA_AND_LATIN: {
                return LATIN_NUMERALS.toUpperCase();
            }
            case LOWER_ALPHA_AND_LATIN: {
                return LATIN_NUMERALS;
            }
            case LOWER_GREEK: {
                return GREEK_NUMERALS;
            }
            case LOWER_ROMAN: {
                return ROMAN_NUMERALS;
            }
            case UPPER_ROMAN: {
                return ROMAN_NUMERALS.toUpperCase();
            }
            case GEORGIAN: {
                return GEORGIAN_NUMERALS;
            }
            case ARMENIAN: {
                return ARMENIAN_NUMERALS;
            }
        }
        return DEFAULT_NUMERALS;
    }

    public static CounterDigitsGlyphStyle convertStringCounterGlyphStyleToEnum(String glyphStyle) {
        if (glyphStyle == null) {
            return CounterDigitsGlyphStyle.DEFAULT;
        }
        switch (glyphStyle) {
            case "none": {
                return CounterDigitsGlyphStyle.NONE;
            }
            case "disc": {
                return CounterDigitsGlyphStyle.DISC;
            }
            case "square": {
                return CounterDigitsGlyphStyle.SQUARE;
            }
            case "circle": {
                return CounterDigitsGlyphStyle.CIRCLE;
            }
            case "upper-alpha": 
            case "upper-latin": {
                return CounterDigitsGlyphStyle.UPPER_ALPHA_AND_LATIN;
            }
            case "lower-alpha": 
            case "lower-latin": {
                return CounterDigitsGlyphStyle.LOWER_ALPHA_AND_LATIN;
            }
            case "lower-greek": {
                return CounterDigitsGlyphStyle.LOWER_GREEK;
            }
            case "lower-roman": {
                return CounterDigitsGlyphStyle.LOWER_ROMAN;
            }
            case "upper-roman": {
                return CounterDigitsGlyphStyle.UPPER_ROMAN;
            }
            case "georgian": {
                return CounterDigitsGlyphStyle.GEORGIAN;
            }
            case "armenian": {
                return CounterDigitsGlyphStyle.ARMENIAN;
            }
            case "decimal-leading-zero": {
                return CounterDigitsGlyphStyle.DECIMAL_LEADING_ZERO;
            }
        }
        return CounterDigitsGlyphStyle.DEFAULT;
    }
}

