/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaddingApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(PaddingApplierUtil.class);

    private PaddingApplierUtil() {
    }

    public static void applyPaddings(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        PaddingApplierUtil.applyPaddings(cssProps, context, element, 0.0f, 0.0f);
    }

    public static void applyPaddings(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element, float baseValueVertical, float baseValueHorizontal) {
        String paddingTop = cssProps.get("padding-top");
        String paddingBottom = cssProps.get("padding-bottom");
        String paddingLeft = cssProps.get("padding-left");
        String paddingRight = cssProps.get("padding-right");
        float em = CssUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        UnitValue paddingTopVal = CssUtils.parseLengthValueToPt((String)paddingTop, (float)em, (float)rem);
        UnitValue paddingBottomVal = CssUtils.parseLengthValueToPt((String)paddingBottom, (float)em, (float)rem);
        UnitValue paddingLeftVal = CssUtils.parseLengthValueToPt((String)paddingLeft, (float)em, (float)rem);
        UnitValue paddingRightVal = CssUtils.parseLengthValueToPt((String)paddingRight, (float)em, (float)rem);
        if (paddingTopVal != null) {
            if (paddingTopVal.isPointValue()) {
                element.setProperty(50, (Object)paddingTopVal);
            } else if (baseValueVertical != 0.0f) {
                element.setProperty(50, (Object)new UnitValue(1, baseValueVertical * paddingTopVal.getValue() * 0.01f));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
        if (paddingBottomVal != null) {
            if (paddingBottomVal.isPointValue()) {
                element.setProperty(47, (Object)paddingBottomVal);
            } else if (baseValueVertical != 0.0f) {
                element.setProperty(47, (Object)new UnitValue(1, baseValueVertical * paddingBottomVal.getValue() * 0.01f));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
        if (paddingLeftVal != null) {
            if (paddingLeftVal.isPointValue()) {
                element.setProperty(48, (Object)paddingLeftVal);
            } else if (baseValueHorizontal != 0.0f) {
                element.setProperty(48, (Object)new UnitValue(1, baseValueHorizontal * paddingLeftVal.getValue() * 0.01f));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
        if (paddingRightVal != null) {
            if (paddingRightVal.isPointValue()) {
                element.setProperty(49, (Object)paddingRightVal);
            } else if (baseValueHorizontal != 0.0f) {
                element.setProperty(49, (Object)new UnitValue(1, baseValueHorizontal * paddingRightVal.getValue() * 0.01f));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
    }
}

