/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.resolver.font;

import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.layout.font.Range;
import com.itextpdf.layout.font.RangeBuilder;
import com.itextpdf.styledxmlparser.resolver.font.BasicFontProvider;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFontProvider
extends BasicFontProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFontProvider.class);
    private static final String SHIPPED_FONT_RESOURCE_PATH = "com/itextpdf/html2pdf/font/";
    private static final String[] SHIPPED_FONT_NAMES = new String[]{"FreeMono.ttf", "FreeMonoBold.ttf", "FreeMonoBoldOblique.ttf", "FreeMonoOblique.ttf", "FreeSans.ttf", "FreeSansBold.ttf", "FreeSansBoldOblique.ttf", "FreeSansOblique.ttf", "FreeSerif.ttf", "FreeSerifBold.ttf", "FreeSerifBoldItalic.ttf", "FreeSerifItalic.ttf"};
    private static final Range FREE_FONT_RANGE = new RangeBuilder().addRange(0, 1423).addRange(3712, Integer.MAX_VALUE).create();

    public DefaultFontProvider() {
        this(true, true, false);
    }

    public DefaultFontProvider(boolean registerStandardPdfFonts, boolean registerShippedFreeFonts, boolean registerSystemFonts) {
        super(registerStandardPdfFonts, registerSystemFonts);
        if (registerShippedFreeFonts) {
            this.addShippedFreeFonts(this.addCalligraphFonts());
        }
    }

    private void addShippedFreeFonts(Range rangeToLoad) {
        for (String fontName : SHIPPED_FONT_NAMES) {
            try (InputStream stream = ResourceUtil.getResourceStream((String)(SHIPPED_FONT_RESOURCE_PATH + fontName));){
                byte[] fontProgramBytes = StreamUtil.inputStreamToArray((InputStream)stream);
                this.addFont(fontProgramBytes, null, rangeToLoad);
            }
            catch (Exception e) {
                LOGGER.error("Error while loading font");
            }
        }
    }

    protected Range addCalligraphFonts() {
        String methodName = "loadShippedFonts";
        Class<?> klass = null;
        try {
            klass = DefaultFontProvider.getTypographyUtilsClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (klass != null) {
            try {
                Method m = klass.getMethod(methodName, new Class[0]);
                ArrayList fontStreams = (ArrayList)m.invoke(null, null);
                for (byte[] font : fontStreams) {
                    this.addFont(font);
                }
                return FREE_FONT_RANGE;
            }
            catch (Exception e) {
                LOGGER.error("Error while loading font");
            }
        }
        return null;
    }

    private static Class<?> getTypographyUtilsClass() throws ClassNotFoundException {
        String typographyClassFullName = "com.itextpdf.typography.util.TypographyShippedFontsUtil";
        return Class.forName(typographyClassFullName);
    }
}

