/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.resolve.func.counter;

import com.itextpdf.kernel.numbering.ArmenianNumbering;
import com.itextpdf.kernel.numbering.EnglishAlphabetNumbering;
import com.itextpdf.kernel.numbering.GeorgianNumbering;
import com.itextpdf.kernel.numbering.GreekAlphabetNumbering;
import com.itextpdf.kernel.numbering.RomanNumbering;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CssCounterManager {
    private static final String DISC_SYMBOL = "\u2022";
    private static final String CIRCLE_SYMBOL = "\u25e6";
    private static final String SQUARE_SYMBOL = "\u25a0";
    private static final int DEFAULT_COUNTER_VALUE = 0;
    private static final int DEFAULT_INCREMENT_VALUE = 1;
    private static final int MAX_ROMAN_NUMBER = 3999;
    private Map<INode, Map<String, Integer>> counters = new HashMap<INode, Map<String, Integer>>();

    public String resolveCounter(String counterName, String listSymbolType, INode scope) {
        Integer counterValue;
        Map<String, Integer> scopeCounters = this.findSuitableScopeMap(scope, counterName);
        Integer n = counterValue = scopeCounters != null ? scopeCounters.get(counterName) : null;
        if (counterValue == null) {
            return null;
        }
        if (listSymbolType == null) {
            return String.valueOf(counterValue);
        }
        if ("none".equals(listSymbolType)) {
            return "";
        }
        if ("disc".equals(listSymbolType)) {
            return DISC_SYMBOL;
        }
        if ("square".equals(listSymbolType)) {
            return SQUARE_SYMBOL;
        }
        if ("circle".equals(listSymbolType)) {
            return CIRCLE_SYMBOL;
        }
        if ("upper-alpha".equals(listSymbolType) || "upper-latin".equals(listSymbolType)) {
            return EnglishAlphabetNumbering.toLatinAlphabetNumberUpperCase((int)counterValue);
        }
        if ("lower-alpha".equals(listSymbolType) || "lower-latin".equals(listSymbolType)) {
            return EnglishAlphabetNumbering.toLatinAlphabetNumberLowerCase((int)counterValue);
        }
        if ("lower-roman".equals(listSymbolType)) {
            return counterValue <= 3999 ? RomanNumbering.toRomanLowerCase((int)counterValue) : String.valueOf(counterValue);
        }
        if ("upper-roman".equals(listSymbolType)) {
            return counterValue <= 3999 ? RomanNumbering.toRomanUpperCase((int)counterValue) : String.valueOf(counterValue);
        }
        if ("decimal-leading-zero".equals(listSymbolType)) {
            return (counterValue < 10 ? "0" : "") + String.valueOf(counterValue);
        }
        if ("lower-greek".equals(listSymbolType)) {
            return GreekAlphabetNumbering.toGreekAlphabetNumberLowerCase((int)counterValue);
        }
        if ("georgian".equals(listSymbolType)) {
            return GeorgianNumbering.toGeorgian((int)counterValue);
        }
        if ("armenian".equals(listSymbolType)) {
            return ArmenianNumbering.toArmenian((int)counterValue);
        }
        return String.valueOf(counterValue);
    }

    public String resolveCounters(String counterName, String counterSeparatorStr, String listSymbolType, INode scope) {
        INode currentScope = scope;
        ArrayList<String> resolvedCounters = null;
        while (currentScope != null) {
            INode curCounterOwnerScope = this.findCounterOwner(currentScope, counterName);
            if (curCounterOwnerScope != null) {
                if (resolvedCounters == null) {
                    resolvedCounters = new ArrayList<String>();
                }
                resolvedCounters.add(this.resolveCounter(counterName, listSymbolType, curCounterOwnerScope));
            }
            currentScope = curCounterOwnerScope == null ? null : curCounterOwnerScope.parentNode();
        }
        if (resolvedCounters == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = resolvedCounters.size() - 1; i >= 0; --i) {
            sb.append((String)resolvedCounters.get(i));
            if (i == 0) continue;
            sb.append(counterSeparatorStr);
        }
        return sb.toString();
    }

    public void resetCounter(String counterName, INode scope) {
        this.resetCounter(counterName, 0, scope);
    }

    public void resetCounter(String counterName, int value, INode scope) {
        this.getOrCreateScopeCounterMap(scope).put(counterName, value);
    }

    public void incrementCounter(String counterName, int incrementValue, INode scope) {
        Integer curValue;
        Map<String, Integer> scopeCounters = this.findSuitableScopeMap(scope, counterName);
        Integer n = curValue = scopeCounters != null ? scopeCounters.get(counterName) : null;
        if (curValue == null) {
            curValue = 0;
            this.resetCounter(counterName, curValue, scope);
            scopeCounters = this.getOrCreateScopeCounterMap(scope);
        }
        scopeCounters.put(counterName, curValue + incrementValue);
    }

    public void incrementCounter(String counterName, INode scope) {
        this.incrementCounter(counterName, 1, scope);
    }

    private Map<String, Integer> getOrCreateScopeCounterMap(INode scope) {
        Map<String, Integer> scopeCounters = this.counters.get(scope);
        if (scopeCounters == null) {
            scopeCounters = new HashMap<String, Integer>();
            this.counters.put(scope, scopeCounters);
        }
        return scopeCounters;
    }

    private Map<String, Integer> findSuitableScopeMap(INode scope, String counterName) {
        INode ownerScope = this.findCounterOwner(scope, counterName);
        return ownerScope == null ? null : this.counters.get(ownerScope);
    }

    private INode findCounterOwner(INode scope, String counterName) {
        while (!(scope == null || this.counters.containsKey(scope) && this.counters.get(scope).containsKey(counterName))) {
            boolean foundSuitableSibling = false;
            if (scope.parentNode() != null) {
                List allSiblings = scope.parentNode().childNodes();
                int indexOfCurScope = allSiblings.indexOf(scope);
                for (int i = indexOfCurScope - 1; i >= 0; --i) {
                    INode siblingScope = (INode)allSiblings.get(i);
                    if (!this.counters.containsKey(siblingScope) || !this.counters.get(siblingScope).containsKey(counterName)) continue;
                    scope = siblingScope;
                    foundSuitableSibling = true;
                    break;
                }
            }
            if (foundSuitableSibling) continue;
            scope = scope.parentNode();
        }
        return scope;
    }
}

