/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.wrapelement;

import com.itextpdf.html2pdf.attach.wrapelement.ColWrapper;
import com.itextpdf.html2pdf.attach.wrapelement.IWrapElement;
import com.itextpdf.layout.property.UnitValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColgroupWrapper
implements IWrapElement {
    private int span;
    private UnitValue width;
    private int[] indexToColMapping;
    private Map<String, String> cellCssProps;
    private Map<String, String> ownCssProps;
    private List<ColWrapper> columns = new ArrayList<ColWrapper>();

    public ColgroupWrapper(int span) {
        this.span = span;
    }

    public int getSpan() {
        return this.span;
    }

    public UnitValue getWidth() {
        return this.width;
    }

    public ColgroupWrapper setWidth(UnitValue width) {
        this.width = width;
        return this;
    }

    public Map<String, String> getCellCssProps() {
        return this.cellCssProps;
    }

    public ColgroupWrapper setCellCssProps(Map<String, String> cellCssProps) {
        this.cellCssProps = cellCssProps;
        return this;
    }

    public Map<String, String> getOwnCssProps() {
        return this.ownCssProps;
    }

    public ColgroupWrapper setOwnCssProps(Map<String, String> ownCssProps) {
        this.ownCssProps = ownCssProps;
        return this;
    }

    public List<ColWrapper> getColumns() {
        return this.columns;
    }

    /*
     * WARNING - void declaration
     */
    public ColgroupWrapper finalizeCols() {
        void var2_6;
        if (this.indexToColMapping != null) {
            return this;
        }
        if (this.columns.isEmpty()) {
            this.columns.add(new ColWrapper(this.span).setCellCssProps(this.cellCssProps).setWidth(this.width));
        } else if (this.cellCssProps != null) {
            for (ColWrapper colWrapper : this.columns) {
                HashMap<String, String> colStyles = new HashMap<String, String>(this.cellCssProps);
                if (colWrapper.getCellCssProps() != null) {
                    colStyles.putAll(colWrapper.getCellCssProps());
                }
                if (colStyles.size() > 0) {
                    colWrapper.setCellCssProps(colStyles);
                }
                if (colWrapper.getWidth() != null) continue;
                colWrapper.setWidth(this.width);
            }
        }
        this.columns = Collections.unmodifiableList(this.columns);
        int ncol = 0;
        for (ColWrapper col : this.columns) {
            ncol += col.getSpan();
        }
        this.indexToColMapping = new int[ncol];
        this.span = 0;
        boolean bl = false;
        while (var2_6 < this.columns.size()) {
            int colSpan = this.columns.get((int)var2_6).getSpan();
            for (int j = 0; j < colSpan; ++j) {
                this.indexToColMapping[this.span + j] = var2_6;
            }
            this.span += colSpan;
            ++var2_6;
        }
        return this;
    }

    public ColWrapper getColumnByIndex(int index) {
        return this.columns.get(this.indexToColMapping[index]);
    }
}

