/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import com.itextpdf.html2pdf.attach.util.RowColHelper;
import com.itextpdf.html2pdf.attach.wrapelement.ColWrapper;
import com.itextpdf.html2pdf.attach.wrapelement.ColgroupWrapper;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.ArrayList;

public class WaitingColgroupsHelper {
    private IElementNode tableElement;
    private ArrayList<ColgroupWrapper> colgroups = new ArrayList();
    private int maxIndex = -1;
    private int[] indexToColgroupMapping;
    private int[] shiftCol;

    public WaitingColgroupsHelper(IElementNode tableElement) {
        this.tableElement = tableElement;
    }

    public void add(ColgroupWrapper colgroup) {
        this.colgroups.add(colgroup);
    }

    public void applyColStyles() {
        if (this.colgroups.isEmpty() || this.maxIndex != -1) {
            return;
        }
        this.finalizeColgroups();
        RowColHelper tableRowColHelper = new RowColHelper();
        RowColHelper headerRowColHelper = new RowColHelper();
        RowColHelper footerRowColHelper = new RowColHelper();
        for (INode child : this.tableElement.childNodes()) {
            if (!(child instanceof IElementNode)) continue;
            IElementNode element = (IElementNode)child;
            if (element.name().equals("thead")) {
                this.applyColStyles((INode)element, headerRowColHelper);
                continue;
            }
            if (element.name().equals("tfoot")) {
                this.applyColStyles((INode)element, footerRowColHelper);
                continue;
            }
            this.applyColStyles((INode)element, tableRowColHelper);
        }
    }

    public ColWrapper getColWrapper(int index) {
        if (index > this.maxIndex) {
            return null;
        }
        return this.colgroups.get(this.indexToColgroupMapping[index]).getColumnByIndex(index - this.shiftCol[this.indexToColgroupMapping[index]]);
    }

    private void applyColStyles(INode node, RowColHelper rowColHelper) {
        for (INode child : node.childNodes()) {
            if (!(child instanceof IElementNode)) continue;
            IElementNode element = (IElementNode)child;
            if (element.name().equals("tr")) {
                this.applyColStyles((INode)element, rowColHelper);
                rowColHelper.newRow();
                continue;
            }
            if (element.name().equals("th") || element.name().equals("td")) {
                Integer colspan = CssUtils.parseInteger((String)element.getAttribute("colspan"));
                Integer rowspan = CssUtils.parseInteger((String)element.getAttribute("rowspan"));
                colspan = colspan != null ? colspan : 1;
                rowspan = rowspan != null ? rowspan : 1;
                int col = rowColHelper.moveToNextEmptyCol();
                if (this.getColWrapper(col) != null && this.getColWrapper(col).getCellCssProps() != null) {
                    element.addAdditionalHtmlStyles(this.getColWrapper(col).getCellCssProps());
                }
                rowColHelper.updateCurrentPosition(colspan, rowspan);
                continue;
            }
            this.applyColStyles(child, rowColHelper);
        }
    }

    private void finalizeColgroups() {
        int i;
        int shift = 0;
        this.shiftCol = new int[this.colgroups.size()];
        for (i = 0; i < this.colgroups.size(); ++i) {
            this.shiftCol[i] = shift;
            shift += this.colgroups.get(i).getSpan();
        }
        this.maxIndex = shift - 1;
        this.indexToColgroupMapping = new int[shift];
        for (i = 0; i < this.colgroups.size(); ++i) {
            for (int j = 0; j < this.colgroups.get(i).getSpan(); ++j) {
                this.indexToColgroupMapping[j + this.shiftCol[i]] = i;
            }
        }
        this.colgroups.trimToSize();
    }
}

