/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.CaptionTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.ColgroupTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.TrTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingColgroupsHelper;
import com.itextpdf.html2pdf.attach.wrapelement.TableRowWrapper;
import com.itextpdf.html2pdf.attach.wrapelement.TableWrapper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.Table;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class TableTagWorker
implements ITagWorker,
IDisplayAware {
    private TableWrapper tableWrapper;
    private Table table;
    private boolean footer;
    private boolean header;
    private ITagWorker parentTagWorker;
    private WaitingColgroupsHelper colgroupsHelper;
    private String display;

    public TableTagWorker(IElementNode element, ProcessorContext context) {
        String str = (String)element.getStyles().get("direction");
        boolean isRtl = "rtl".equals(str);
        this.tableWrapper = new TableWrapper(isRtl);
        ITagWorker iTagWorker = this.parentTagWorker = context.getState().empty() ? null : context.getState().top();
        if (this.parentTagWorker instanceof TableTagWorker) {
            ((TableTagWorker)this.parentTagWorker).applyColStyles();
        } else {
            this.colgroupsHelper = new WaitingColgroupsHelper(element);
        }
        this.display = element.getStyles() != null ? (String)element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.table = this.tableWrapper.toTable(this.colgroupsHelper);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return this.parentTagWorker != null && this.parentTagWorker.processContent(content, context);
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        if (childTagWorker instanceof TrTagWorker) {
            TableRowWrapper wrapper = ((TrTagWorker)childTagWorker).getTableRowWrapper();
            this.tableWrapper.newRow();
            for (Cell cell : wrapper.getCells()) {
                this.tableWrapper.addCell(cell);
            }
            return true;
        }
        if (childTagWorker instanceof TableTagWorker) {
            if (((TableTagWorker)childTagWorker).header) {
                Table header = ((TableTagWorker)childTagWorker).tableWrapper.toTable(this.colgroupsHelper);
                for (int i = 0; i < header.getNumberOfRows(); ++i) {
                    this.tableWrapper.newHeaderRow();
                    for (int j = 0; j < header.getNumberOfColumns(); ++j) {
                        Cell headerCell = header.getCell(i, j);
                        if (headerCell == null) continue;
                        this.tableWrapper.addHeaderCell(headerCell);
                    }
                }
                return true;
            }
            if (((TableTagWorker)childTagWorker).footer) {
                Table footer = ((TableTagWorker)childTagWorker).tableWrapper.toTable(this.colgroupsHelper);
                for (int i = 0; i < footer.getNumberOfRows(); ++i) {
                    this.tableWrapper.newFooterRow();
                    for (int j = 0; j < footer.getNumberOfColumns(); ++j) {
                        Cell footerCell = footer.getCell(i, j);
                        if (footerCell == null) continue;
                        this.tableWrapper.addFooterCell(footerCell);
                    }
                }
                return true;
            }
        } else if (childTagWorker instanceof ColgroupTagWorker) {
            if (this.colgroupsHelper != null) {
                this.colgroupsHelper.add(((ColgroupTagWorker)childTagWorker).getColgroup().finalizeCols());
                return true;
            }
        } else if (childTagWorker instanceof CaptionTagWorker) {
            this.tableWrapper.setCaption((Div)childTagWorker.getElementResult());
            return true;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.table;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    public void setFooter() {
        this.footer = true;
    }

    public void setHeader() {
        this.header = true;
    }

    public void applyColStyles() {
        if (this.colgroupsHelper != null) {
            this.colgroupsHelper.applyColStyles();
        }
    }
}

