/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarginApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(MarginApplierUtil.class);

    private MarginApplierUtil() {
    }

    public static void applyMargins(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        boolean isRightAuto;
        String marginTop = cssProps.get("margin-top");
        String marginBottom = cssProps.get("margin-bottom");
        String marginLeft = cssProps.get("margin-left");
        String marginRight = cssProps.get("margin-right");
        boolean isBlock = element instanceof IBlockElement || "block".equals(cssProps.get("display"));
        boolean isImage = element instanceof Image;
        float em = CssUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        if (isBlock || isImage) {
            MarginApplierUtil.trySetMarginIfNotAuto(46, marginTop, element, em, rem);
            MarginApplierUtil.trySetMarginIfNotAuto(43, marginBottom, element, em, rem);
        }
        boolean isLeftAuto = !MarginApplierUtil.trySetMarginIfNotAuto(44, marginLeft, element, em, rem);
        boolean bl = isRightAuto = !MarginApplierUtil.trySetMarginIfNotAuto(45, marginRight, element, em, rem);
        if (isBlock) {
            if (isLeftAuto && isRightAuto) {
                element.setProperty(28, (Object)HorizontalAlignment.CENTER);
            } else if (isLeftAuto) {
                element.setProperty(28, (Object)HorizontalAlignment.RIGHT);
            } else if (isRightAuto) {
                element.setProperty(28, (Object)HorizontalAlignment.LEFT);
            }
        }
    }

    private static boolean trySetMarginIfNotAuto(int marginProperty, String marginValue, IPropertyContainer element, float em, float rem) {
        boolean isAuto = "auto".equals(marginValue);
        if (isAuto) {
            return false;
        }
        Float marginVal = MarginApplierUtil.parseMarginValue(marginValue, em, rem);
        if (marginVal != null) {
            element.setProperty(marginProperty, (Object)UnitValue.createPointValue((float)marginVal.floatValue()));
        }
        return true;
    }

    private static Float parseMarginValue(String marginValString, float em, float rem) {
        UnitValue marginUnitVal = CssUtils.parseLengthValueToPt((String)marginValString, (float)em, (float)rem);
        if (marginUnitVal != null) {
            if (!marginUnitVal.isPointValue()) {
                logger.error("Margin value in percents not supported");
                return null;
            }
            return Float.valueOf(marginUnitVal.getValue());
        }
        return null;
    }
}

