/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.jsoup.nodes;

import com.itextpdf.html2pdf.jsoup.helper.StringUtil;
import com.itextpdf.html2pdf.jsoup.nodes.Document;
import com.itextpdf.html2pdf.jsoup.nodes.Node;
import java.io.IOException;

public class DocumentType
extends Node {
    private static final String NAME = "name";
    private static final String PUBLIC_ID = "publicId";
    private static final String SYSTEM_ID = "systemId";

    public DocumentType(String name, String publicId, String systemId, String baseUri) {
        super(baseUri);
        this.attr(NAME, name);
        this.attr(PUBLIC_ID, publicId);
        this.attr(SYSTEM_ID, systemId);
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.syntax() == Document.OutputSettings.Syntax.html && !this.has(PUBLIC_ID) && !this.has(SYSTEM_ID)) {
            accum.append("<!doctype");
        } else {
            accum.append("<!DOCTYPE");
        }
        if (this.has(NAME)) {
            accum.append(" ").append(this.attr(NAME));
        }
        if (this.has(PUBLIC_ID)) {
            accum.append(" PUBLIC \"").append(this.attr(PUBLIC_ID)).append('\"');
        }
        if (this.has(SYSTEM_ID)) {
            accum.append(" \"").append(this.attr(SYSTEM_ID)).append('\"');
        }
        accum.append('>');
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    private boolean has(String attribute) {
        return !StringUtil.isBlank(this.attr(attribute));
    }
}

