/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.BoxSizingPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WidthHeightApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(WidthHeightApplierUtil.class);

    private WidthHeightApplierUtil() {
    }

    public static void applyWidthHeight(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String maxWidthVal;
        String minWidthVal;
        float em = CssUtils.parseAbsoluteLength(cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        String widthVal = cssProps.get("width");
        if (!"auto".equals(widthVal) && widthVal != null) {
            UnitValue width = CssUtils.parseLengthValueToPt(widthVal, em, rem);
            element.setProperty(77, (Object)width);
        }
        if (!"auto".equals(minWidthVal = cssProps.get("min-width")) && minWidthVal != null) {
            UnitValue minWidth = CssUtils.parseLengthValueToPt(minWidthVal, em, rem);
            element.setProperty(80, (Object)minWidth);
        }
        if (!"auto".equals(maxWidthVal = cssProps.get("max-width")) && maxWidthVal != null) {
            UnitValue maxWidth = CssUtils.parseLengthValueToPt(maxWidthVal, em, rem);
            element.setProperty(79, (Object)maxWidth);
        }
        boolean applyToTable = element instanceof Table;
        boolean applyToCell = element instanceof Cell;
        UnitValue height = null;
        String heightVal = cssProps.get("height");
        if (!(heightVal == null || "auto".equals(heightVal) || (height = CssUtils.parseLengthValueToPt(heightVal, em, rem)) == null || applyToTable || applyToCell)) {
            element.setProperty(27, (Object)height);
        }
        String maxHeightVal = cssProps.get("max-height");
        float maxHeightToApply = 0.0f;
        UnitValue maxHeight = new UnitValue(1, 0.0f);
        if (maxHeightVal != null && (maxHeight = CssUtils.parseLengthValueToPt(maxHeightVal, em, rem)) != null && !applyToTable && !applyToCell) {
            maxHeightToApply = maxHeight.getValue();
        }
        if (maxHeightToApply > 0.0f) {
            element.setProperty(84, (Object)maxHeight);
        }
        String minHeightVal = cssProps.get("min-height");
        float minHeightToApply = 0.0f;
        UnitValue minHeight = new UnitValue(1, 0.0f);
        if (minHeightVal != null && (minHeight = CssUtils.parseLengthValueToPt(minHeightVal, em, rem)) != null && !applyToCell) {
            minHeightToApply = minHeight.getValue();
        }
        if ((applyToTable || applyToCell) && height != null && height.getValue() > minHeightToApply) {
            minHeightToApply = height.getValue();
            if (minHeightToApply > 0.0f) {
                element.setProperty(85, (Object)height);
            }
        } else if (minHeightToApply > 0.0f) {
            element.setProperty(85, (Object)minHeight);
        }
        if ("border-box".equals(cssProps.get("box-sizing"))) {
            element.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
        }
    }
}

