/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.TextArea;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractTextFieldRenderer;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAreaRenderer
extends AbstractTextFieldRenderer {
    public TextAreaRenderer(TextArea modelElement) {
        super(modelElement);
    }

    public int getCols() {
        Integer cols = this.getPropertyAsInteger(0x100007);
        if (cols != null && cols > 0) {
            return cols;
        }
        return (Integer)this.modelElement.getDefaultProperty(0x100007);
    }

    public int getRows() {
        Integer rows = this.getPropertyAsInteger(0x100008);
        if (rows != null && rows > 0) {
            return rows;
        }
        return (Integer)this.modelElement.getDefaultProperty(0x100008);
    }

    protected Float getLastYLineRecursively() {
        if (this.occupiedArea != null && this.occupiedArea.getBBox() != null) {
            return Float.valueOf(this.occupiedArea.getBBox().getBottom());
        }
        return null;
    }

    public IRenderer getNextRenderer() {
        return new TextAreaRenderer((TextArea)this.getModelElement());
    }

    @Override
    protected void adjustFieldLayout() {
        throw new RuntimeException("adjustFieldLayout() is deprecated and shouldn't be used. Override adjustFieldLayout(LayoutContext) instead");
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        List flatLines = ((ParagraphRenderer)this.flatRenderer).getLines();
        this.updatePdfFont((ParagraphRenderer)this.flatRenderer);
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        if (!flatLines.isEmpty() && this.font != null) {
            this.cropContentLines(flatLines, flatBBox);
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Error during layout of form filed with type {0}.", (Object[])new Object[]{"text area"}));
            this.setProperty(0x100003, true);
            flatBBox.setHeight(0.0f);
        }
        flatBBox.setWidth(this.retrieveWidth(layoutContext.getArea().getBBox().getWidth()).floatValue());
    }

    @Override
    protected IRenderer createFlatRenderer() {
        return this.createParagraphRenderer(this.getDefaultValue());
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        this.font.setSubset(false);
        String value = this.getDefaultValue();
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextAreaRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        PdfTextFormField inputField = PdfFormField.createText((PdfDocument)doc, (Rectangle)area, (String)name, (String)value, (PdfFont)this.font, (float)fontSize.getValue());
        inputField.setFieldFlag(PdfFormField.FF_MULTILINE, true);
        inputField.setDefaultValue((PdfObject)new PdfString(this.getDefaultValue()));
        this.applyDefaultFieldProperties((PdfFormField)inputField);
        PdfAcroForm.getAcroForm((PdfDocument)doc, (boolean)true).addField((PdfFormField)inputField, page);
    }

    public <T1> T1 getProperty(int key) {
        if (key == 77) {
            Object width = super.getProperty(77);
            if (width == null) {
                UnitValue fontSize = this.getPropertyAsUnitValue(24);
                if (!fontSize.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(TextAreaRenderer.class);
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                int cols = this.getCols();
                return (T1)UnitValue.createPointValue((float)this.updateHtmlColsSizeBasedWidth(fontSize.getValue() * ((float)cols * 0.5f + 2.0f) + 2.0f));
            }
            return (T1)width;
        }
        return (T1)super.getProperty(key);
    }

    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        if (!this.hasAbsoluteUnitValue(77)) {
            UnitValue width = (UnitValue)this.getProperty(77);
            boolean restoreWidth = this.hasOwnProperty(77);
            this.setProperty(77, null);
            boolean result = super.setMinMaxWidthBasedOnFixedWidth(minMaxWidth);
            if (restoreWidth) {
                this.setProperty(77, width);
            } else {
                this.deleteOwnProperty(77);
            }
            return result;
        }
        return super.setMinMaxWidthBasedOnFixedWidth(minMaxWidth);
    }

    private void cropContentLines(List<LineRenderer> lines, Rectangle bBox) {
        Float height = this.retrieveHeight();
        Float minHeight = this.retrieveMinHeight();
        Float maxHeight = this.retrieveMaxHeight();
        int rowsAttribute = this.getRows();
        float rowsHeight = this.getHeightRowsBased(lines, bBox, rowsAttribute);
        if (height != null && height.floatValue() > 0.0f) {
            this.adjustNumberOfContentLines(lines, bBox, height.floatValue());
        } else if (minHeight != null && minHeight.floatValue() > rowsHeight) {
            this.adjustNumberOfContentLines(lines, bBox, minHeight.floatValue());
        } else if (maxHeight != null && maxHeight.floatValue() > 0.0f && maxHeight.floatValue() < rowsHeight) {
            this.adjustNumberOfContentLines(lines, bBox, maxHeight.floatValue());
        } else {
            this.adjustNumberOfContentLines(lines, bBox, rowsAttribute);
        }
    }
}

