/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProperties;
import com.itextpdf.html2pdf.attach.impl.layout.PageMarginBoxDummyElement;
import com.itextpdf.html2pdf.attach.impl.layout.PageSizeParser;
import com.itextpdf.html2pdf.attach.impl.layout.RunningElementContainer;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.impl.PageMarginBoxCssApplier;
import com.itextpdf.html2pdf.css.apply.util.BackgroundApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.BorderStyleApplierUtil;
import com.itextpdf.html2pdf.css.page.PageMarginBoxContextNode;
import com.itextpdf.html2pdf.css.page.PageMarginRunningElementNode;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.html2pdf.html.node.ITextNode;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageContextProcessor {
    private PageSize pageSize;
    private Set<String> marks;
    private Float bleed;
    private float[] margins;
    private Border[] borders;
    private float[] paddings;
    private Div pageBackgroundSimulation;
    private Div pageBordersSimulation;
    private PageContextProperties properties;
    private ProcessorContext context;

    PageContextProcessor(PageContextProperties properties, ProcessorContext context, PageSize defaultPageSize, float[] defaultPageMargins) {
        this.properties = properties;
        this.context = context;
        this.reset(defaultPageSize, defaultPageMargins);
    }

    PageContextProcessor reset(PageSize defaultPageSize, float[] defaultPageMargins) {
        Map<String, String> styles = this.properties.getResolvedPageContextNode().getStyles();
        float em = CssUtils.parseAbsoluteLength(styles.get("font-size"));
        float rem = this.context.getCssContext().getRootFontSize();
        this.pageSize = PageSizeParser.fetchPageSize(styles.get("size"), em, rem, defaultPageSize);
        UnitValue bleedValue = CssUtils.parseLengthValueToPt(styles.get("bleed"), em, rem);
        if (bleedValue != null && bleedValue.isPointValue()) {
            this.bleed = Float.valueOf(bleedValue.getValue());
        }
        this.marks = PageContextProcessor.parseMarks(styles.get("marks"));
        this.parseMargins(styles, em, rem, defaultPageMargins);
        this.parseBorders(styles, em, rem);
        this.parsePaddings(styles, em, rem);
        this.createPageSimulationElements(styles, this.context);
        this.prepareMarginBoxesSizing(this.properties.getResolvedPageMarginBoxes());
        return this;
    }

    PageSize getPageSize() {
        return this.pageSize;
    }

    float[] computeLayoutMargins() {
        float[] layoutMargins = Arrays.copyOf(this.margins, this.margins.length);
        int i = 0;
        while (i < this.borders.length) {
            float width = this.borders[i] != null ? this.borders[i].getWidth() : 0.0f;
            int n = i++;
            layoutMargins[n] = layoutMargins[n] + width;
        }
        for (i = 0; i < this.paddings.length; ++i) {
            int n = i;
            layoutMargins[n] = layoutMargins[n] + this.paddings[i];
        }
        return layoutMargins;
    }

    void processPageEnd(int pageNum, PdfDocument pdfDocument, DocumentRenderer documentRenderer) {
        this.drawMarginBoxes(pageNum, pdfDocument, documentRenderer);
    }

    void processNewPage(PdfPage page) {
        this.setBleed(page);
        this.drawMarks(page);
        this.drawPageBackgroundAndBorders(page);
    }

    private void setBleed(PdfPage page) {
        if (this.bleed == null && !this.marks.isEmpty()) {
            this.bleed = Float.valueOf(6.0f);
        }
        if (this.bleed != null) {
            Rectangle box = page.getMediaBox();
            box.increaseHeight(this.bleed.floatValue() * 2.0f);
            box.setWidth(box.getWidth() + this.bleed.floatValue() * 2.0f);
            page.setMediaBox(box).setBleedBox(box);
            Rectangle trimBox = page.getTrimBox();
            trimBox.moveUp(this.bleed.floatValue());
            trimBox.moveRight(this.bleed.floatValue());
            page.setTrimBox(trimBox);
        }
    }

    private void drawMarks(PdfPage page) {
        if (this.marks.isEmpty()) {
            return;
        }
        float horizontalIndent = 48.0f;
        float verticalIndent = 57.0f;
        Rectangle mediaBox = page.getMediaBox();
        mediaBox.increaseHeight(verticalIndent * 2.0f);
        mediaBox.setWidth(mediaBox.getWidth() + horizontalIndent * 2.0f);
        page.setMediaBox(mediaBox);
        Rectangle bleedBox = page.getBleedBox();
        bleedBox.moveUp(verticalIndent);
        bleedBox.moveRight(horizontalIndent);
        page.setBleedBox(bleedBox);
        Rectangle trimBox = page.getTrimBox();
        trimBox.moveUp(verticalIndent);
        trimBox.moveRight(horizontalIndent);
        page.setTrimBox(trimBox);
        PdfCanvas canvas = new PdfCanvas(page);
        if (page.getDocument().isTagged()) {
            canvas.openTag((CanvasTag)new CanvasArtifact());
        }
        if (this.marks.contains("crop")) {
            float cropLineLength = 24.0f;
            float verticalCropStartIndent = verticalIndent - cropLineLength;
            float horizontalCropStartIndent = horizontalIndent - cropLineLength;
            canvas.saveState().setLineWidth(0.1f).moveTo((double)trimBox.getLeft(), (double)verticalCropStartIndent).lineTo((double)trimBox.getLeft(), (double)verticalIndent).moveTo((double)horizontalCropStartIndent, (double)trimBox.getTop()).lineTo((double)horizontalIndent, (double)trimBox.getTop()).moveTo((double)trimBox.getRight(), (double)verticalCropStartIndent).lineTo((double)trimBox.getRight(), (double)verticalIndent).moveTo((double)(mediaBox.getWidth() - horizontalCropStartIndent), (double)trimBox.getTop()).lineTo((double)(mediaBox.getWidth() - horizontalIndent), (double)trimBox.getTop()).moveTo((double)trimBox.getLeft(), (double)(mediaBox.getHeight() - verticalCropStartIndent)).lineTo((double)trimBox.getLeft(), (double)(mediaBox.getHeight() - verticalIndent)).moveTo((double)(mediaBox.getWidth() - horizontalCropStartIndent), (double)trimBox.getBottom()).lineTo((double)(mediaBox.getWidth() - horizontalIndent), (double)trimBox.getBottom()).moveTo((double)trimBox.getRight(), (double)(mediaBox.getHeight() - verticalCropStartIndent)).lineTo((double)trimBox.getRight(), (double)(mediaBox.getHeight() - verticalIndent)).moveTo((double)horizontalCropStartIndent, (double)trimBox.getBottom()).lineTo((double)horizontalIndent, (double)trimBox.getBottom()).stroke().restoreState();
        }
        if (this.marks.contains("cross")) {
            float horCrossCenterIndent = verticalIndent - 12.0f;
            float verCrossCenterIndent = horizontalIndent - 12.0f;
            canvas.saveState().setLineWidth(0.1f);
            float x = mediaBox.getWidth() / 2.0f;
            float y = mediaBox.getHeight() - horCrossCenterIndent;
            this.drawCross(canvas, x, y, true);
            x = mediaBox.getWidth() / 2.0f;
            y = horCrossCenterIndent;
            this.drawCross(canvas, x, y, true);
            x = verCrossCenterIndent;
            y = mediaBox.getHeight() / 2.0f;
            this.drawCross(canvas, x, y, false);
            x = mediaBox.getWidth() - verCrossCenterIndent;
            y = mediaBox.getHeight() / 2.0f;
            this.drawCross(canvas, x, y, false);
            canvas.restoreState();
        }
        if (page.getDocument().isTagged()) {
            canvas.closeTag();
        }
    }

    private void drawCross(PdfCanvas canvas, float x, float y, boolean horizontalCross) {
        float yLineHalf;
        float xLineHalf;
        float circleR = 6.0f;
        if (horizontalCross) {
            xLineHalf = 30.0f;
            yLineHalf = 12.0f;
        } else {
            xLineHalf = 12.0f;
            yLineHalf = 30.0f;
        }
        canvas.moveTo((double)(x - xLineHalf), (double)y).lineTo((double)(x + xLineHalf), (double)y).moveTo((double)x, (double)(y - yLineHalf)).lineTo((double)x, (double)(y + yLineHalf));
        canvas.circle((double)x, (double)y, (double)circleR);
        canvas.stroke();
    }

    private void drawPageBackgroundAndBorders(PdfPage page) {
        Canvas canvas = new Canvas(new PdfCanvas(page), page.getDocument(), page.getBleedBox());
        canvas.enableAutoTagging(page);
        canvas.add((IBlockElement)this.pageBackgroundSimulation);
        canvas.close();
        canvas = new Canvas(new PdfCanvas(page), page.getDocument(), page.getTrimBox());
        canvas.enableAutoTagging(page);
        canvas.add((IBlockElement)this.pageBordersSimulation);
        canvas.close();
    }

    private void drawMarginBoxes(int pageNumber, PdfDocument pdfDocument, DocumentRenderer documentRenderer) {
        if (this.properties.getResolvedPageMarginBoxes().isEmpty()) {
            return;
        }
        PdfPage page = pdfDocument.getPage(pageNumber);
        for (PageMarginBoxContextNode marginBoxContentNode : this.properties.getResolvedPageMarginBoxes()) {
            LayoutResult result;
            IRenderer rendererToDraw;
            IElement curBoxElement = this.processMarginBoxContent(marginBoxContentNode, pageNumber, this.context);
            IRenderer renderer = curBoxElement.createRendererSubTree();
            PageContextProcessor.removeAreaBreaks(renderer);
            renderer.setParent((IRenderer)documentRenderer);
            boolean isTagged = pdfDocument.isTagged();
            if (isTagged) {
                LayoutTaggingHelper taggingHelper = (LayoutTaggingHelper)renderer.getProperty(108);
                LayoutTaggingHelper.addTreeHints((LayoutTaggingHelper)taggingHelper, (IRenderer)renderer);
            }
            IRenderer iRenderer = rendererToDraw = (result = renderer.layout(new LayoutContext(new LayoutArea(pageNumber, marginBoxContentNode.getPageMarginBoxRectangle())))).getStatus() == 1 ? renderer : result.getSplitRenderer();
            if (rendererToDraw != null) {
                TagTreePointer tagPointer = null;
                TagTreePointer backupPointer = null;
                PdfPage backupPage = null;
                if (isTagged) {
                    tagPointer = pdfDocument.getTagStructureContext().getAutoTaggingPointer();
                    backupPage = tagPointer.getCurrentPage();
                    backupPointer = new TagTreePointer(tagPointer);
                    tagPointer.moveToRoot();
                    tagPointer.setPageForTagging(page);
                }
                rendererToDraw.setParent((IRenderer)documentRenderer).draw(new DrawContext(page.getDocument(), new PdfCanvas(page), isTagged));
                if (!isTagged) continue;
                tagPointer.setPageForTagging(backupPage);
                tagPointer.moveToPointer(backupPointer);
                continue;
            }
            Logger logger = LoggerFactory.getLogger(PageContextProcessor.class);
            logger.error(MessageFormatUtil.format((String)"Page margin box {0} content cannot be drawn.", (Object[])new Object[]{marginBoxContentNode.getMarginBoxName()}));
        }
    }

    private static Set<String> parseMarks(String marksStr) {
        String[] split;
        HashSet<String> marks = new HashSet<String>();
        if (marksStr == null) {
            return marks;
        }
        for (String mark : split = marksStr.split(" ")) {
            if (!"crop".equals(mark) && !"cross".equals(mark)) {
                marks.clear();
                break;
            }
            marks.add(mark);
        }
        return marks;
    }

    private void parseMargins(Map<String, String> styles, float em, float rem, float[] defaultMarginValues) {
        PageSize pageSize = this.getPageSize();
        this.margins = PageMarginBoxCssApplier.parseBoxProps(styles, em, rem, defaultMarginValues, (Rectangle)pageSize, "margin-top", "margin-right", "margin-bottom", "margin-left");
    }

    private void parsePaddings(Map<String, String> styles, float em, float rem) {
        float defaultPadding = 0.0f;
        PageSize pageSize = this.getPageSize();
        this.paddings = PageMarginBoxCssApplier.parseBoxProps(styles, em, rem, new float[]{defaultPadding, defaultPadding, defaultPadding, defaultPadding}, (Rectangle)pageSize, "padding-top", "padding-right", "padding-bottom", "padding-left");
    }

    private void parseBorders(Map<String, String> styles, float em, float rem) {
        this.borders = BorderStyleApplierUtil.getBordersArray(styles, em, rem);
    }

    private void createPageSimulationElements(Map<String, String> styles, ProcessorContext context) {
        this.pageBackgroundSimulation = new Div().setFillAvailableArea(true);
        BackgroundApplierUtil.applyBackground(styles, context, (IPropertyContainer)this.pageBackgroundSimulation);
        this.pageBackgroundSimulation.getAccessibilityProperties().setRole("Artifact");
        this.pageBordersSimulation = new Div().setFillAvailableArea(true);
        this.pageBordersSimulation.setMargins(this.margins[0], this.margins[1], this.margins[2], this.margins[3]);
        this.pageBordersSimulation.setBorderTop(this.borders[0]);
        this.pageBordersSimulation.setBorderRight(this.borders[1]);
        this.pageBordersSimulation.setBorderBottom(this.borders[2]);
        this.pageBordersSimulation.setBorderLeft(this.borders[3]);
        this.pageBordersSimulation.getAccessibilityProperties().setRole("Artifact");
    }

    private void prepareMarginBoxesSizing(List<PageMarginBoxContextNode> resolvedPageMarginBoxes) {
        Rectangle[] marginBoxRectangles = this.calculateMarginBoxRectangles(resolvedPageMarginBoxes);
        for (PageMarginBoxContextNode marginBoxContentNode : resolvedPageMarginBoxes) {
            if (marginBoxContentNode.childNodes().isEmpty()) {
                throw new IllegalStateException();
            }
            int marginBoxInd = this.mapMarginBoxNameToIndex(marginBoxContentNode.getMarginBoxName());
            marginBoxContentNode.setPageMarginBoxRectangle(marginBoxRectangles[marginBoxInd]);
            marginBoxContentNode.setContainingBlockForMarginBox(this.calculateContainingBlockSizesForMarginBox(marginBoxInd, marginBoxRectangles[marginBoxInd]));
        }
    }

    private IElement processMarginBoxContent(PageMarginBoxContextNode marginBoxContentNode, int pageNumber, ProcessorContext context) {
        PageMarginBoxDummyElement dummyMarginBoxNode = new PageMarginBoxDummyElement();
        ITagWorker marginBoxWorker = context.getTagWorkerFactory().getTagWorker(dummyMarginBoxNode, context);
        for (int i = 0; i < marginBoxContentNode.childNodes().size(); ++i) {
            INode childNode = marginBoxContentNode.childNodes().get(i);
            if (childNode instanceof ITextNode) {
                String text = ((ITextNode)marginBoxContentNode.childNodes().get(i)).wholeText();
                marginBoxWorker.processContent(text, context);
                continue;
            }
            if (childNode instanceof IElementNode) {
                ITagWorker childTagWorker = context.getTagWorkerFactory().getTagWorker((IElementNode)childNode, context);
                if (childTagWorker == null) continue;
                childTagWorker.processEnd((IElementNode)childNode, context);
                marginBoxWorker.processTagChild(childTagWorker, context);
                continue;
            }
            if (childNode instanceof PageMarginRunningElementNode) {
                PageMarginRunningElementNode runningElementNode = (PageMarginRunningElementNode)childNode;
                RunningElementContainer runningElement = context.getCssContext().getRunningManager().getRunningElement(runningElementNode.getRunningElementName(), runningElementNode.getRunningElementOccurrence(), pageNumber);
                if (runningElement == null) continue;
                marginBoxWorker.processTagChild(runningElement.getProcessedElementWorker(), context);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).error("Unknown margin box child");
        }
        marginBoxWorker.processEnd(dummyMarginBoxNode, context);
        if (!(marginBoxWorker.getElementResult() instanceof IElement)) {
            throw new IllegalStateException("Custom tag worker implementation for margin boxes shall return IElement for #getElementResult() call.");
        }
        ICssApplier cssApplier = context.getCssApplierFactory().getCssApplier(dummyMarginBoxNode);
        cssApplier.apply(context, marginBoxContentNode, marginBoxWorker);
        return (IElement)marginBoxWorker.getElementResult();
    }

    private Rectangle[] calculateMarginBoxRectangles(List<PageMarginBoxContextNode> resolvedPageMarginBoxes) {
        float topMargin = this.margins[0];
        float rightMargin = this.margins[1];
        float bottomMargin = this.margins[2];
        float leftMargin = this.margins[3];
        Rectangle withoutMargins = this.pageSize.clone().applyMargins(topMargin, rightMargin, bottomMargin, leftMargin, false);
        float topBottomMarginWidth = withoutMargins.getWidth() / 3.0f;
        float leftRightMarginHeight = withoutMargins.getHeight() / 3.0f;
        Rectangle[] hardcodedBoxRectangles = new Rectangle[]{new Rectangle(0.0f, withoutMargins.getTop(), leftMargin, topMargin), new Rectangle(rightMargin, withoutMargins.getTop(), topBottomMarginWidth, topMargin), new Rectangle(rightMargin + topBottomMarginWidth, withoutMargins.getTop(), topBottomMarginWidth, topMargin), new Rectangle(withoutMargins.getRight() - topBottomMarginWidth, withoutMargins.getTop(), topBottomMarginWidth, topMargin), new Rectangle(withoutMargins.getRight(), withoutMargins.getTop(), topBottomMarginWidth, topMargin), new Rectangle(withoutMargins.getRight(), withoutMargins.getTop() - leftRightMarginHeight, rightMargin, leftRightMarginHeight), new Rectangle(withoutMargins.getRight(), withoutMargins.getBottom() + leftRightMarginHeight, rightMargin, leftRightMarginHeight), new Rectangle(withoutMargins.getRight(), withoutMargins.getBottom(), rightMargin, leftRightMarginHeight), new Rectangle(withoutMargins.getRight(), 0.0f, rightMargin, bottomMargin), new Rectangle(withoutMargins.getRight() - topBottomMarginWidth, 0.0f, topBottomMarginWidth, bottomMargin), new Rectangle(rightMargin + topBottomMarginWidth, 0.0f, topBottomMarginWidth, bottomMargin), new Rectangle(rightMargin, 0.0f, topBottomMarginWidth, bottomMargin), new Rectangle(0.0f, 0.0f, leftMargin, bottomMargin), new Rectangle(0.0f, withoutMargins.getBottom(), leftMargin, leftRightMarginHeight), new Rectangle(0.0f, withoutMargins.getBottom() + leftRightMarginHeight, leftMargin, leftRightMarginHeight), new Rectangle(0.0f, withoutMargins.getTop() - leftRightMarginHeight, leftMargin, leftRightMarginHeight)};
        return hardcodedBoxRectangles;
    }

    private Rectangle calculateContainingBlockSizesForMarginBox(int marginBoxInd, Rectangle pageMarginBoxRectangle) {
        if (marginBoxInd == 0 || marginBoxInd == 4 || marginBoxInd == 8 || marginBoxInd == 12) {
            return pageMarginBoxRectangle;
        }
        Rectangle withoutMargins = this.pageSize.clone().applyMargins(this.margins[0], this.margins[1], this.margins[2], this.margins[3], false);
        if (marginBoxInd < 4) {
            return new Rectangle(withoutMargins.getWidth(), this.margins[0]);
        }
        if (marginBoxInd < 8) {
            return new Rectangle(this.margins[1], withoutMargins.getHeight());
        }
        if (marginBoxInd < 12) {
            return new Rectangle(withoutMargins.getWidth(), this.margins[2]);
        }
        return new Rectangle(this.margins[3], withoutMargins.getWidth());
    }

    private int mapMarginBoxNameToIndex(String marginBoxName) {
        switch (marginBoxName) {
            case "top-left-corner": {
                return 0;
            }
            case "top-left": {
                return 1;
            }
            case "top-center": {
                return 2;
            }
            case "top-right": {
                return 3;
            }
            case "top-right-corner": {
                return 4;
            }
            case "right-top": {
                return 5;
            }
            case "right-middle": {
                return 6;
            }
            case "right-bottom": {
                return 7;
            }
            case "bottom-right-corner": {
                return 8;
            }
            case "bottom-right": {
                return 9;
            }
            case "bottom-center": {
                return 10;
            }
            case "bottom-left": {
                return 11;
            }
            case "bottom-left-corner": {
                return 12;
            }
            case "left-bottom": {
                return 13;
            }
            case "left-middle": {
                return 14;
            }
            case "left-top": {
                return 15;
            }
        }
        return -1;
    }

    private static void removeAreaBreaks(IRenderer renderer) {
        ArrayList<IRenderer> areaBreaks = null;
        for (IRenderer child : renderer.getChildRenderers()) {
            if (child instanceof AreaBreakRenderer) {
                if (areaBreaks == null) {
                    areaBreaks = new ArrayList<IRenderer>();
                }
                areaBreaks.add(child);
                continue;
            }
            PageContextProcessor.removeAreaBreaks(child);
        }
        if (areaBreaks != null) {
            renderer.getChildRenderers().removeAll(areaBreaks);
        }
    }
}

