/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.media;

import com.itextpdf.html2pdf.css.media.MediaDeviceDescription;
import com.itextpdf.html2pdf.css.media.MediaExpression;
import com.itextpdf.html2pdf.css.media.MediaType;
import java.util.List;
import java.util.Objects;

public class MediaQuery {
    private boolean only;
    private boolean not;
    private String type;
    private List<MediaExpression> expressions;

    MediaQuery(String type, List<MediaExpression> expressions, boolean only, boolean not) {
        this.type = type;
        this.expressions = expressions;
        this.only = only;
        this.not = not;
    }

    public boolean matches(MediaDeviceDescription deviceDescription) {
        boolean expressionResult;
        boolean typeMatches = this.type == null || MediaType.ALL.equals(this.type) || Objects.equals(this.type, deviceDescription.getType());
        boolean matchesExpressions = true;
        for (MediaExpression expression : this.expressions) {
            if (expression.matches(deviceDescription)) continue;
            matchesExpressions = false;
            break;
        }
        boolean bl = expressionResult = typeMatches && matchesExpressions;
        if (this.not) {
            expressionResult = !expressionResult;
        }
        return expressionResult;
    }
}

