/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.impl;

import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.ICssApplierFactory;
import com.itextpdf.html2pdf.css.apply.impl.DefaultTagCssApplierMapping;
import com.itextpdf.html2pdf.exception.CssApplierInitializationException;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.util.TagProcessorMapping;

public class DefaultCssApplierFactory
implements ICssApplierFactory {
    private static final ICssApplierFactory INSTANCE = new DefaultCssApplierFactory();
    private TagProcessorMapping defaultMapping = DefaultTagCssApplierMapping.getDefaultCssApplierMapping();

    public static ICssApplierFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public final ICssApplier getCssApplier(IElementNode tag) {
        Class<?> cssApplierClass;
        ICssApplier cssApplier = this.getCustomCssApplier(tag);
        if (cssApplier == null && (cssApplierClass = DefaultCssApplierFactory.getCssApplierClass(this.defaultMapping, tag)) != null) {
            try {
                return (ICssApplier)cssApplierClass.newInstance();
            }
            catch (Exception e) {
                throw new CssApplierInitializationException("Could not instantiate CssApplier-class {0} for tag {1}.", cssApplierClass.getName(), tag.name());
            }
        }
        return cssApplier;
    }

    public ICssApplier getCustomCssApplier(IElementNode tag) {
        return null;
    }

    private static Class<?> getCssApplierClass(TagProcessorMapping mapping, IElementNode tag) {
        String display;
        Class<?> cssApplierClass = null;
        String string = display = tag.getStyles() != null ? tag.getStyles().get("display") : null;
        if (display != null) {
            cssApplierClass = mapping.getMapping(tag.name(), display);
        }
        if (cssApplierClass == null) {
            cssApplierClass = mapping.getMapping(tag.name());
        }
        return cssApplierClass;
    }
}

