/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.UlOlTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.html2pdf.css.apply.util.ListStyleApplierUtil;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.List;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.property.ListSymbolPosition;

public class LiTagWorker
implements ITagWorker {
    protected ListItem listItem = new ListItem();
    protected List list;
    private WaitingInlineElementsHelper inlineHelper;

    public LiTagWorker(IElementNode element, ProcessorContext context) {
        if (!(context.getState().top() instanceof UlOlTagWorker)) {
            this.listItem.setProperty(83, (Object)ListSymbolPosition.INSIDE);
            float em = CssUtils.parseAbsoluteLength(element.getStyles().get("font-size"));
            if ("li".equals(element.name())) {
                ListStyleApplierUtil.setDiscStyle((IPropertyContainer)this.listItem, em);
            } else {
                this.listItem.setProperty(37, null);
            }
            this.list = new List();
            this.list.add(this.listItem);
        }
        this.inlineHelper = new WaitingInlineElementsHelper(element.getStyles().get("white-space"), element.getStyles().get("text-transform"));
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.listItem);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                if (propertyContainer instanceof IBlockElement && "inline-block".equals(((SpanTagWorker)childTagWorker).getElementDisplay(propertyContainer))) {
                    this.inlineHelper.add((IBlockElement)propertyContainer);
                    continue;
                }
                allChildrenProcessed = this.processChild(propertyContainer) && allChildrenProcessed;
            }
            return allChildrenProcessed;
        }
        return this.processChild(childTagWorker.getElementResult());
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.list != null ? this.list : this.listItem;
    }

    private boolean processChild(IPropertyContainer propertyContainer) {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.listItem);
        if (propertyContainer instanceof Image) {
            this.listItem.add((Image)propertyContainer);
            return true;
        }
        if (propertyContainer instanceof IBlockElement) {
            this.listItem.add((IBlockElement)propertyContainer);
            return true;
        }
        return false;
    }
}

