/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.xfdf.ActionObject;
import com.itextpdf.forms.xfdf.AnnotObject;
import com.itextpdf.forms.xfdf.AnnotsObject;
import com.itextpdf.forms.xfdf.AttributeObject;
import com.itextpdf.forms.xfdf.BorderStyleAltObject;
import com.itextpdf.forms.xfdf.DestObject;
import com.itextpdf.forms.xfdf.FObject;
import com.itextpdf.forms.xfdf.FieldObject;
import com.itextpdf.forms.xfdf.FieldsObject;
import com.itextpdf.forms.xfdf.FitObject;
import com.itextpdf.forms.xfdf.IdsObject;
import com.itextpdf.forms.xfdf.XfdfFileUtils;
import com.itextpdf.forms.xfdf.XfdfObject;
import com.itextpdf.forms.xfdf.XfdfObjectUtils;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfCircleAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFreeTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLineAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolyGeomAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPopupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfSquareAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfStampAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextMarkupAnnotation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XfdfObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(XfdfObjectFactory.class);

    public XfdfObject createXfdfObject(PdfDocument document, String filename) {
        PdfAcroForm form = PdfFormCreator.getAcroForm(document, false);
        XfdfObject resultXfdf = new XfdfObject();
        FieldsObject xfdfFields = new FieldsObject();
        if (form != null && form.getRootFormFields() != null && !form.getRootFormFields().isEmpty()) {
            for (String fieldName : form.getAllFormFields().keySet()) {
                String delims = ".";
                StringTokenizer st = new StringTokenizer(fieldName, delims);
                ArrayList<String> nameParts = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    nameParts.add(st.nextToken());
                }
                String name = (String)nameParts.get(nameParts.size() - 1);
                String value = form.getField(fieldName).getValueAsString();
                FieldObject childField = new FieldObject(name, value, false);
                if (nameParts.size() > 1) {
                    FieldObject parentField = new FieldObject();
                    parentField.setName((String)nameParts.get(nameParts.size() - 2));
                    childField.setParent(parentField);
                }
                xfdfFields.addField(childField);
            }
        }
        resultXfdf.setFields(xfdfFields);
        String original = XfdfObjectUtils.convertIdToHexString(document.getOriginalDocumentId().getValue());
        String modified = XfdfObjectUtils.convertIdToHexString(document.getModifiedDocumentId().getValue());
        IdsObject ids = new IdsObject().setOriginal(original).setModified(modified);
        resultXfdf.setIds(ids);
        FObject f = new FObject(filename);
        resultXfdf.setF(f);
        XfdfObjectFactory.addAnnotations(document, resultXfdf);
        return resultXfdf;
    }

    public XfdfObject createXfdfObject(InputStream xfdfInputStream) throws ParserConfigurationException, SAXException {
        XfdfObject xfdfObject = new XfdfObject();
        Document document = XfdfFileUtils.createXfdfDocumentFromStream(xfdfInputStream);
        Element root = document.getDocumentElement();
        List<AttributeObject> xfdfRootAttributes = this.readXfdfRootAttributes(root);
        xfdfObject.setAttributes(xfdfRootAttributes);
        NodeList nodeList = root.getChildNodes();
        this.visitChildNodes(nodeList, xfdfObject);
        return xfdfObject;
    }

    private void visitFNode(Node node, XfdfObject xfdfObject) {
        if (node.getAttributes() != null) {
            Node href = node.getAttributes().getNamedItem("href");
            if (href != null) {
                xfdfObject.setF(new FObject(href.getNodeValue()));
            } else {
                logger.info("Empty f element, no href attribute found.");
            }
        }
    }

    private void visitIdsNode(Node node, XfdfObject xfdfObject) {
        IdsObject idsObject = new IdsObject();
        if (node.getAttributes() != null) {
            Node modified;
            Node original = node.getAttributes().getNamedItem("original");
            if (original != null) {
                idsObject.setOriginal(original.getNodeValue());
            }
            if ((modified = node.getAttributes().getNamedItem("modified")) != null) {
                idsObject.setModified(modified.getNodeValue());
            }
            xfdfObject.setIds(idsObject);
        } else {
            logger.info("Empty ids element, original and/or modified id attributes not found.");
        }
    }

    private void visitElementNode(Node node, XfdfObject xfdfObject) {
        if ("fields".equalsIgnoreCase(node.getNodeName())) {
            FieldsObject fieldsObject = new FieldsObject();
            this.readFieldList(node, fieldsObject);
            xfdfObject.setFields(fieldsObject);
        }
        if ("f".equalsIgnoreCase(node.getNodeName())) {
            this.visitFNode(node, xfdfObject);
        }
        if ("ids".equalsIgnoreCase(node.getNodeName())) {
            this.visitIdsNode(node, xfdfObject);
        }
        if ("annots".equalsIgnoreCase(node.getNodeName())) {
            AnnotsObject annotsObject = new AnnotsObject();
            this.readAnnotsList(node, annotsObject);
            xfdfObject.setAnnots(annotsObject);
        }
    }

    private void visitChildNodes(NodeList nList, XfdfObject xfdfObject) {
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node node = nList.item(temp);
            if (node.getNodeType() != 1) continue;
            this.visitElementNode(node, xfdfObject);
        }
    }

    private static boolean isAnnotSupported(String nodeName) {
        return "text".equalsIgnoreCase(nodeName) || "highlight".equalsIgnoreCase(nodeName) || "underline".equalsIgnoreCase(nodeName) || "strikeout".equalsIgnoreCase(nodeName) || "squiggly".equalsIgnoreCase(nodeName) || "circle".equalsIgnoreCase(nodeName) || "square".equalsIgnoreCase(nodeName) || "polyline".equalsIgnoreCase(nodeName) || "polygon".equalsIgnoreCase(nodeName) || "stamp".equalsIgnoreCase(nodeName) || "line".equalsIgnoreCase(nodeName);
    }

    private void readAnnotsList(Node node, AnnotsObject annotsObject) {
        NodeList annotsNodeList = node.getChildNodes();
        for (int temp = 0; temp < annotsNodeList.getLength(); ++temp) {
            Node currentNode = annotsNodeList.item(temp);
            if (currentNode.getNodeType() != 1 || !this.isAnnotationSubtype(currentNode.getNodeName()) || !XfdfObjectFactory.isAnnotSupported(currentNode.getNodeName())) continue;
            this.visitAnnotationNode(currentNode, annotsObject);
        }
    }

    private void visitAnnotationNode(Node currentNode, AnnotsObject annotsObject) {
        AnnotObject annotObject = new AnnotObject();
        annotObject.setName(currentNode.getNodeName());
        if (currentNode.getAttributes() != null) {
            NamedNodeMap attributes = currentNode.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.addAnnotObjectAttribute(annotObject, attributes.item(i));
            }
            this.visitAnnotationInnerNodes(annotObject, currentNode, annotsObject);
            annotsObject.addAnnot(annotObject);
        }
    }

    private void visitAnnotationInnerNodes(AnnotObject annotObject, Node annotNode, AnnotsObject annotsObject) {
        NodeList children = annotNode.getChildNodes();
        for (int temp = 0; temp < children.getLength(); ++temp) {
            Node node = children.item(temp);
            if (node.getNodeType() != 1) continue;
            if ("contents".equalsIgnoreCase(node.getNodeName())) {
                this.visitContentsSubelement(node, annotObject);
            }
            if ("contents-richtext".equalsIgnoreCase(node.getNodeName())) {
                this.visitContentsRichTextSubelement(node, annotObject);
            }
            if ("popup".equalsIgnoreCase(node.getNodeName())) {
                this.visitPopupSubelement(node, annotObject);
            }
            if ("vertices".equalsIgnoreCase(node.getNodeName())) {
                this.visitVerticesSubelement(node, annotObject);
            }
            if (!this.isAnnotationSubtype(node.getNodeName()) || !XfdfObjectFactory.isAnnotSupported(node.getNodeName())) continue;
            this.visitAnnotationNode(node, annotsObject);
        }
    }

    private void visitPopupSubelement(Node popupNode, AnnotObject annotObject) {
        AnnotObject popupAnnotObject = new AnnotObject();
        NamedNodeMap attributes = popupNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.addAnnotObjectAttribute(popupAnnotObject, attributes.item(i));
        }
        annotObject.setPopup(popupAnnotObject);
    }

    private void visitContentsSubelement(Node parentNode, AnnotObject annotObject) {
        NodeList children = parentNode.getChildNodes();
        for (int temp = 0; temp < children.getLength(); ++temp) {
            Node node = children.item(temp);
            if (node.getNodeType() != 3) continue;
            annotObject.setContents(new PdfString(node.getNodeValue()));
        }
    }

    private void visitContentsRichTextSubelement(Node parentNode, AnnotObject annotObject) {
        NodeList children = parentNode.getChildNodes();
        for (int temp = 0; temp < children.getLength(); ++temp) {
            Node node = children.item(temp);
            if (node.getNodeType() != 3) continue;
            annotObject.setContentsRichText(new PdfString(node.getNodeValue()));
        }
    }

    private void visitVerticesSubelement(Node parentNode, AnnotObject annotObject) {
        NodeList children = parentNode.getChildNodes();
        for (int temp = 0; temp < children.getLength(); ++temp) {
            Node node = children.item(temp);
            if (node.getNodeType() != 3) continue;
            annotObject.setVertices(node.getNodeValue());
        }
    }

    private void addAnnotObjectAttribute(AnnotObject annotObject, Node attributeNode) {
        if (attributeNode != null) {
            String attributeName;
            switch (attributeName = attributeNode.getNodeName()) {
                case "page": {
                    annotObject.addFdfAttributes(Integer.parseInt(attributeNode.getNodeValue()));
                    break;
                }
                case "color": 
                case "date": 
                case "flags": 
                case "name": 
                case "rect": 
                case "title": 
                case "creationdate": 
                case "opacity": 
                case "subject": 
                case "icon": 
                case "state": 
                case "statemodel": 
                case "inreplyto": 
                case "replyType": 
                case "open": 
                case "coords": 
                case "intent": 
                case "interior-color": 
                case "head": 
                case "tail": 
                case "fringe": 
                case "rotation": 
                case "justification": 
                case "width": 
                case "dashes": 
                case "style": 
                case "intensity": {
                    annotObject.addAttribute(new AttributeObject(attributeName, attributeNode.getNodeValue()));
                    break;
                }
                default: {
                    logger.warn("Xfdf unsupported attribute type");
                }
            }
        }
    }

    private boolean isAnnotationSubtype(String tag) {
        return "text".equalsIgnoreCase(tag) || "highlight".equalsIgnoreCase(tag) || "underline".equalsIgnoreCase(tag) || "strikeout".equalsIgnoreCase(tag) || "squiggly".equalsIgnoreCase(tag) || "line".equalsIgnoreCase(tag) || "circle".equalsIgnoreCase(tag) || "square".equalsIgnoreCase(tag) || "caret".equalsIgnoreCase(tag) || "polygon".equalsIgnoreCase(tag) || "polyline".equalsIgnoreCase(tag) || "stamp".equalsIgnoreCase(tag) || "ink".equalsIgnoreCase(tag) || "freetext".equalsIgnoreCase(tag) || "fileattachment".equalsIgnoreCase(tag) || "sound".equalsIgnoreCase(tag) || "link".equalsIgnoreCase(tag) || "redact".equalsIgnoreCase(tag) || "projection".equalsIgnoreCase(tag);
    }

    private void readFieldList(Node node, FieldsObject fieldsObject) {
        NodeList fieldNodeList = node.getChildNodes();
        for (int temp = 0; temp < fieldNodeList.getLength(); ++temp) {
            Node currentNode = fieldNodeList.item(temp);
            if (currentNode.getNodeType() != 1 || !"field".equalsIgnoreCase(currentNode.getNodeName())) continue;
            FieldObject fieldObject = new FieldObject();
            this.visitInnerFields(fieldObject, currentNode, fieldsObject);
        }
    }

    private void visitFieldElementNode(Node node, FieldObject parentField, FieldsObject fieldsObject) {
        if ("value".equalsIgnoreCase(node.getNodeName())) {
            Node valueTextNode = node.getFirstChild();
            if (valueTextNode != null) {
                parentField.setValue(valueTextNode.getTextContent());
            } else {
                logger.info("Field has no value.");
            }
            return;
        }
        if ("field".equalsIgnoreCase(node.getNodeName())) {
            FieldObject childField = new FieldObject();
            childField.setParent(parentField);
            childField.setName(parentField.getName() + "." + node.getAttributes().item(0).getNodeValue());
            if (node.getChildNodes() != null) {
                this.visitInnerFields(childField, node, fieldsObject);
            }
            fieldsObject.addField(childField);
        }
    }

    private void visitInnerFields(FieldObject parentField, Node parentNode, FieldsObject fieldsObject) {
        if (parentNode.getAttributes().getLength() != 0) {
            if (parentField.getName() == null) {
                parentField.setName(parentNode.getAttributes().item(0).getNodeValue());
            }
        } else {
            logger.info("Field has no name attribute.");
        }
        NodeList children = parentNode.getChildNodes();
        for (int temp = 0; temp < children.getLength(); ++temp) {
            Node node = children.item(temp);
            if (node.getNodeType() != 1) continue;
            this.visitFieldElementNode(node, parentField, fieldsObject);
        }
        fieldsObject.addField(parentField);
    }

    private List<AttributeObject> readXfdfRootAttributes(Element root) {
        NamedNodeMap attributes = root.getAttributes();
        int length = attributes.getLength();
        ArrayList<AttributeObject> attributeObjects = new ArrayList<AttributeObject>();
        for (int i = 0; i < length; ++i) {
            Node attributeNode = attributes.item(i);
            attributeObjects.add(new AttributeObject(attributeNode.getNodeName(), attributeNode.getNodeValue()));
        }
        return attributeObjects;
    }

    private static void addPopup(PdfAnnotation pdfAnnot, AnnotsObject annots, int pageNumber) {
        if (((PdfPopupAnnotation)pdfAnnot).getParentObject() != null) {
            PdfAnnotation parentAnnotation = ((PdfPopupAnnotation)pdfAnnot).getParent();
            PdfIndirectReference parentRef = ((PdfDictionary)parentAnnotation.getPdfObject()).getIndirectReference();
            boolean hasParentAnnot = false;
            for (AnnotObject annot : annots.getAnnotsList()) {
                if (!parentRef.equals((Object)annot.getRef())) continue;
                hasParentAnnot = true;
                annot.setHasPopup(true);
                annot.setPopup(XfdfObjectFactory.createXfdfAnnotation(pdfAnnot, pageNumber));
            }
            if (!hasParentAnnot) {
                AnnotObject parentAnnot = new AnnotObject();
                parentAnnot.setRef(parentRef);
                parentAnnot.addFdfAttributes(pageNumber);
                parentAnnot.setHasPopup(true);
                parentAnnot.setPopup(XfdfObjectFactory.createXfdfAnnotation(pdfAnnot, pageNumber));
                annots.addAnnot(parentAnnot);
            }
        } else {
            annots.addAnnot(XfdfObjectFactory.createXfdfAnnotation(pdfAnnot, pageNumber));
        }
    }

    private static void addAnnotation(PdfAnnotation pdfAnnot, AnnotsObject annots, int pageNumber) {
        boolean hasCorrecpondingAnnotObject = false;
        for (AnnotObject annot : annots.getAnnotsList()) {
            if (!((PdfDictionary)pdfAnnot.getPdfObject()).getIndirectReference().equals((Object)annot.getRef())) continue;
            hasCorrecpondingAnnotObject = true;
            XfdfObjectFactory.updateXfdfAnnotation(annot, pdfAnnot, pageNumber);
        }
        if (!hasCorrecpondingAnnotObject) {
            annots.addAnnot(XfdfObjectFactory.createXfdfAnnotation(pdfAnnot, pageNumber));
        }
    }

    private static void addAnnotations(PdfDocument pdfDoc, XfdfObject resultXfdf) {
        AnnotsObject annots = new AnnotsObject();
        int pageNumber = pdfDoc.getNumberOfPages();
        for (int i = 1; i <= pageNumber; ++i) {
            PdfPage page = pdfDoc.getPage(i);
            List pdfAnnots = page.getAnnotations();
            for (PdfAnnotation pdfAnnot : pdfAnnots) {
                if (pdfAnnot.getSubtype() == PdfName.Popup) {
                    XfdfObjectFactory.addPopup(pdfAnnot, annots, i);
                    continue;
                }
                XfdfObjectFactory.addAnnotation(pdfAnnot, annots, i);
            }
        }
        resultXfdf.setAnnots(annots);
    }

    private static void updateXfdfAnnotation(AnnotObject annotObject, PdfAnnotation pdfAnnotation, int pageNumber) {
    }

    private static void addCommonAnnotationAttributes(AnnotObject annot, PdfAnnotation pdfAnnotation) {
        annot.setName(pdfAnnotation.getSubtype().getValue().toLowerCase());
        if (pdfAnnotation.getColorObject() != null) {
            annot.addAttribute(new AttributeObject("color", XfdfObjectUtils.convertColorToString(pdfAnnotation.getColorObject().toFloatArray())));
        }
        annot.addAttribute("date", (PdfObject)pdfAnnotation.getDate());
        String flagsString = XfdfObjectUtils.convertFlagsToString(pdfAnnotation);
        if (flagsString != null) {
            annot.addAttribute(new AttributeObject("flags", flagsString));
        }
        annot.addAttribute("name", (PdfObject)pdfAnnotation.getName());
        annot.addAttribute("rect", pdfAnnotation.getRectangle().toRectangle());
        annot.addAttribute("title", (PdfObject)pdfAnnotation.getTitle());
    }

    private static void addMarkupAnnotationAttributes(AnnotObject annot, PdfMarkupAnnotation pdfMarkupAnnotation) {
        annot.addAttribute("creationdate", (PdfObject)pdfMarkupAnnotation.getCreationDate());
        annot.addAttribute("opacity", (PdfObject)pdfMarkupAnnotation.getOpacity());
        annot.addAttribute("subject", (PdfObject)pdfMarkupAnnotation.getSubject());
    }

    private static void addBorderStyleAttributes(AnnotObject annotObject, PdfNumber width, PdfArray dashes, PdfName style) {
        annotObject.addAttribute("width", (PdfObject)width);
        annotObject.addAttribute("dashes", (PdfObject)XfdfObjectUtils.convertDashesFromArray(dashes));
        annotObject.addAttribute("style", (PdfObject)XfdfObjectUtils.getStyleFullValue(style));
    }

    private static void createTextMarkupAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot, int pageNumber) {
        PdfTextMarkupAnnotation pdfTextMarkupAnnotation = (PdfTextMarkupAnnotation)pdfAnnotation;
        if (pdfTextMarkupAnnotation.getQuadPoints() != null) {
            annot.addAttribute(new AttributeObject("coords", XfdfObjectUtils.convertQuadPointsToCoordsString(pdfTextMarkupAnnotation.getQuadPoints().toFloatArray())));
        }
        if (PdfTextMarkupAnnotation.MarkupUnderline.equals((Object)pdfTextMarkupAnnotation.getSubtype()) && pdfTextMarkupAnnotation.getIntent() != null) {
            annot.addAttribute(new AttributeObject("intent", pdfTextMarkupAnnotation.getIntent().getValue()));
        }
        if (pdfTextMarkupAnnotation.getContents() != null) {
            annot.setContents(pdfTextMarkupAnnotation.getContents());
        }
        if (pdfTextMarkupAnnotation.getPopup() != null) {
            annot.setPopup(XfdfObjectFactory.convertPdfPopupToAnnotObject(pdfTextMarkupAnnotation.getPopup(), pageNumber));
        }
    }

    private static void createTextAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot, int pageNumber) {
        PdfTextAnnotation pdfTextAnnotation = (PdfTextAnnotation)pdfAnnotation;
        annot.addAttribute("icon", (PdfObject)pdfTextAnnotation.getIconName());
        annot.addAttribute("state", (PdfObject)pdfTextAnnotation.getState());
        annot.addAttribute("statemodel", (PdfObject)pdfTextAnnotation.getStateModel());
        if (pdfTextAnnotation.getReplyType() != null) {
            annot.addAttribute(new AttributeObject("inreplyto", pdfTextAnnotation.getInReplyTo().getName().getValue()));
            annot.addAttribute(new AttributeObject("replyType", pdfTextAnnotation.getReplyType().getValue()));
        }
        if (pdfTextAnnotation.getContents() != null) {
            annot.setContents(pdfTextAnnotation.getContents());
        }
        if (pdfTextAnnotation.getPopup() != null) {
            annot.setPopup(XfdfObjectFactory.convertPdfPopupToAnnotObject(pdfTextAnnotation.getPopup(), pageNumber));
        }
    }

    private static void createCircleAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot, int pageNumber) {
        PdfCircleAnnotation pdfCircleAnnotation = (PdfCircleAnnotation)pdfAnnotation;
        PdfDictionary bs = pdfCircleAnnotation.getBorderStyle();
        if (bs != null) {
            XfdfObjectFactory.addBorderStyleAttributes(annot, bs.getAsNumber(PdfName.W), bs.getAsArray(PdfName.D), bs.getAsName(PdfName.S));
        }
        if (pdfCircleAnnotation.getBorderEffect() != null) {
            annot.addAttribute("intensity", (PdfObject)pdfCircleAnnotation.getBorderEffect().getAsNumber(PdfName.I));
            if (annot.getAttribute("style") == null) {
                annot.addAttribute("style", (PdfObject)XfdfObjectUtils.getStyleFullValue(pdfCircleAnnotation.getBorderEffect().getAsName(PdfName.S)));
            }
        }
        if (pdfCircleAnnotation.getInteriorColor() != null && pdfCircleAnnotation.getInteriorColor().getColorValue() != null) {
            annot.addAttribute(new AttributeObject("interior-color", XfdfObjectUtils.convertColorToString(pdfCircleAnnotation.getInteriorColor().getColorValue())));
        }
        if (pdfCircleAnnotation.getRectangleDifferences() != null) {
            annot.addAttribute(new AttributeObject("fringe", XfdfObjectUtils.convertFringeToString(pdfCircleAnnotation.getRectangleDifferences().toFloatArray())));
        }
        annot.setContents(pdfAnnotation.getContents());
        if (pdfCircleAnnotation.getPopup() != null) {
            annot.setPopup(XfdfObjectFactory.convertPdfPopupToAnnotObject(pdfCircleAnnotation.getPopup(), pageNumber));
        }
    }

    private static void createSquareAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot, int pageNumber) {
        PdfSquareAnnotation pdfSquareAnnotation = (PdfSquareAnnotation)pdfAnnotation;
        PdfDictionary bs = pdfSquareAnnotation.getBorderStyle();
        if (bs != null) {
            XfdfObjectFactory.addBorderStyleAttributes(annot, bs.getAsNumber(PdfName.W), bs.getAsArray(PdfName.D), bs.getAsName(PdfName.S));
        }
        if (pdfSquareAnnotation.getBorderEffect() != null) {
            annot.addAttribute("intensity", (PdfObject)pdfSquareAnnotation.getBorderEffect().getAsNumber(PdfName.I));
            if (annot.getAttribute("style") == null) {
                annot.addAttribute("style", (PdfObject)XfdfObjectUtils.getStyleFullValue(pdfSquareAnnotation.getBorderEffect().getAsName(PdfName.S)));
            }
        }
        if (pdfSquareAnnotation.getInteriorColor() != null && pdfSquareAnnotation.getInteriorColor().getColorValue() != null) {
            annot.addAttribute(new AttributeObject("interior-color", XfdfObjectUtils.convertColorToString(pdfSquareAnnotation.getInteriorColor().getColorValue())));
        }
        if (pdfSquareAnnotation.getRectangleDifferences() != null) {
            annot.addAttribute(new AttributeObject("fringe", XfdfObjectUtils.convertFringeToString(pdfSquareAnnotation.getRectangleDifferences().toFloatArray())));
        }
        annot.setContents(pdfAnnotation.getContents());
        if (pdfSquareAnnotation.getPopup() != null) {
            annot.setPopup(XfdfObjectFactory.convertPdfPopupToAnnotObject(pdfSquareAnnotation.getPopup(), pageNumber));
        }
    }

    private static void createStampAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot, int pageNumber) {
        PdfStampAnnotation pdfStampAnnotation = (PdfStampAnnotation)pdfAnnotation;
        annot.addAttribute("icon", (PdfObject)pdfStampAnnotation.getIconName());
        if (pdfStampAnnotation.getRotation() != null) {
            annot.addAttribute("rotation", pdfStampAnnotation.getRotation().intValue());
        }
        if (pdfStampAnnotation.getContents() != null) {
            annot.setContents(pdfStampAnnotation.getContents());
        }
        if (pdfStampAnnotation.getPopup() != null) {
            annot.setPopup(XfdfObjectFactory.convertPdfPopupToAnnotObject(pdfStampAnnotation.getPopup(), pageNumber));
        }
        if (pdfStampAnnotation.getAppearanceDictionary() != null) {
            if (pdfAnnotation.getAppearanceObject(PdfName.N) != null) {
                annot.setAppearance(pdfStampAnnotation.getAppearanceDictionary().get(PdfName.N).toString());
            } else if (pdfAnnotation.getAppearanceObject(PdfName.R) != null) {
                annot.setAppearance(pdfStampAnnotation.getAppearanceDictionary().get(PdfName.R).toString());
            } else if (pdfAnnotation.getAppearanceObject(PdfName.D) != null) {
                annot.setAppearance(pdfStampAnnotation.getAppearanceDictionary().get(PdfName.D).toString());
            }
        }
    }

    private static void createFreeTextAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot) {
        PdfFreeTextAnnotation pdfFreeTextAnnotation = (PdfFreeTextAnnotation)pdfAnnotation;
        PdfDictionary bs = pdfFreeTextAnnotation.getBorderStyle();
        if (bs != null) {
            XfdfObjectFactory.addBorderStyleAttributes(annot, bs.getAsNumber(PdfName.W), bs.getAsArray(PdfName.D), bs.getAsName(PdfName.S));
        }
        if (pdfFreeTextAnnotation.getRotation() != null) {
            annot.addAttribute("rotation", pdfFreeTextAnnotation.getRotation().intValue());
        }
        annot.addAttribute(new AttributeObject("justification", XfdfObjectUtils.convertJustificationFromIntegerToString(pdfFreeTextAnnotation.getJustification())));
        if (pdfFreeTextAnnotation.getIntent() != null) {
            annot.addAttribute(new AttributeObject("intent", pdfFreeTextAnnotation.getIntent().getValue()));
        }
        if (pdfFreeTextAnnotation.getContents() != null) {
            annot.setContents(pdfFreeTextAnnotation.getContents());
        }
        if (pdfFreeTextAnnotation.getDefaultAppearance() != null) {
            annot.setDefaultAppearance(pdfFreeTextAnnotation.getDefaultAppearance().getValue());
        }
        if (pdfFreeTextAnnotation.getDefaultStyleString() != null) {
            annot.setDefaultStyle(pdfFreeTextAnnotation.getDefaultStyleString().getValue());
        }
    }

    private static void createLineAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot, int pageNumber) {
        PdfLineAnnotation pdfLineAnnotation = (PdfLineAnnotation)pdfAnnotation;
        PdfArray line = pdfLineAnnotation.getLine();
        if (line != null) {
            annot.addAttribute(new AttributeObject("start", XfdfObjectUtils.convertLineStartToString(line.toFloatArray())));
            annot.addAttribute(new AttributeObject("end", XfdfObjectUtils.convertLineEndToString(line.toFloatArray())));
        }
        if (pdfLineAnnotation.getLineEndingStyles() != null) {
            if (pdfLineAnnotation.getLineEndingStyles().get(0) != null) {
                annot.addAttribute(new AttributeObject("head", pdfLineAnnotation.getLineEndingStyles().get(0).toString().substring(1)));
            }
            if (pdfLineAnnotation.getLineEndingStyles().get(1) != null) {
                annot.addAttribute(new AttributeObject("tail", pdfLineAnnotation.getLineEndingStyles().get(1).toString().substring(1)));
            }
        }
        if (pdfLineAnnotation.getInteriorColor() != null) {
            annot.addAttribute(new AttributeObject("interior-color", XfdfObjectUtils.convertColorToString(pdfLineAnnotation.getInteriorColor())));
        }
        annot.addAttribute("leaderExtended", pdfLineAnnotation.getLeaderLineExtension());
        annot.addAttribute("leaderLength", pdfLineAnnotation.getLeaderLineLength());
        annot.addAttribute("caption", pdfLineAnnotation.getContentsAsCaption());
        annot.addAttribute("intent", (PdfObject)pdfLineAnnotation.getIntent());
        annot.addAttribute("leader-offset", pdfLineAnnotation.getLeaderLineOffset());
        annot.addAttribute("caption-style", (PdfObject)pdfLineAnnotation.getCaptionPosition());
        if (pdfLineAnnotation.getCaptionOffset() != null) {
            annot.addAttribute("caption-offset-h", pdfLineAnnotation.getCaptionOffset().get(0));
            annot.addAttribute("caption-offset-v", pdfLineAnnotation.getCaptionOffset().get(1));
        } else {
            annot.addAttribute(new AttributeObject("caption-offset-h", "0"));
            annot.addAttribute(new AttributeObject("caption-offset-v", "0"));
        }
        PdfDictionary bs = pdfLineAnnotation.getBorderStyle();
        if (bs != null) {
            XfdfObjectFactory.addBorderStyleAttributes(annot, bs.getAsNumber(PdfName.W), bs.getAsArray(PdfName.D), bs.getAsName(PdfName.S));
        }
        annot.setContents(pdfAnnotation.getContents());
        if (pdfLineAnnotation.getPopup() != null) {
            annot.setPopup(XfdfObjectFactory.convertPdfPopupToAnnotObject(pdfLineAnnotation.getPopup(), pageNumber));
        }
    }

    private static void createLinkAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot) {
        PdfArray border;
        PdfArray dest;
        PdfLinkAnnotation pdfLinkAnnotation = (PdfLinkAnnotation)pdfAnnotation;
        if (pdfLinkAnnotation.getBorderStyle() != null) {
            annot.addAttribute("style", (PdfObject)pdfLinkAnnotation.getBorderStyle().getAsString(PdfName.S));
        }
        if (pdfLinkAnnotation.getHighlightMode() != null) {
            annot.addAttribute("highlight", (PdfObject)XfdfObjectUtils.getHighlightFullValue(pdfLinkAnnotation.getHighlightMode()));
        }
        if (pdfLinkAnnotation.getQuadPoints() != null) {
            annot.addAttribute(new AttributeObject("coords", XfdfObjectUtils.convertQuadPointsToCoordsString(pdfLinkAnnotation.getQuadPoints().toFloatArray())));
        }
        if (pdfLinkAnnotation.getContents() != null) {
            annot.setContents(pdfLinkAnnotation.getContents());
        }
        PdfDictionary action = pdfLinkAnnotation.getAction();
        if (pdfLinkAnnotation.getAction() != null) {
            PdfName type = action.getAsName(PdfName.S);
            ActionObject actionObject = new ActionObject(type);
            if (PdfName.URI.equals((Object)type)) {
                actionObject.setUri(action.getAsString(PdfName.URI));
                if (action.get(PdfName.IsMap) != null) {
                    actionObject.setMap(action.getAsBool(PdfName.IsMap));
                }
            }
            annot.setAction(actionObject);
        }
        if ((dest = (PdfArray)pdfLinkAnnotation.getDestinationObject()) != null) {
            XfdfObjectFactory.createDestElement(dest, annot);
        }
        if ((border = pdfLinkAnnotation.getBorder()) != null) {
            BorderStyleAltObject borderStyleAltObject = new BorderStyleAltObject(border.getAsNumber(0).floatValue(), border.getAsNumber(1).floatValue(), border.getAsNumber(2).floatValue());
            annot.setBorderStyleAlt(borderStyleAltObject);
        }
    }

    private static void createDestElement(PdfArray dest, AnnotObject annot) {
        DestObject destObject = new DestObject();
        PdfName type = dest.getAsName(1);
        if (PdfName.XYZ.equals((Object)type)) {
            FitObject xyz = new FitObject(dest.get(0));
            xyz.setLeft(dest.getAsNumber(2).floatValue()).setTop(dest.getAsNumber(3).floatValue()).setZoom(dest.getAsNumber(4).floatValue());
            destObject.setXyz(xyz);
        } else if (PdfName.Fit.equals((Object)type)) {
            FitObject fit = new FitObject(dest.get(0));
            destObject.setFit(fit);
        } else if (PdfName.FitB.equals((Object)type)) {
            FitObject fitB = new FitObject(dest.get(0));
            destObject.setFitB(fitB);
        } else if (PdfName.FitR.equals((Object)type)) {
            FitObject fitR = new FitObject(dest.get(0));
            fitR.setLeft(dest.getAsNumber(2).floatValue());
            fitR.setBottom(dest.getAsNumber(3).floatValue());
            fitR.setRight(dest.getAsNumber(4).floatValue());
            fitR.setTop(dest.getAsNumber(5).floatValue());
            destObject.setFitR(fitR);
        } else if (PdfName.FitH.equals((Object)type)) {
            FitObject fitH = new FitObject(dest.get(0));
            fitH.setTop(dest.getAsNumber(2).floatValue());
            destObject.setFitH(fitH);
        } else if (PdfName.FitBH.equals((Object)type)) {
            FitObject fitBH = new FitObject(dest.get(0));
            fitBH.setTop(dest.getAsNumber(2).floatValue());
            destObject.setFitBH(fitBH);
        } else if (PdfName.FitBV.equals((Object)type)) {
            FitObject fitBV = new FitObject(dest.get(0));
            fitBV.setLeft(dest.getAsNumber(2).floatValue());
            destObject.setFitBV(fitBV);
        } else if (PdfName.FitV.equals((Object)type)) {
            FitObject fitV = new FitObject(dest.get(0));
            fitV.setLeft(dest.getAsNumber(2).floatValue());
            destObject.setFitV(fitV);
        }
        annot.setDestination(destObject);
    }

    private static void createPolyGeomAnnotation(PdfAnnotation pdfAnnotation, AnnotObject annot, int pageNumber) {
        PdfPolyGeomAnnotation pdfPolyGeomAnnotation = (PdfPolyGeomAnnotation)pdfAnnotation;
        PdfDictionary bs = pdfPolyGeomAnnotation.getBorderStyle();
        if (bs != null) {
            XfdfObjectFactory.addBorderStyleAttributes(annot, bs.getAsNumber(PdfName.W), bs.getAsArray(PdfName.D), bs.getAsName(PdfName.S));
        }
        if (pdfPolyGeomAnnotation.getBorderEffect() != null) {
            annot.addAttribute("intensity", (PdfObject)pdfPolyGeomAnnotation.getBorderEffect().getAsNumber(PdfName.I));
            if (annot.getAttribute("style") == null) {
                annot.addAttribute("style", (PdfObject)XfdfObjectUtils.getStyleFullValue(pdfPolyGeomAnnotation.getBorderEffect().getAsName(PdfName.S)));
            }
        }
        if (pdfPolyGeomAnnotation.getInteriorColor() != null) {
            annot.addAttribute(new AttributeObject("interior-color", XfdfObjectUtils.convertColorToString(pdfPolyGeomAnnotation.getInteriorColor())));
        }
        if (pdfPolyGeomAnnotation.getIntent() != null) {
            annot.addAttribute(new AttributeObject("intent", pdfPolyGeomAnnotation.getIntent().getValue()));
        }
        if (pdfPolyGeomAnnotation.getLineEndingStyles() != null) {
            if (pdfPolyGeomAnnotation.getLineEndingStyles().get(0) != null) {
                annot.addAttribute(new AttributeObject("head", pdfPolyGeomAnnotation.getLineEndingStyles().get(0).toString().substring(1)));
            }
            if (pdfPolyGeomAnnotation.getLineEndingStyles().get(1) != null) {
                annot.addAttribute(new AttributeObject("tail", pdfPolyGeomAnnotation.getLineEndingStyles().get(1).toString().substring(1)));
            }
        }
        annot.setVertices(XfdfObjectUtils.convertVerticesToString(pdfPolyGeomAnnotation.getVertices().toFloatArray()));
        annot.setContents(pdfAnnotation.getContents());
        if (pdfPolyGeomAnnotation.getPopup() != null) {
            annot.setPopup(XfdfObjectFactory.convertPdfPopupToAnnotObject(pdfPolyGeomAnnotation.getPopup(), pageNumber));
        }
    }

    private static AnnotObject createXfdfAnnotation(PdfAnnotation pdfAnnotation, int pageNumber) {
        AnnotObject annot = new AnnotObject();
        annot.setRef(((PdfDictionary)pdfAnnotation.getPdfObject()).getIndirectReference());
        annot.addFdfAttributes(pageNumber);
        if (pdfAnnotation instanceof PdfTextMarkupAnnotation) {
            XfdfObjectFactory.createTextMarkupAnnotation(pdfAnnotation, annot, pageNumber);
        }
        if (pdfAnnotation instanceof PdfTextAnnotation) {
            XfdfObjectFactory.createTextAnnotation(pdfAnnotation, annot, pageNumber);
        }
        if (pdfAnnotation instanceof PdfPopupAnnotation) {
            annot = XfdfObjectFactory.convertPdfPopupToAnnotObject((PdfPopupAnnotation)pdfAnnotation, pageNumber);
        }
        if (pdfAnnotation instanceof PdfCircleAnnotation) {
            XfdfObjectFactory.createCircleAnnotation(pdfAnnotation, annot, pageNumber);
        }
        if (pdfAnnotation instanceof PdfSquareAnnotation) {
            XfdfObjectFactory.createSquareAnnotation(pdfAnnotation, annot, pageNumber);
        }
        if (pdfAnnotation instanceof PdfStampAnnotation) {
            XfdfObjectFactory.createStampAnnotation(pdfAnnotation, annot, pageNumber);
        }
        if (pdfAnnotation instanceof PdfFreeTextAnnotation) {
            XfdfObjectFactory.createFreeTextAnnotation(pdfAnnotation, annot);
        }
        if (pdfAnnotation instanceof PdfLineAnnotation) {
            XfdfObjectFactory.createLineAnnotation(pdfAnnotation, annot, pageNumber);
        }
        if (pdfAnnotation instanceof PdfPolyGeomAnnotation) {
            XfdfObjectFactory.createPolyGeomAnnotation(pdfAnnotation, annot, pageNumber);
        }
        if (pdfAnnotation instanceof PdfLinkAnnotation) {
            XfdfObjectFactory.createLinkAnnotation(pdfAnnotation, annot);
        }
        if (XfdfObjectFactory.isSupportedAnnotation(pdfAnnotation)) {
            XfdfObjectFactory.addCommonAnnotationAttributes(annot, pdfAnnotation);
            if (pdfAnnotation instanceof PdfMarkupAnnotation) {
                XfdfObjectFactory.addMarkupAnnotationAttributes(annot, (PdfMarkupAnnotation)pdfAnnotation);
            }
        }
        return annot;
    }

    private static AnnotObject convertPdfPopupToAnnotObject(PdfPopupAnnotation pdfPopupAnnotation, int pageNumber) {
        AnnotObject annot = new AnnotObject();
        annot.addFdfAttributes(pageNumber);
        annot.setName("popup");
        annot.setRef(((PdfDictionary)pdfPopupAnnotation.getPdfObject()).getIndirectReference());
        annot.addAttribute("open", pdfPopupAnnotation.getOpen());
        return annot;
    }

    private static boolean isSupportedAnnotation(PdfAnnotation pdfAnnotation) {
        return pdfAnnotation instanceof PdfTextMarkupAnnotation || pdfAnnotation instanceof PdfTextAnnotation || pdfAnnotation instanceof PdfCircleAnnotation || pdfAnnotation instanceof PdfSquareAnnotation || pdfAnnotation instanceof PdfStampAnnotation || pdfAnnotation instanceof PdfFreeTextAnnotation || pdfAnnotation instanceof PdfLineAnnotation || pdfAnnotation instanceof PdfPolyGeomAnnotation || pdfAnnotation instanceof PdfLinkAnnotation || pdfAnnotation instanceof PdfPopupAnnotation;
    }
}

