/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.forms.fields.TextFormFieldBuilder;
import com.itextpdf.forms.form.element.TextArea;
import com.itextpdf.forms.form.renderer.AbstractTextFieldRenderer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAreaRenderer
extends AbstractTextFieldRenderer {
    public TextAreaRenderer(TextArea modelElement) {
        super(modelElement);
    }

    public int getCols() {
        Integer cols = this.getPropertyAsInteger(0x200005);
        if (cols != null && cols > 0) {
            return cols;
        }
        return (Integer)this.modelElement.getDefaultProperty(0x200005);
    }

    public int getRows() {
        Integer rows = this.getPropertyAsInteger(0x200006);
        if (rows != null && rows > 0) {
            return rows;
        }
        return (Integer)this.modelElement.getDefaultProperty(0x200006);
    }

    protected Float getLastYLineRecursively() {
        if (this.occupiedArea != null && this.occupiedArea.getBBox() != null) {
            return Float.valueOf(this.occupiedArea.getBBox().getBottom());
        }
        return null;
    }

    public IRenderer getNextRenderer() {
        return new TextAreaRenderer((TextArea)this.getModelElement());
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (fontSize != null && fontSize.getValue() < 1.0E-4f) {
            this.approximateFontSizeToFitMultiLine(layoutContext);
        }
        return super.layout(layoutContext);
    }

    public <T1> T1 getProperty(int key) {
        if (key == 77) {
            Object width = super.getProperty(77);
            if (width == null) {
                float fontSizeValue;
                UnitValue fontSize = this.getPropertyAsUnitValue(24);
                if (!fontSize.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(TextAreaRenderer.class);
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                if ((fontSizeValue = fontSize.getValue()) < 1.0E-4f) {
                    fontSizeValue = 12.0f;
                }
                int cols = this.getCols();
                return (T1)UnitValue.createPointValue((float)this.updateHtmlColsSizeBasedWidth(fontSizeValue * ((float)cols * 0.5f + 2.0f) + 2.0f));
            }
            return (T1)width;
        }
        return (T1)super.getProperty(key);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        List flatLines = ((ParagraphRenderer)this.flatRenderer).getLines();
        this.updatePdfFont((ParagraphRenderer)this.flatRenderer);
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        if (flatLines.isEmpty() || this.font == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Error during layout of form field with type {0}.", (Object[])new Object[]{"text area"}));
            this.setProperty(0x200001, true);
            flatBBox.setHeight(0.0f);
        } else {
            if (!this.hasOwnOrModelProperty(0x200006)) {
                this.setProperty(0x200006, flatLines.size());
            }
            this.cropContentLines(flatLines, flatBBox);
        }
        flatBBox.setWidth(this.retrieveWidth(layoutContext.getArea().getBBox().getWidth()).floatValue());
    }

    @Override
    protected IRenderer createFlatRenderer() {
        return this.createParagraphRenderer(this.getDefaultValue());
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        this.font.setSubset(false);
        String value = this.getDefaultValue();
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextAreaRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.getOccupiedArea().getBBox().clone();
        this.applyMargins(area, false);
        Map<Integer, Object> margins = this.deleteMargins();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        float fontSizeValue = fontSize.getValue();
        PdfString defaultValue = new PdfString(this.getDefaultValue());
        this.modelElement.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
        PdfTextFormField inputField = ((TextFormFieldBuilder)new TextFormFieldBuilder(doc, name).setWidgetRectangle(area)).createMultilineText();
        inputField.disableFieldRegeneration();
        inputField.setValue(value);
        inputField.setFont(this.font).setFontSize(fontSizeValue);
        inputField.setDefaultValue((PdfObject)defaultValue);
        this.applyDefaultFieldProperties(inputField);
        inputField.getFirstFormAnnotation().setFormFieldElement((TextArea)this.modelElement);
        inputField.enableFieldRegeneration();
        PdfFormCreator.getAcroForm(doc, true).addField(inputField, page);
        this.writeAcroFormFieldLangAttribute(doc);
        this.applyProperties(margins);
    }

    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        if (!this.hasAbsoluteUnitValue(77)) {
            UnitValue width = (UnitValue)this.getProperty(77);
            boolean restoreWidth = this.hasOwnProperty(77);
            this.setProperty(77, null);
            boolean result = super.setMinMaxWidthBasedOnFixedWidth(minMaxWidth);
            if (restoreWidth) {
                this.setProperty(77, width);
            } else {
                this.deleteOwnProperty(77);
            }
            return result;
        }
        return super.setMinMaxWidthBasedOnFixedWidth(minMaxWidth);
    }

    @Override
    IRenderer createParagraphRenderer(String defaultValue) {
        if (defaultValue.isEmpty() && null != ((TextArea)this.modelElement).getPlaceholder() && !((TextArea)this.modelElement).getPlaceholder().isEmpty()) {
            return ((TextArea)this.modelElement).getPlaceholder().createRendererSubTree();
        }
        IRenderer flatRenderer = super.createParagraphRenderer(defaultValue);
        flatRenderer.setProperty(103, (Object)OverflowPropertyValue.FIT);
        return flatRenderer;
    }

    private void cropContentLines(List<LineRenderer> lines, Rectangle bBox) {
        Float height = this.retrieveHeight();
        Float minHeight = this.retrieveMinHeight();
        Float maxHeight = this.retrieveMaxHeight();
        int rowsAttribute = this.getRows();
        float rowsHeight = this.getHeightRowsBased(lines, bBox, rowsAttribute);
        if (height != null && height.floatValue() > 0.0f) {
            this.adjustNumberOfContentLines(lines, bBox, height.floatValue());
        } else if (minHeight != null && minHeight.floatValue() > rowsHeight) {
            this.adjustNumberOfContentLines(lines, bBox, minHeight.floatValue());
        } else if (maxHeight != null && maxHeight.floatValue() > 0.0f && maxHeight.floatValue() < rowsHeight) {
            this.adjustNumberOfContentLines(lines, bBox, maxHeight.floatValue());
        } else {
            this.adjustNumberOfContentLines(lines, bBox, rowsAttribute);
        }
    }

    private void approximateFontSizeToFitMultiLine(LayoutContext layoutContext) {
        float fontSize = this.approximateFontSize(layoutContext, 4.0f, 12.0f);
        ((TextArea)this.modelElement).setFontSize(fontSize < 0.0f ? 12.0f : fontSize);
    }
}

