/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.element;

import com.itextpdf.forms.fields.properties.SignedAppearanceText;
import com.itextpdf.forms.form.element.FormField;
import com.itextpdf.forms.form.renderer.SignatureAppearanceRenderer;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SignatureFieldAppearance
extends FormField<SignatureFieldAppearance> {
    private static final float DEFAULT_PADDING = 2.0f;
    private final List<IElement> contentElements = new ArrayList<IElement>();
    private String idWithDots = null;

    public SignatureFieldAppearance(String id) {
        super(id != null && id.contains(".") ? "" : id);
        if (id.contains(".")) {
            this.idWithDots = id;
        }
        this.setProperty(105, BoxSizingPropertyValue.BORDER_BOX);
        this.setProperty(50, UnitValue.createPointValue((float)2.0f));
        this.setProperty(49, UnitValue.createPointValue((float)2.0f));
        this.setProperty(47, UnitValue.createPointValue((float)2.0f));
        this.setProperty(48, UnitValue.createPointValue((float)2.0f));
    }

    public SignatureFieldAppearance setContent(SignedAppearanceText description) {
        this.addTextContent(description.generateDescriptionText());
        return this;
    }

    public SignatureFieldAppearance setContent(String description) {
        this.addTextContent(description);
        return this;
    }

    public SignatureFieldAppearance setContent(SignedAppearanceText description, ImageData image) {
        this.addImageContent(image);
        this.addTextContent(description.generateDescriptionText());
        return this;
    }

    public SignatureFieldAppearance setContent(String description, ImageData image) {
        this.addImageContent(image);
        this.addTextContent(description);
        return this;
    }

    public SignatureFieldAppearance setContent(ImageData image) {
        this.addImageContent(image);
        return this;
    }

    public SignatureFieldAppearance setContent(String signerName, SignedAppearanceText description) {
        this.addTextContent(signerName);
        this.addTextContent(description.generateDescriptionText());
        return this;
    }

    public SignatureFieldAppearance setContent(String signerName, String description) {
        this.addTextContent(signerName);
        this.addTextContent(description);
        return this;
    }

    public SignatureFieldAppearance setContent(Div data) {
        this.contentElements.add((IElement)data);
        return this;
    }

    public List<IElement> getContentElements() {
        return Collections.unmodifiableList(this.contentElements);
    }

    @Override
    public String getId() {
        return this.idWithDots == null ? super.getId() : this.idWithDots;
    }

    protected IRenderer makeNewRenderer() {
        return new SignatureAppearanceRenderer(this);
    }

    private void addTextContent(String text) {
        this.contentElements.add((IElement)((Paragraph)new Paragraph(text).setMargin(0.0f)).setMultipliedLeading(0.9f));
    }

    private void addImageContent(ImageData imageData) {
        this.contentElements.add((IElement)new Image(imageData));
    }
}

