/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.commons.datastructures.NullableContainer;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.FormsMetaInfoStaticContainer;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.forms.fields.TextAndChoiceLegacyDrawer;
import com.itextpdf.forms.fields.borders.FormBorderFactory;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.forms.form.element.Button;
import com.itextpdf.forms.form.element.CheckBox;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.element.InputField;
import com.itextpdf.forms.form.element.Radio;
import com.itextpdf.forms.form.element.TextArea;
import com.itextpdf.forms.form.renderer.checkboximpl.PdfCheckBoxRenderingStrategy;
import com.itextpdf.forms.util.FontSizeUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfFormAnnotation
extends AbstractPdfFormField {
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int VISIBLE = 4;
    public static final String OFF_STATE_VALUE = "Off";
    public static final String ON_STATE_VALUE = "Yes";
    protected float borderWidth = 1.0f;
    protected Color backgroundColor;
    protected Color borderColor;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfFormAnnotation.class);
    private static final String LINE_ENDINGS_REGEXP = "\\r\\n|\\r|\\n";
    private IFormField formFieldElement;

    protected PdfFormAnnotation(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        this((PdfDictionary)widget.makeIndirect(pdfDocument).getPdfObject());
    }

    PdfFormAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfWidgetAnnotation getWidget() {
        PdfName subType = this.getPdfObject().getAsName(PdfName.Subtype);
        if (subType != null && subType.equals((Object)PdfName.Widget)) {
            return (PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)this.getPdfObject());
        }
        assert ("You are not an annotation then" == null);
        return null;
    }

    @Override
    public PdfString getDefaultAppearance() {
        return this.getPdfObject().getAsString(PdfName.DA);
    }

    public PdfFormAnnotation setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        PdfWidgetAnnotation kid = this.getWidget();
        PdfDictionary mk = kid.getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        if (backgroundColor == null) {
            mk.remove(PdfName.BG);
        } else {
            mk.put(PdfName.BG, (PdfObject)new PdfArray(backgroundColor.getColorValue()));
        }
        kid.setAppearanceCharacteristics(mk);
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setRotation(int degRotation) {
        PdfDictionary mk;
        if (degRotation % 90 != 0) {
            throw new IllegalArgumentException("degRotation.must.be.a.multiple.of.90");
        }
        if ((degRotation %= 360) < 0) {
            degRotation += 360;
        }
        if ((mk = this.getWidget().getAppearanceCharacteristics()) == null) {
            mk = new PdfDictionary();
            this.put(PdfName.MK, (PdfObject)mk);
        }
        mk.put(PdfName.R, (PdfObject)new PdfNumber(degRotation));
        this.regenerateField();
        return this;
    }

    public int getRotation() {
        PdfDictionary mk = this.getWidget().getAppearanceCharacteristics();
        return mk == null || mk.getAsInt(PdfName.R) == null ? 0 : mk.getAsInt(PdfName.R);
    }

    public PdfFormAnnotation setAction(PdfAction action) {
        PdfWidgetAnnotation widget = this.getWidget();
        if (widget != null) {
            widget.setAction(action);
        }
        return this;
    }

    public PdfFormAnnotation setVisibility(int visibility) {
        switch (visibility) {
            case 1: {
                this.put(PdfName.F, (PdfObject)new PdfNumber(6));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.put(PdfName.F, (PdfObject)new PdfNumber(36));
                break;
            }
            default: {
                this.put(PdfName.F, (PdfObject)new PdfNumber(4));
            }
        }
        return this;
    }

    @Override
    public boolean regenerateField() {
        if (this.parent != null) {
            this.parent.updateDefaultAppearance();
        }
        return this.regenerateWidget();
    }

    public float getBorderWidth() {
        PdfNumber w;
        PdfDictionary bs = this.getWidget().getBorderStyle();
        if (bs != null && (w = bs.getAsNumber(PdfName.W)) != null) {
            this.borderWidth = w.floatValue();
        }
        return this.borderWidth;
    }

    public Border getBorder() {
        float borderWidth = this.getBorderWidth();
        Border border = FormBorderFactory.getBorder(this.getWidget().getBorderStyle(), borderWidth, this.borderColor, this.backgroundColor);
        if (border == null && borderWidth > 0.0f && this.borderColor != null) {
            border = new SolidBorder(this.borderColor, Math.max(1.0f, borderWidth));
        }
        return border;
    }

    public PdfFormAnnotation setBorderWidth(float borderWidth) {
        int roundedBorderWidth = Math.round(borderWidth);
        PdfDictionary bs = this.getWidget().getBorderStyle();
        if (bs == null) {
            bs = new PdfDictionary();
            this.put(PdfName.BS, (PdfObject)bs);
        }
        bs.put(PdfName.W, (PdfObject)new PdfNumber(roundedBorderWidth));
        this.borderWidth = roundedBorderWidth;
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setBorderStyle(PdfDictionary style) {
        this.getWidget().setBorderStyle(style);
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setBorderColor(Color color) {
        this.borderColor = color;
        PdfWidgetAnnotation kid = this.getWidget();
        PdfDictionary mk = kid.getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        if (this.borderColor == null) {
            mk.remove(PdfName.BC);
        } else {
            mk.put(PdfName.BC, (PdfObject)new PdfArray(this.borderColor.getColorValue()));
        }
        kid.setAppearanceCharacteristics(mk);
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setPage(int pageNum) {
        PdfWidgetAnnotation widget = this.getWidget();
        if (widget != null) {
            widget.setPage(this.getDocument().getPage(pageNum));
        }
        return this;
    }

    public PdfFormAnnotation setFormFieldElement(IFormField element) {
        this.formFieldElement = element;
        this.regenerateWidget();
        return this;
    }

    @Override
    public String[] getAppearanceStates() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        PdfDictionary dic = this.getPdfObject();
        if ((dic = dic.getAsDictionary(PdfName.AP)) != null && (dic = dic.getAsDictionary(PdfName.N)) != null) {
            for (PdfName state : dic.keySet()) {
                names.add(state.getValue());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public PdfFormAnnotation setAppearance(PdfName appearanceType, String appearanceState, PdfStream appearanceStream) {
        PdfDictionary dic = this.getPdfObject();
        PdfDictionary ap = dic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            PdfDictionary appearanceDictionary = ap.getAsDictionary(appearanceType);
            if (appearanceDictionary == null) {
                ap.put(appearanceType, (PdfObject)appearanceStream);
            } else {
                appearanceDictionary.put(new PdfName(appearanceState), (PdfObject)appearanceStream);
            }
        }
        return this;
    }

    public static PdfFormAnnotation makeFormAnnotation(PdfObject pdfObject, PdfDocument document) {
        if (!pdfObject.isDictionary()) {
            return null;
        }
        PdfDictionary dictionary = (PdfDictionary)pdfObject;
        PdfName subType = dictionary.getAsName(PdfName.Subtype);
        if (!PdfName.Widget.equals((Object)subType)) {
            return null;
        }
        PdfFormAnnotation field = new PdfFormAnnotation((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)dictionary), document);
        field.makeIndirect(document);
        if (document != null && document.getReader() != null && document.getReader().getPdfAConformanceLevel() != null) {
            field.pdfAConformanceLevel = document.getReader().getPdfAConformanceLevel();
        }
        return field;
    }

    protected Rectangle getRect(PdfDictionary field) {
        PdfArray rect = field.getAsArray(PdfName.Rect);
        return rect == null ? null : rect.toRectangle();
    }

    protected void drawBorder(PdfCanvas canvas, PdfFormXObject xObject, float width, float height) {
        PdfArray matrix;
        canvas.saveState();
        float borderWidth = this.getBorderWidth();
        PdfDictionary bs = this.getWidget().getBorderStyle();
        if (borderWidth < 0.0f) {
            borderWidth = 0.0f;
        }
        if (this.backgroundColor != null) {
            canvas.setFillColor(this.backgroundColor).rectangle(0.0, 0.0, (double)width, (double)height).fill();
        }
        if (borderWidth > 0.0f && this.borderColor != null) {
            borderWidth = Math.max(1.0f, borderWidth);
            canvas.setStrokeColor(this.borderColor).setLineWidth(borderWidth);
            Border border = FormBorderFactory.getBorder(bs, borderWidth, this.borderColor, this.backgroundColor);
            if (border != null) {
                float borderWidthX2 = borderWidth + borderWidth;
                border.draw(canvas, new Rectangle(borderWidth, borderWidth, width - borderWidthX2, height - borderWidthX2));
            } else {
                canvas.rectangle(0.0, 0.0, (double)width, (double)height).stroke();
            }
        }
        if ((matrix = PdfFormAnnotation.getRotationMatrix(this.getRotation() % 360, height, width)) != null) {
            xObject.put(PdfName.Matrix, (PdfObject)matrix);
        }
        canvas.restoreState();
    }

    protected void drawPushButtonFieldAndSaveAppearance() {
        Image image;
        float imagePadding;
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        float width = rectangle.getWidth();
        float height = rectangle.getHeight();
        this.createInputButton();
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(this.getRotation() % 360, height, width);
        if (matrix != null) {
            xObject.put(PdfName.Matrix, (PdfObject)matrix);
        }
        Canvas canvas = new Canvas(xObject, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        String caption = this.parent.getDisplayValue();
        if (caption != null && !caption.isEmpty()) {
            ((Button)this.formFieldElement).setSingleLineValue(caption);
        }
        float f = imagePadding = this.borderColor == null ? 0.0f : this.borderWidth;
        if (this.parent.img != null) {
            this.formFieldElement.getChildren().clear();
            image = new Image(new PdfImageXObject(this.parent.img), imagePadding, imagePadding);
            image.setHeight(height - 2.0f * imagePadding);
            image.setWidth(width - 2.0f * imagePadding);
            ((Button)this.formFieldElement).add(image);
        } else if (this.parent.form != null) {
            this.formFieldElement.getChildren().clear();
            image = new Image(this.parent.form, imagePadding, imagePadding);
            image.setHeight(height - 2.0f * imagePadding);
            ((Button)this.formFieldElement).add(image);
        } else {
            xObject.getResources().addFont(this.getDocument(), this.getFont());
        }
        canvas.add((IBlockElement)this.formFieldElement);
        PdfDictionary ap = new PdfDictionary();
        PdfStream normalAppearanceStream = (PdfStream)xObject.getPdfObject();
        if (normalAppearanceStream != null) {
            PdfName stateName = this.getPdfObject().getAsName(PdfName.AS);
            if (stateName == null) {
                stateName = new PdfName("push");
            }
            this.getPdfObject().put(PdfName.AS, (PdfObject)stateName);
            PdfDictionary normalAppearance = new PdfDictionary();
            normalAppearance.put(stateName, (PdfObject)normalAppearanceStream);
            ap.put(PdfName.N, (PdfObject)normalAppearance);
            ap.setModified();
        }
        this.put(PdfName.AP, (PdfObject)ap);
        canvas.setProperty(108, null);
        canvas.close();
    }

    protected void drawRadioButtonAndSaveAppearance(String value) {
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        if (!(this.formFieldElement instanceof Radio)) {
            this.formFieldElement = new Radio("");
        }
        this.setModelElementProperties(this.getRect(this.getPdfObject()));
        ((Radio)this.formFieldElement).setChecked(false);
        PdfFormXObject xObjectOff = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
        Canvas canvasOff = new Canvas(xObjectOff, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvasOff);
        canvasOff.add((IBlockElement)this.formFieldElement);
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(OFF_STATE_VALUE), xObjectOff.getPdfObject());
        if (value != null && !value.isEmpty() && !OFF_STATE_VALUE.equals(value)) {
            ((Radio)this.formFieldElement).setChecked(true);
            PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
            Canvas canvas = new Canvas(xObject, this.getDocument());
            PdfFormAnnotation.setMetaInfoToCanvas(canvas);
            canvas.add((IBlockElement)this.formFieldElement);
            normalAppearance.put(new PdfName(value), xObject.getPdfObject());
        }
        this.getWidget().setNormalAppearance(normalAppearance);
    }

    protected void drawTextFormFieldAndSaveAppearance() {
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        String value = this.parent.getDisplayValue();
        if (!(this.parent.isMultiline() && this.formFieldElement instanceof TextArea || !this.parent.isMultiline() && this.formFieldElement instanceof InputField)) {
            IFormField iFormField = this.formFieldElement = this.parent.isMultiline() ? new TextArea("") : new InputField("");
        }
        if (this.parent.isMultiline()) {
            this.formFieldElement.setProperty(24, UnitValue.createPointValue((float)this.getFontSize()));
        } else {
            this.formFieldElement.setProperty(24, UnitValue.createPointValue((float)this.getFontSize(new PdfArray(rectangle), this.parent.getValueAsString())));
            value = value.replaceAll(LINE_ENDINGS_REGEXP, " ");
        }
        this.formFieldElement.setValue(value);
        this.formFieldElement.setProperty(20, this.getFont());
        this.formFieldElement.setProperty(70, this.parent.getJustification());
        this.formFieldElement.setProperty(0x200004, this.getParentField().isPassword());
        this.formFieldElement.setProperty(137, Boolean.TRUE);
        if (this.getColor() != null) {
            this.formFieldElement.setProperty(21, new TransparentColor(this.getColor()));
        }
        int fieldRotation = this.getRotation() % 360;
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(fieldRotation, rectangle.getHeight(), rectangle.getWidth());
        if (fieldRotation == 90 || fieldRotation == 270) {
            Rectangle invertedRectangle = rectangle.clone();
            invertedRectangle.setWidth(rectangle.getHeight());
            invertedRectangle.setHeight(rectangle.getWidth());
            rectangle = invertedRectangle;
        }
        this.setModelElementProperties(rectangle);
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
        if (matrix != null) {
            xObject.put(PdfName.Matrix, (PdfObject)matrix);
        }
        Canvas canvas = new Canvas(xObject, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        canvas.setProperty(82, (Object)Boolean.TRUE);
        canvas.add((IBlockElement)this.formFieldElement);
        this.getWidget().setNormalAppearance((PdfDictionary)xObject.getPdfObject());
    }

    @Override
    void retrieveStyles() {
        super.retrieveStyles();
        PdfDictionary appearanceCharacteristics = this.getPdfObject().getAsDictionary(PdfName.MK);
        if (appearanceCharacteristics != null) {
            this.backgroundColor = PdfFormAnnotation.appearancePropToColor(appearanceCharacteristics, PdfName.BG);
            Color extractedBorderColor = PdfFormAnnotation.appearancePropToColor(appearanceCharacteristics, PdfName.BC);
            if (extractedBorderColor != null) {
                this.borderColor = extractedBorderColor;
            }
        }
    }

    static void setMetaInfoToCanvas(Canvas canvas) {
        MetaInfoContainer metaInfo = FormsMetaInfoStaticContainer.getMetaInfoForLayout();
        if (metaInfo != null) {
            canvas.setProperty(135, (Object)metaInfo);
        }
    }

    boolean regenerateWidget() {
        if (this.parent == null) {
            return true;
        }
        PdfName type = this.parent.getFormType();
        if (PdfName.Ch.equals((Object)type) || this.isCombTextFormField()) {
            return TextAndChoiceLegacyDrawer.regenerateTextAndChoiceField(this);
        }
        if (PdfName.Tx.equals((Object)type)) {
            this.drawTextFormFieldAndSaveAppearance();
            return true;
        }
        if (PdfName.Btn.equals((Object)type)) {
            if (this.parent.getFieldFlag(PdfButtonFormField.FF_PUSH_BUTTON)) {
                this.drawPushButtonFieldAndSaveAppearance();
            } else if (this.parent.getFieldFlag(PdfButtonFormField.FF_RADIO)) {
                this.drawRadioButtonAndSaveAppearance(this.getRadioButtonValue());
            } else {
                this.drawCheckBoxAndSaveAppearance(this.parent.getValueAsString());
            }
            return true;
        }
        return false;
    }

    void createInputButton() {
        if (!(this.formFieldElement instanceof Button)) {
            this.formFieldElement = new Button(this.parent.getFieldName().toUnicodeString());
        }
        ((Button)this.formFieldElement).setFont(this.getFont());
        ((Button)this.formFieldElement).setFontSize(this.getFontSize(this.getPdfObject().getAsArray(PdfName.Rect), this.parent.getDisplayValue()));
        if (this.getColor() != null) {
            ((Button)this.formFieldElement).setFontColor(this.color);
        }
        this.setModelElementProperties(this.getRect(this.getPdfObject()));
    }

    float getFontSize(PdfArray bBox, String value) {
        if (this.getFontSize() == 0.0f) {
            if (bBox == null || value == null || value.isEmpty()) {
                return 12.0f;
            }
            return FontSizeUtil.approximateFontSizeToFitSingleLine(this.getFont(), bBox.toRectangle(), value, 4.0f, this.borderWidth);
        }
        return this.getFontSize();
    }

    private boolean isCombTextFormField() {
        PdfName type = this.parent.getFormType();
        if (PdfName.Tx.equals((Object)type) && this.parent.getFieldFlag(PdfTextFormField.FF_COMB)) {
            int maxLen = new PdfTextFormField(this.parent.getPdfObject()).getMaxLen();
            if (maxLen == 0 || this.parent.isMultiline()) {
                LOGGER.error(MessageFormatUtil.format((String)"The Comb flag may be set only if the MaxLen entry is present in the text field dictionary and if the Multiline, Password, and FileSelect flags are clear.", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    private String getRadioButtonValue() {
        for (String state : this.getAppearanceStates()) {
            if (OFF_STATE_VALUE.equals(state)) continue;
            return state;
        }
        return null;
    }

    private static PdfArray getRotationMatrix(int rotation, float height, float width) {
        switch (rotation) {
            case 0: {
                return null;
            }
            case 90: {
                return new PdfArray(new float[]{0.0f, 1.0f, -1.0f, 0.0f, height, 0.0f});
            }
            case 180: {
                return new PdfArray(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, width, height});
            }
            case 270: {
                return new PdfArray(new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, width});
            }
        }
        Logger logger = LoggerFactory.getLogger(PdfFormAnnotation.class);
        logger.error("Encountered a widget rotation that was not a multiple of 90\u00b0/ (Pi/2) when generating default appearances for form fields");
        return null;
    }

    private static Color appearancePropToColor(PdfDictionary appearanceCharacteristics, PdfName property) {
        PdfArray colorData = appearanceCharacteristics.getAsArray(property);
        if (colorData != null) {
            float[] backgroundFloat = new float[colorData.size()];
            for (int i = 0; i < colorData.size(); ++i) {
                backgroundFloat[i] = colorData.getAsNumber(i).floatValue();
            }
            switch (colorData.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new DeviceGray(backgroundFloat[0]);
                }
                case 3: {
                    return new DeviceRgb(backgroundFloat[0], backgroundFloat[1], backgroundFloat[2]);
                }
                case 4: {
                    return new DeviceCmyk(backgroundFloat[0], backgroundFloat[1], backgroundFloat[2], backgroundFloat[3]);
                }
            }
        }
        return null;
    }

    protected void drawCheckBoxAndSaveAppearance(String onStateName) {
        Rectangle rect = this.getRect(this.getPdfObject());
        if (rect == null) {
            return;
        }
        this.reconstructCheckBoxType();
        this.createCheckBox();
        if (this.getWidget().getNormalAppearanceObject() == null) {
            this.getWidget().setNormalAppearance(new PdfDictionary());
        }
        PdfDictionary normalAppearance = new PdfDictionary();
        ((CheckBox)this.formFieldElement).setChecked(false);
        PdfFormXObject xObjectOff = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        Canvas canvasOff = new Canvas(xObjectOff, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvasOff);
        canvasOff.add((IBlockElement)this.formFieldElement);
        if (this.getPdfAConformanceLevel() == null) {
            xObjectOff.getResources().addFont(this.getDocument(), this.getFont());
        }
        normalAppearance.put(new PdfName(OFF_STATE_VALUE), xObjectOff.getPdfObject());
        String onStateNameForAp = onStateName;
        if (onStateName == null || onStateName.isEmpty() || OFF_STATE_VALUE.equals(onStateName)) {
            onStateNameForAp = ON_STATE_VALUE;
        }
        ((CheckBox)this.formFieldElement).setChecked(true);
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        Canvas canvas = new Canvas(xObject, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        canvas.add((IBlockElement)this.formFieldElement);
        normalAppearance.put(new PdfName(onStateNameForAp), xObject.getPdfObject());
        this.getWidget().setNormalAppearance(normalAppearance);
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString((String)PdfCheckBoxRenderingStrategy.ZAPFDINGBATS_CHECKBOX_MAPPING.getByKey(this.parent.checkType.getValue())));
        this.getWidget().put(PdfName.MK, (PdfObject)mk);
        this.setCheckBoxAppearanceState(onStateName);
    }

    private void setCheckBoxAppearanceState(String onStateName) {
        PdfWidgetAnnotation widget = this.getWidget();
        if (widget.getNormalAppearanceObject() != null && widget.getNormalAppearanceObject().containsKey(new PdfName(onStateName))) {
            widget.setAppearanceState(new PdfName(onStateName));
        } else {
            widget.setAppearanceState(new PdfName(OFF_STATE_VALUE));
        }
    }

    private void reconstructCheckBoxType() {
        PdfString oldCa;
        PdfDictionary oldMk;
        if (this.parent.checkType == null && (oldMk = this.getWidget().getAppearanceCharacteristics()) != null && (oldCa = oldMk.getAsString(PdfName.CA)) != null && PdfCheckBoxRenderingStrategy.ZAPFDINGBATS_CHECKBOX_MAPPING.containsValue((Object)oldCa.getValue())) {
            this.parent.checkType = new NullableContainer(PdfCheckBoxRenderingStrategy.ZAPFDINGBATS_CHECKBOX_MAPPING.getByValue((Object)oldCa.getValue()));
            this.fontSize = 0.0f;
        }
        if (this.parent.checkType == null) {
            this.parent.checkType = new NullableContainer((Object)CheckBoxType.CROSS);
        }
    }

    private void createCheckBox() {
        if (!(this.formFieldElement instanceof CheckBox)) {
            this.formFieldElement = new CheckBox("");
        }
        this.formFieldElement.setProperty(24, UnitValue.createPointValue((float)this.getFontSize()));
        this.setModelElementProperties(this.getRect(this.getPdfObject()));
        ((CheckBox)this.formFieldElement).setPdfAConformanceLevel(this.getPdfAConformanceLevel());
        ((CheckBox)this.formFieldElement).setCheckBoxType((CheckBoxType)((Object)this.parent.checkType.getValue()));
    }

    private void setModelElementProperties(Rectangle rectangle) {
        if (this.backgroundColor != null) {
            this.formFieldElement.setProperty(6, new Background(this.backgroundColor));
        }
        this.formFieldElement.setProperty(9, this.getBorder());
        BoxSizingPropertyValue boxSizing = (BoxSizingPropertyValue)this.formFieldElement.getProperty(105);
        float extraBorderWidth = BoxSizingPropertyValue.CONTENT_BOX == boxSizing ? 2.0f * this.borderWidth : 0.0f;
        this.formFieldElement.setWidth(rectangle.getWidth() - extraBorderWidth);
        this.formFieldElement.setHeight(rectangle.getHeight() - extraBorderWidth);
        this.formFieldElement.setInteractive(false);
    }
}

