/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.forms.xfdf.ActionObject;
import com.itextpdf.forms.xfdf.AttributeNotFoundException;
import com.itextpdf.forms.xfdf.AttributeObject;
import com.itextpdf.forms.xfdf.BorderStyleAltObject;
import com.itextpdf.forms.xfdf.DestObject;
import com.itextpdf.forms.xfdf.XfdfObjectUtils;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.ArrayList;
import java.util.List;

public class AnnotObject {
    private String name;
    private List<AttributeObject> attributes = new ArrayList<AttributeObject>();
    private PdfString contents;
    private PdfString contentsRichText;
    private boolean hasPopup;
    private AnnotObject popup;
    private ActionObject action;
    private DestObject destination;
    private String appearance;
    private String defaultAppearance;
    private String defaultStyle;
    private BorderStyleAltObject borderStyleAlt;
    private String vertices;
    private PdfIndirectReference ref;

    public String getName() {
        return this.name;
    }

    public AnnotObject setName(String name) {
        this.name = name;
        return this;
    }

    public List<AttributeObject> getAttributes() {
        return this.attributes;
    }

    public AttributeObject getAttribute(String name) {
        for (AttributeObject attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public String getAttributeValue(String name) {
        for (AttributeObject attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public AnnotObject getPopup() {
        return this.popup;
    }

    public AnnotObject setPopup(AnnotObject popup) {
        this.popup = popup;
        return this;
    }

    public boolean isHasPopup() {
        return this.hasPopup;
    }

    public AnnotObject setHasPopup(boolean hasPopup) {
        this.hasPopup = hasPopup;
        return this;
    }

    public PdfString getContents() {
        return this.contents;
    }

    public AnnotObject setContents(PdfString contents) {
        this.contents = contents;
        return this;
    }

    public PdfString getContentsRichText() {
        return this.contentsRichText;
    }

    public AnnotObject setContentsRichText(PdfString contentsRichRext) {
        this.contentsRichText = contentsRichRext;
        return this;
    }

    public ActionObject getAction() {
        return this.action;
    }

    public AnnotObject setAction(ActionObject action) {
        this.action = action;
        return this;
    }

    public void addAttribute(AttributeObject attr) {
        this.attributes.add(attr);
    }

    void addAttribute(String name, boolean value) {
        String valueString = value ? "yes" : "no";
        this.attributes.add(new AttributeObject(name, valueString));
    }

    void addAttribute(String name, float value) {
        this.attributes.add(new AttributeObject(name, String.valueOf(value)));
    }

    void addAttribute(String name, Rectangle value) {
        String stringValue = XfdfObjectUtils.convertRectToString(value);
        this.attributes.add(new AttributeObject(name, stringValue));
    }

    void addAttribute(String name, PdfObject valueObject, boolean required) {
        if (valueObject == null) {
            if (required) {
                throw new AttributeNotFoundException(name);
            }
            return;
        }
        String valueString = null;
        if (valueObject.getType() == 2) {
            valueString = ((PdfBoolean)valueObject).getValue() ? "yes" : "no";
        } else if (valueObject.getType() == 6) {
            valueString = ((PdfName)valueObject).getValue();
        } else if (valueObject.getType() == 8) {
            valueString = String.valueOf(((PdfNumber)valueObject).getValue());
        } else if (valueObject.getType() == 10) {
            valueString = ((PdfString)valueObject).getValue();
        }
        this.attributes.add(new AttributeObject(name, valueString));
    }

    void addAttribute(String name, PdfObject valueObject) {
        this.addAttribute(name, valueObject, false);
    }

    void addFdfAttributes(int pageNumber) {
        this.addAttribute(new AttributeObject("page", String.valueOf(pageNumber)));
    }

    public DestObject getDestination() {
        return this.destination;
    }

    public AnnotObject setDestination(DestObject destination) {
        this.destination = destination;
        return this;
    }

    public String getAppearance() {
        return this.appearance;
    }

    public AnnotObject setAppearance(String appearance) {
        this.appearance = appearance;
        return this;
    }

    public String getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public AnnotObject setDefaultAppearance(String defaultAppearance) {
        this.defaultAppearance = defaultAppearance;
        return this;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public AnnotObject setDefaultStyle(String defaultStyle) {
        this.defaultStyle = defaultStyle;
        return this;
    }

    public BorderStyleAltObject getBorderStyleAlt() {
        return this.borderStyleAlt;
    }

    public AnnotObject setBorderStyleAlt(BorderStyleAltObject borderStyleAlt) {
        this.borderStyleAlt = borderStyleAlt;
        return this;
    }

    public String getVertices() {
        return this.vertices;
    }

    public AnnotObject setVertices(String vertices) {
        this.vertices = vertices;
        return this;
    }

    public PdfIndirectReference getRef() {
        return this.ref;
    }

    public AnnotObject setRef(PdfIndirectReference ref) {
        this.ref = ref;
        return this;
    }
}

