/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;

public class PdfTextFormField
extends PdfFormField {
    public static final int FF_FILE_SELECT = PdfTextFormField.makeFieldFlag(21);
    public static final int FF_DO_NOT_SPELL_CHECK = PdfTextFormField.makeFieldFlag(23);
    public static final int FF_DO_NOT_SCROLL = PdfTextFormField.makeFieldFlag(24);
    public static final int FF_COMB = PdfTextFormField.makeFieldFlag(25);
    public static final int FF_RICH_TEXT = PdfTextFormField.makeFieldFlag(26);

    protected PdfTextFormField(PdfDocument pdfDocument) {
        super(pdfDocument);
    }

    protected PdfTextFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        super(widget, pdfDocument);
    }

    protected PdfTextFormField(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getFormType() {
        return PdfName.Tx;
    }

    public PdfTextFormField setMultiline(boolean multiline) {
        return (PdfTextFormField)this.setFieldFlag(FF_MULTILINE, multiline);
    }

    public PdfTextFormField setPassword(boolean password) {
        return (PdfTextFormField)this.setFieldFlag(FF_PASSWORD, password);
    }

    public boolean isFileSelect() {
        return this.getFieldFlag(FF_FILE_SELECT);
    }

    public PdfTextFormField setFileSelect(boolean fileSelect) {
        return (PdfTextFormField)this.setFieldFlag(FF_FILE_SELECT, fileSelect);
    }

    public boolean isSpellCheck() {
        return !this.getFieldFlag(FF_DO_NOT_SPELL_CHECK);
    }

    public PdfTextFormField setSpellCheck(boolean spellCheck) {
        return (PdfTextFormField)this.setFieldFlag(FF_DO_NOT_SPELL_CHECK, !spellCheck);
    }

    public boolean isScroll() {
        return !this.getFieldFlag(FF_DO_NOT_SCROLL);
    }

    public PdfTextFormField setScroll(boolean scroll) {
        return (PdfTextFormField)this.setFieldFlag(FF_DO_NOT_SCROLL, !scroll);
    }

    public boolean isComb() {
        return this.getFieldFlag(FF_COMB);
    }

    public PdfTextFormField setComb(boolean comb) {
        return (PdfTextFormField)this.setFieldFlag(FF_COMB, comb);
    }

    public boolean isRichText() {
        return this.getFieldFlag(FF_RICH_TEXT);
    }

    public PdfTextFormField setRichText(boolean richText) {
        return (PdfTextFormField)this.setFieldFlag(FF_RICH_TEXT, richText);
    }

    public int getMaxLen() {
        PdfNumber maxLenEntry = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.MaxLen);
        if (maxLenEntry != null) {
            return maxLenEntry.intValue();
        }
        PdfDictionary parent = this.getParent();
        if (parent != null) {
            return new PdfTextFormField(parent).getMaxLen();
        }
        return 0;
    }

    public PdfTextFormField setMaxLen(int maxLen) {
        this.put(PdfName.MaxLen, (PdfObject)new PdfNumber(maxLen));
        if (this.getFieldFlag(FF_COMB)) {
            this.regenerateField();
        }
        return this;
    }
}

