/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.pdf.IPdfPageExtraCopier;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfPageFormCopier
implements IPdfPageExtraCopier {
    PdfAcroForm formFrom;
    PdfAcroForm formTo;
    PdfDocument documentFrom;
    PdfDocument documentTo;

    public void copy(PdfPage fromPage, PdfPage toPage) {
        Map<String, PdfFormField> fieldsFrom;
        if (this.documentFrom != fromPage.getDocument()) {
            this.documentFrom = fromPage.getDocument();
            this.formFrom = PdfAcroForm.getAcroForm(this.documentFrom, false);
        }
        if (this.documentTo != toPage.getDocument()) {
            this.documentTo = toPage.getDocument();
            this.formTo = PdfAcroForm.getAcroForm(this.documentTo, true);
            if (this.formFrom != null) {
                ArrayList<PdfName> excludedKeys = new ArrayList<PdfName>();
                excludedKeys.add(PdfName.Fields);
                excludedKeys.add(PdfName.DR);
                PdfDictionary dict = ((PdfDictionary)this.formFrom.getPdfObject()).copyTo(this.documentTo, excludedKeys, false);
                ((PdfDictionary)this.formTo.getPdfObject()).mergeDifferent(dict);
            }
        }
        ArrayList<PdfDictionary> usedParents = new ArrayList<PdfDictionary>();
        if (this.formFrom != null && (fieldsFrom = this.formFrom.getFormFields()).size() > 0) {
            Map<String, PdfFormField> fieldsTo = this.formTo.getFormFields();
            List annots = toPage.getAnnotations();
            for (PdfAnnotation annot : annots) {
                if (!annot.getSubtype().equals((Object)PdfName.Widget)) continue;
                PdfDictionary parent = ((PdfDictionary)annot.getPdfObject()).getAsDictionary(PdfName.Parent);
                if (parent != null) {
                    PdfString parentName = parent.getAsString(PdfName.T);
                    if (parentName == null) continue;
                    if (!usedParents.contains(parent)) {
                        PdfFormField field = PdfFormField.makeFormField((PdfObject)parent, toPage.getDocument());
                        field.getKids().clear();
                        this.formTo.addField(field, toPage);
                        usedParents.add(parent);
                        field.addKid((PdfWidgetAnnotation)annot);
                        continue;
                    }
                    parent.getAsArray(PdfName.Kids).add(annot.getPdfObject());
                    continue;
                }
                PdfString annotName = ((PdfDictionary)annot.getPdfObject()).getAsString(PdfName.T);
                String annotNameString = null;
                if (annotName != null) {
                    annotNameString = annotName.toUnicodeString();
                }
                if (annotNameString == null || !fieldsFrom.containsKey(annotNameString)) continue;
                PdfFormField field = PdfFormField.makeFormField(annot.getPdfObject(), toPage.getDocument());
                if (fieldsTo.containsKey(annotNameString)) {
                    field = this.mergeFieldsWithTheSameName(field, fieldsTo.get(annotNameString));
                    Logger logger = LoggerFactory.getLogger(PdfPageFormCopier.class);
                    logger.warn(MessageFormat.format("The document already has field {0}. Annotations of the fields with this name will be added to the existing one as children. If you want to have separate fields, please, rename them manually before copying.", annotNameString));
                }
                this.formTo.addField(field, null);
            }
        }
    }

    private PdfFormField mergeFieldsWithTheSameName(PdfFormField existingField, PdfFormField newField) {
        String fieldName = newField.getFieldName().toUnicodeString();
        ((PdfDictionary)existingField.getPdfObject()).remove(PdfName.T);
        PdfFormField mergedField = this.formTo.getField(fieldName);
        PdfArray kids = mergedField.getKids();
        if (kids != null && !kids.isEmpty()) {
            mergedField.addKid(existingField);
            return mergedField;
        }
        ((PdfDictionary)newField.getPdfObject()).remove(PdfName.T);
        mergedField = PdfFormField.createEmptyField(this.documentTo);
        this.formTo.getFields().remove(newField.getPdfObject());
        mergedField.put(PdfName.FT, (PdfObject)existingField.getFormType()).put(PdfName.T, (PdfObject)new PdfString(fieldName));
        PdfDictionary parent = existingField.getParent();
        if (parent != null) {
            mergedField.put(PdfName.Parent, (PdfObject)parent);
        }
        if ((kids = existingField.getKids()) != null) {
            mergedField.put(PdfName.Kids, (PdfObject)kids);
        }
        mergedField.addKid(existingField).addKid(newField);
        return mergedField;
    }
}

