/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitrequest.splitinfo;

import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitInfo {
    private final String splitName;
    private final String url;
    private final String md5;
    private final String splitVersion;
    private final String appVersion;
    private final long size;
    private final boolean builtIn;
    private final boolean hasLibs;
    private final LibInfo primaryLibInfo;
    private final int dexNumber;
    private final boolean isMultiDex;
    private final int minSdkVersion;
    private final List<String> workProcesses;
    private final List<String> dependencies;

    SplitInfo(String splitName, String appVersion, String version, String url, String md5, long size, boolean builtIn, int minSdkVersion, int dexNumber, List<String> workProcesses, List<String> dependencies, boolean hasLibs, LibInfo primaryLibInfo) {
        this.splitName = splitName;
        this.appVersion = appVersion;
        this.splitVersion = version;
        this.url = url;
        this.md5 = md5;
        this.size = size;
        this.builtIn = builtIn;
        this.minSdkVersion = minSdkVersion;
        this.dexNumber = dexNumber;
        this.workProcesses = workProcesses;
        this.dependencies = dependencies;
        this.hasLibs = hasLibs;
        this.primaryLibInfo = primaryLibInfo;
        this.isMultiDex = dexNumber > 1;
    }

    public String getSplitName() {
        return this.splitName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getSplitVersion() {
        return this.splitVersion;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public LibInfo getLibInfo() {
        if (this.hasLibs && this.primaryLibInfo == null) {
            throw new RuntimeException("No supported abi for split " + this.splitName);
        }
        return this.primaryLibInfo;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isMultiDex() {
        return this.isMultiDex;
    }

    public boolean hasDex() {
        return this.dexNumber > 0;
    }

    public boolean hasLibs() {
        return this.hasLibs;
    }

    public List<String> getWorkProcesses() {
        return this.workProcesses;
    }

    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.url) && this.checkLibInfo() && !TextUtils.isEmpty((CharSequence)this.splitName) && !TextUtils.isEmpty((CharSequence)this.md5) && this.size > 0L;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    private boolean checkLibInfo() {
        if (this.primaryLibInfo != null && this.primaryLibInfo.libs != null && !this.primaryLibInfo.libs.isEmpty()) {
            if (TextUtils.isEmpty((CharSequence)this.primaryLibInfo.abi)) {
                return false;
            }
            for (LibInfo.Lib lib : this.primaryLibInfo.libs) {
                if (TextUtils.isEmpty((CharSequence)lib.name) || TextUtils.isEmpty((CharSequence)lib.md5)) {
                    return false;
                }
                if (lib.name.startsWith("lib") || lib.name.endsWith(".so")) continue;
                return false;
            }
        }
        return true;
    }

    public static class LibInfo {
        private final String abi;
        private final List<Lib> libs;

        LibInfo(String abi, List<Lib> libs) {
            this.abi = abi;
            this.libs = libs;
        }

        public String getAbi() {
            return this.abi;
        }

        public List<Lib> getLibs() {
            return this.libs;
        }

        public static class Lib {
            private final String name;
            private final String md5;
            private final long size;

            Lib(String name, String md5, long size) {
                this.name = name;
                this.md5 = md5;
                this.size = size;
            }

            public String getName() {
                return this.name;
            }

            public String getMd5() {
                return this.md5;
            }

            public long getSize() {
                return this.size;
            }
        }
    }
}

