/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitrequest.splitinfo;

import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoVersionData;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoVersionDataStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Properties;

final class SplitInfoVersionDataStorageImpl
implements SplitInfoVersionDataStorage {
    private static final int MAX_EXTRACT_ATTEMPTS = 3;
    private static final String NEW_VERSION = "newVersion";
    private static final String OLD_VERSION = "oldVersion";
    private static final String TAG = "SplitInfoVersionStorageImpl";
    private final File versionDataFile;
    private static final String VERSION_DATA_NAME = "version.info";
    private static final String VERSION_DATA_LOCK_NAME = "version.lock";
    private final RandomAccessFile lockRaf;
    private final FileChannel lockChannel;
    private final FileLock cacheLock;

    SplitInfoVersionDataStorageImpl(File rootDir) throws IOException {
        this.versionDataFile = new File(rootDir, VERSION_DATA_NAME);
        File lockFile = new File(rootDir, VERSION_DATA_LOCK_NAME);
        this.lockRaf = new RandomAccessFile(lockFile, "rw");
        try {
            this.lockChannel = this.lockRaf.getChannel();
            try {
                SplitLog.i((String)TAG, (String)("Blocking on lock " + lockFile.getPath()), (Object[])new Object[0]);
                this.cacheLock = this.lockChannel.lock();
            }
            catch (IOException | Error | RuntimeException var5) {
                FileUtil.closeQuietly((Object)this.lockChannel);
                throw var5;
            }
            SplitLog.i((String)TAG, (String)(lockFile.getPath() + " locked"), (Object[])new Object[0]);
        }
        catch (IOException | Error | RuntimeException var6) {
            FileUtil.closeQuietly((Object)this.lockRaf);
            throw var6;
        }
    }

    @Override
    public SplitInfoVersionData readVersionData() {
        if (!this.cacheLock.isValid()) {
            throw new IllegalStateException("SplitInfoVersionDataStorage was closed");
        }
        if (this.versionDataFile.exists()) {
            return SplitInfoVersionDataStorageImpl.readVersionDataProperties(this.versionDataFile);
        }
        return null;
    }

    @Override
    public boolean updateVersionData(SplitInfoVersionData versionData) {
        if (!this.cacheLock.isValid()) {
            throw new IllegalStateException("SplitInfoVersionDataStorage was closed");
        }
        return this.updateVersionDataProperties(this.versionDataFile, versionData);
    }

    @Override
    public void close() throws IOException {
        this.lockChannel.close();
        this.lockRaf.close();
        this.cacheLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SplitInfoVersionData readVersionDataProperties(File versionDataFile) {
        boolean isReadPatchSuccessful = false;
        int numAttempts = 0;
        String oldVer = null;
        String newVer = null;
        while (numAttempts < 3 && !isReadPatchSuccessful) {
            ++numAttempts;
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(versionDataFile);
                properties.load(inputStream);
                oldVer = properties.getProperty(OLD_VERSION);
                newVer = properties.getProperty(NEW_VERSION);
            }
            catch (IOException e) {
                try {
                    SplitLog.w((String)TAG, (String)("read property failed, e:" + e), (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                FileUtil.closeQuietly((Object)inputStream);
            }
            FileUtil.closeQuietly((Object)inputStream);
            if (oldVer == null || newVer == null) continue;
            isReadPatchSuccessful = true;
        }
        if (isReadPatchSuccessful) {
            return new SplitInfoVersionData(oldVer, newVer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateVersionDataProperties(File versionDataFile, SplitInfoVersionData versionData) {
        if (versionDataFile == null || versionData == null) {
            return false;
        }
        SplitLog.i((String)TAG, (String)("updateVersionDataProperties file path:" + versionDataFile.getAbsolutePath() + " , oldVer:" + versionData.oldVersion + ", newVer:" + versionData.newVersion), (Object[])new Object[0]);
        boolean isWritePatchSuccessful = false;
        int numAttempts = 0;
        File parentFile = versionDataFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        while (numAttempts < 3 && !isWritePatchSuccessful) {
            SplitInfoVersionData tempInfo;
            ++numAttempts;
            Properties newProperties = new Properties();
            newProperties.put(OLD_VERSION, versionData.oldVersion);
            newProperties.put(NEW_VERSION, versionData.newVersion);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(versionDataFile, false);
                String comment = "from old version:" + versionData.oldVersion + " to new version:" + versionData.newVersion;
                newProperties.store(outputStream, comment);
            }
            catch (Exception e) {
                try {
                    SplitLog.w((String)TAG, (String)("write property failed, e:" + e), (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly(outputStream);
                    throw throwable;
                }
                FileUtil.closeQuietly((Object)outputStream);
            }
            FileUtil.closeQuietly((Object)outputStream);
            if (isWritePatchSuccessful = (tempInfo = SplitInfoVersionDataStorageImpl.readVersionDataProperties(versionDataFile)) != null && tempInfo.oldVersion.equals(versionData.oldVersion) && tempInfo.newVersion.equals(versionData.newVersion)) continue;
            versionDataFile.delete();
        }
        return isWritePatchSuccessful;
    }
}

