/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitrequest.splitinfo;

import android.content.Context;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SplitPathManager {
    private static final String TAG = "SplitPathManager";
    private static final AtomicReference<SplitPathManager> sSplitPathManagerRef = new AtomicReference();
    private final File rootDir;
    private final String qigsawId;

    private SplitPathManager(File rootDir, String qigsawId) {
        this.rootDir = new File(rootDir, qigsawId);
        this.qigsawId = qigsawId;
    }

    public static void install(Context context) {
        sSplitPathManagerRef.compareAndSet(null, SplitPathManager.create(context));
    }

    private static SplitPathManager create(Context context) {
        File baseRootDir = context.getDir("qigsaw", 0);
        String qigsawId = SplitBaseInfoProvider.getQigsawId();
        return new SplitPathManager(baseRootDir, qigsawId);
    }

    public static SplitPathManager require() {
        if (sSplitPathManagerRef.get() == null) {
            throw new RuntimeException("SplitPathManager must be initialized firstly!");
        }
        return sSplitPathManagerRef.get();
    }

    public File getSplitRootDir(SplitInfo info) {
        File splitRootDir = new File(this.rootDir, info.getSplitName());
        if (!splitRootDir.exists()) {
            splitRootDir.mkdirs();
        }
        return splitRootDir;
    }

    public File getSplitDir(SplitInfo info) {
        File splitDir = new File(this.getSplitRootDir(info), info.getSplitVersion());
        if (!splitDir.exists()) {
            splitDir.mkdirs();
        }
        return splitDir;
    }

    public File getSplitOptDir(SplitInfo info) {
        File splitDir = this.getSplitDir(info);
        File optDir = new File(splitDir, "oat");
        if (!optDir.exists()) {
            optDir.mkdirs();
        }
        return optDir;
    }

    public File getSplitCodeCacheDir(SplitInfo info) {
        File splitDir = this.getSplitDir(info);
        File codeCacheDir = new File(splitDir, "code_cache");
        if (!codeCacheDir.exists()) {
            codeCacheDir.mkdirs();
        }
        return codeCacheDir;
    }

    public File getSplitLibDir(SplitInfo info) {
        File libDir = new File(this.getSplitDir(info), "nativeLib" + File.separator + info.getLibInfo().getAbi());
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        return libDir;
    }

    public File getSplitTmpDir() {
        File tmpDir = new File(this.rootDir, "tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    public void clearCache() {
        File qigsawIdDir = this.rootDir.getParentFile();
        File[] qigsawIdFiles = qigsawIdDir.listFiles();
        if (qigsawIdFiles != null && qigsawIdFiles.length > 0) {
            for (File file : qigsawIdFiles) {
                if (!file.isDirectory() || file.getName().equals(this.qigsawId)) continue;
                FileUtil.deleteDir((File)file);
                SplitLog.i((String)TAG, (String)"Success to delete all obsolete splits for current app version!", (Object[])new Object[0]);
            }
        }
    }
}

