/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.SplitApplicationLoaders;
import com.iqiyi.android.qigsaw.core.splitload.SplitUnKnownFileTypeDexLoader;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class SplitDexClassLoader
extends BaseDexClassLoader {
    private static final String TAG = "SplitDexClassLoader";
    private final String moduleName;
    private Set<SplitDexClassLoader> dependenciesLoaders;

    private SplitDexClassLoader(String moduleName, List<String> dexPaths, File optimizedDirectory, String librarySearchPath, List<String> dependencies, ClassLoader parent) throws Throwable {
        super(dexPaths == null ? "" : TextUtils.join((CharSequence)File.pathSeparator, dexPaths), optimizedDirectory, librarySearchPath, parent);
        this.moduleName = moduleName;
        this.dependenciesLoaders = SplitApplicationLoaders.getInstance().getClassLoaders(dependencies);
        SplitUnKnownFileTypeDexLoader.loadDex((ClassLoader)((Object)this), dexPaths, optimizedDirectory);
    }

    static SplitDexClassLoader create(String moduleName, List<String> dexPaths, File optimizedDirectory, File librarySearchFile, List<String> dependencies) throws Throwable {
        long time = System.currentTimeMillis();
        SplitDexClassLoader cl = new SplitDexClassLoader(moduleName, dexPaths, optimizedDirectory, librarySearchFile == null ? null : librarySearchFile.getAbsolutePath(), dependencies, SplitDexClassLoader.class.getClassLoader());
        SplitLog.d((String)TAG, (String)"Cost %d ms to load %s code", (Object[])new Object[]{System.currentTimeMillis() - time, moduleName});
        return cl;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e1) {
            if (this.dependenciesLoaders != null) {
                for (SplitDexClassLoader loader : this.dependenciesLoaders) {
                    try {
                        return loader.loadClassItself(name);
                    }
                    catch (ClassNotFoundException e2) {
                        SplitLog.w((String)TAG, (String)"SplitDexClassLoader: Class %s is not found in %s ClassLoader", (Object[])new Object[]{name, loader.moduleName()});
                    }
                }
            }
            throw e1;
        }
    }

    String moduleName() {
        return this.moduleName;
    }

    public String findLibrary(String name) {
        String libName = super.findLibrary(name);
        if (libName == null && this.dependenciesLoaders != null) {
            SplitDexClassLoader loader;
            Iterator<SplitDexClassLoader> iterator = this.dependenciesLoaders.iterator();
            while (iterator.hasNext() && (libName = (loader = iterator.next()).findLibrary(name)) == null) {
            }
        }
        if (libName == null && this.getParent() instanceof BaseDexClassLoader) {
            libName = ((BaseDexClassLoader)this.getParent()).findLibrary(name);
        }
        return libName;
    }

    protected Enumeration<URL> findResources(String name) {
        Enumeration<URL> resources;
        block1: {
            SplitDexClassLoader loader;
            resources = super.findResources(name);
            if (resources != null || this.dependenciesLoaders == null) break block1;
            Iterator<SplitDexClassLoader> iterator = this.dependenciesLoaders.iterator();
            while (iterator.hasNext() && (resources = (loader = iterator.next()).findResourcesItself(name)) == null) {
            }
        }
        return resources;
    }

    protected URL findResource(String name) {
        URL resource;
        block1: {
            SplitDexClassLoader loader;
            resource = super.findResource(name);
            if (resource != null || this.dependenciesLoaders == null) break block1;
            Iterator<SplitDexClassLoader> iterator = this.dependenciesLoaders.iterator();
            while (iterator.hasNext() && (resource = (loader = iterator.next()).findResourceItself(name)) == null) {
            }
        }
        return resource;
    }

    URL findResourceItself(String name) {
        return super.findResource(name);
    }

    Enumeration<URL> findResourcesItself(String name) {
        return super.findResources(name);
    }

    String findLibraryItself(String name) {
        return super.findLibrary(name);
    }

    Class<?> loadClassItself(String name) throws ClassNotFoundException {
        Class cl = this.findLoadedClass(name);
        if (cl != null) {
            return cl;
        }
        return super.findClass(name);
    }
}

