/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArraySet;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.SplitActivator;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadReporterManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoader;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadReporter;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

abstract class SplitLoadTask
implements Runnable {
    private static final String TAG = "SplitLoadTask";
    final Context appContext;
    private final Handler mainHandler;
    private final SplitActivator activator;
    private final SplitLoadManager loadManager;
    private final SplitInfoManager infoManager;
    private final List<Intent> splitFileIntents;
    private final OnSplitLoadListener loadListener;
    private final Object mLock = new Object();

    SplitLoadTask(@NonNull SplitLoadManager loadManager, @NonNull List<Intent> splitFileIntents, @Nullable OnSplitLoadListener loadListener) {
        this.loadManager = loadManager;
        this.splitFileIntents = splitFileIntents;
        this.loadListener = loadListener;
        this.appContext = loadManager.getContext();
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.infoManager = SplitInfoManagerService.getInstance();
        this.activator = new SplitActivator(loadManager.getContext());
    }

    abstract SplitLoader createSplitLoader();

    abstract ClassLoader loadCode(SplitLoader var1, String var2, List<String> var3, File var4, File var5, List<String> var6) throws SplitLoadException;

    abstract void onSplitActivateFailed(ClassLoader var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            this.loadSplitInternal();
        } else {
            Object object = this.mLock;
            synchronized (object) {
                block7: {
                    this.mainHandler.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = SplitLoadTask.this.mLock;
                            synchronized (object) {
                                SplitLoadTask.this.loadSplitInternal();
                                SplitLoadTask.this.mLock.notifyAll();
                            }
                        }
                    });
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        String splitName = this.splitFileIntents.get(0).getStringExtra("splitName");
                        SplitInfo info = this.infoManager.getSplitInfo(this.appContext, splitName);
                        if (info == null) break block7;
                        SplitBriefInfo splitBriefInfo = new SplitBriefInfo(info.getSplitName(), info.getSplitVersion(), info.isBuiltIn());
                        this.reportLoadResult(Collections.emptyList(), Collections.singletonList(new SplitLoadError(splitBriefInfo, -26, (Throwable)e)), 0L);
                    }
                }
            }
        }
    }

    private void loadSplitInternal() {
        long time = System.currentTimeMillis();
        SplitLoader loader = this.createSplitLoader();
        ArraySet splits = new ArraySet();
        ArrayList<SplitLoadError> loadErrors = new ArrayList<SplitLoadError>(0);
        ArrayList<SplitBriefInfo> splitBriefInfoList = new ArrayList<SplitBriefInfo>(this.splitFileIntents.size());
        for (Intent splitFileIntent : this.splitFileIntents) {
            ClassLoader classLoader;
            String splitName = splitFileIntent.getStringExtra("splitName");
            SplitInfo info = this.infoManager.getSplitInfo(this.appContext, splitName);
            if (info == null) {
                SplitLog.w((String)TAG, (String)"Unable to get info of %s, just skip!", (Object[])new Object[]{splitName == null ? "null" : splitName});
                continue;
            }
            SplitBriefInfo splitBriefInfo = new SplitBriefInfo(info.getSplitName(), info.getSplitVersion(), info.isBuiltIn());
            if (this.checkSplitLoaded(splitName)) {
                SplitLog.i((String)TAG, (String)"Split %s has been loaded!", (Object[])new Object[]{splitName});
                continue;
            }
            String splitApkPath = splitFileIntent.getStringExtra("apk");
            try {
                loader.loadResources(splitApkPath);
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to load split %s resources!", (Object[])new Object[]{splitName});
                loadErrors.add(new SplitLoadError(splitBriefInfo, e.getErrorCode(), e.getCause()));
                continue;
            }
            ArrayList addedDexPaths = splitFileIntent.getStringArrayListExtra("added-dex");
            File optimizedDirectory = SplitPathManager.require().getSplitOptDir(info);
            File librarySearchPath = null;
            if (info.hasLibs()) {
                librarySearchPath = SplitPathManager.require().getSplitLibDir(info);
            }
            File splitDir = SplitPathManager.require().getSplitDir(info);
            try {
                classLoader = this.loadCode(loader, splitName, addedDexPaths, optimizedDirectory, librarySearchPath, info.getDependencies());
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to load split %s code!", (Object[])new Object[]{splitName});
                loadErrors.add(new SplitLoadError(splitBriefInfo, e.getErrorCode(), e.getCause()));
                continue;
            }
            try {
                this.activator.activate(classLoader, splitName);
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)("Failed to activate " + splitName), (Object[])new Object[0]);
                loadErrors.add(new SplitLoadError(splitBriefInfo, e.getErrorCode(), e.getCause()));
                this.onSplitActivateFailed(classLoader);
                continue;
            }
            if (!splitDir.setLastModified(System.currentTimeMillis())) {
                SplitLog.w((String)TAG, (String)("Failed to set last modified time for " + splitName), (Object[])new Object[0]);
            }
            splitBriefInfoList.add(splitBriefInfo);
            splits.add(new Split(splitName, splitApkPath));
        }
        this.loadManager.putSplits((Collection<Split>)splits);
        this.reportLoadResult(splitBriefInfoList, loadErrors, System.currentTimeMillis() - time);
    }

    private void reportLoadResult(List<SplitBriefInfo> splitBriefInfoList, List<SplitLoadError> errors, long cost) {
        SplitLoadReporter loadReporter = SplitLoadReporterManager.getLoadReporter();
        if (!errors.isEmpty()) {
            if (this.loadListener != null) {
                int lastErrorCode = errors.get((int)(errors.size() - 1)).errorCode;
                this.loadListener.onFailed(lastErrorCode);
            }
            if (loadReporter != null) {
                loadReporter.onLoadFailed(this.loadManager.currentProcessName, splitBriefInfoList, errors, cost);
            }
        } else {
            if (this.loadListener != null) {
                this.loadListener.onCompleted();
            }
            if (loadReporter != null) {
                loadReporter.onLoadOK(this.loadManager.currentProcessName, splitBriefInfoList, cost);
            }
        }
    }

    private boolean checkSplitLoaded(String splitName) {
        for (Split split : this.loadManager.getLoadedSplits()) {
            if (!split.splitName.equals(splitName)) continue;
            return true;
        }
        return false;
    }
}

