/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitApplicationLoaders;
import com.iqiyi.android.qigsaw.core.splitload.SplitDexClassLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitLibraryLoaderHelper {
    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    public static boolean loadSplitLibrary(Context context, String libraryName) {
        if (!SplitLoadManagerService.hasInstance()) {
            return false;
        }
        if (SplitLoadManagerService.getInstance().splitLoadMode() != 1) {
            return false;
        }
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        assert (manager != null);
        Collection splits = manager.getAllSplitInfo(context);
        if (splits == null) {
            return false;
        }
        block2: for (SplitInfo info : splits) {
            if (!info.hasLibs()) continue;
            List libs = info.getLibInfo().getLibs();
            for (SplitInfo.LibInfo.Lib lib : libs) {
                if (!lib.getName().equals(System.mapLibraryName(libraryName))) continue;
                if (context instanceof Application) {
                    String libPath = SplitPathManager.require().getSplitDir(info).getAbsolutePath() + File.separator + lib.getName();
                    try {
                        System.load(libPath);
                        return true;
                    }
                    catch (UnsatisfiedLinkError error) {
                        return false;
                    }
                }
                SplitDexClassLoader classLoader = SplitApplicationLoaders.getInstance().getClassLoader(info.getSplitName());
                if (classLoader == null) continue block2;
                return SplitLibraryLoaderHelper.loadSplitLibrary0((ClassLoader)((Object)classLoader), info.getSplitName(), libraryName);
            }
        }
        return false;
    }

    private static boolean loadSplitLibrary0(ClassLoader classLoader, String splitName, String name) {
        try {
            Class<?> splitLoaderCl = classLoader.loadClass("com.iqiyi.android.qigsaw.core.splitlib." + splitName + "SplitLibraryLoader");
            Object splitLoader = splitLoaderCl.newInstance();
            Method method = HiddenApiReflection.findMethod(splitLoaderCl, "loadSplitLibrary", String.class);
            method.invoke(splitLoader, name);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

