/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Looper;
import android.os.MessageQueue;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatResourcesLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitDelegateClassloader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadTaskImpl;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadTaskImpl2;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class SplitLoadManagerImpl
extends SplitLoadManager {
    private static final String TAG = "SplitLoadManagerImpl";
    private final boolean qigsawMode;
    private final String[] forbiddenWorkProcesses;
    private final String[] workProcesses;

    SplitLoadManagerImpl(Context context, String currentProcessName, int splitLoadMode, boolean qigsawMode, String[] workProcesses, String[] forbiddenWorkProcesses) {
        super(context, currentProcessName, splitLoadMode);
        this.qigsawMode = qigsawMode;
        this.workProcesses = workProcesses;
        this.forbiddenWorkProcesses = forbiddenWorkProcesses;
        SplitInfoManagerService.install((Context)context, (String)currentProcessName);
        SplitPathManager.install((Context)context);
    }

    @Override
    public void injectPathClassloader() {
        ClassLoader curCl;
        if (this.isInjectPathClassloaderNeeded() && this.isProcessAllowedToWork()) {
            this.injectClassLoader(this.getContext().getClassLoader());
        }
        if ((curCl = this.getContext().getClassLoader()) instanceof SplitDelegateClassloader) {
            ((SplitDelegateClassloader)((Object)curCl)).setSplitLoadMode(this.splitLoadMode);
        }
    }

    @Override
    public void loadInstalledSplitsWhenAppLaunches() {
        if (!this.qigsawMode) {
            return;
        }
        if (this.isProcessAllowedToWork()) {
            this.deferredLoadInstalledSplits();
        }
    }

    @Override
    public void getResources(Resources resources) {
        try {
            SplitCompatResourcesLoader.loadResources(this.getContext(), resources);
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
    }

    @Override
    public Runnable createSplitLoadTask(List<Intent> splitFileIntents, @Nullable OnSplitLoadListener loadListener) {
        if (this.splitLoadMode == 1) {
            return new SplitLoadTaskImpl(this, splitFileIntents, loadListener);
        }
        return new SplitLoadTaskImpl2(this, splitFileIntents, loadListener);
    }

    @Override
    public void loadInstalledSplits() {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        if (manager != null) {
            Collection splitInfoList = manager.getAllSplitInfo(this.getContext());
            if (splitInfoList != null) {
                List<Intent> splitFileIntents = this.createInstalledSplitFileIntents(splitInfoList);
                if (!splitFileIntents.isEmpty()) {
                    this.createSplitLoadTask(splitFileIntents, null).run();
                } else {
                    SplitLog.w((String)TAG, (String)"There are no installed splits!", (Object[])new Object[0]);
                }
            } else {
                SplitLog.w((String)TAG, (String)"Failed to get Split-Info list!", (Object[])new Object[0]);
            }
        } else {
            SplitLog.w((String)TAG, (String)"Failed to get SplitInfoManager instance!", (Object[])new Object[0]);
        }
    }

    private boolean isInjectPathClassloaderNeeded() {
        if (Build.VERSION.SDK_INT < 29) {
            return this.qigsawMode;
        }
        boolean exist = this.getContext().getClassLoader() instanceof SplitDelegateClassloader;
        return !exist && this.qigsawMode;
    }

    private List<Intent> createInstalledSplitFileIntents(@NonNull Collection<SplitInfo> splitInfoList) {
        ArrayList<Intent> splitFileIntents = new ArrayList<Intent>();
        for (SplitInfo splitInfo : splitInfoList) {
            if (this.canBeWorkedInThisProcessForSplit(splitInfo)) {
                if (this.getLoadedSplitNames().contains(splitInfo.getSplitName())) {
                    SplitLog.i((String)TAG, (String)"Split %s has been loaded, ignore it!", (Object[])new Object[]{splitInfo.getSplitName()});
                    continue;
                }
                Intent splitFileIntent = this.createLastInstalledSplitFileIntent(splitInfo);
                if (splitFileIntent != null) {
                    splitFileIntents.add(splitFileIntent);
                }
                SplitLog.i((String)TAG, (String)"Split %s will work in process %s, %s it is %s", (Object[])new Object[]{splitInfo.getSplitName(), this.currentProcessName, splitFileIntent == null ? "but" : "and", splitFileIntent == null ? "not installed" : "installed"});
                continue;
            }
            SplitLog.i((String)TAG, (String)"Split %s do not need work in process %s", (Object[])new Object[]{splitInfo.getSplitName(), this.currentProcessName});
        }
        return splitFileIntents;
    }

    private boolean canBeWorkedInThisProcessForSplit(SplitInfo splitInfo) {
        List workProcesses = splitInfo.getWorkProcesses();
        if (workProcesses != null && !workProcesses.isEmpty()) {
            String packageName = this.getContext().getPackageName();
            String simpleProcessName = this.currentProcessName.replace(packageName, "");
            return workProcesses.contains(simpleProcessName);
        }
        return true;
    }

    private void deferredLoadInstalledSplits() {
        if (this.splitLoadMode == 1) {
            Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                public boolean queueIdle() {
                    SplitLoadManagerImpl.this.loadInstalledSplits();
                    return false;
                }
            });
        } else {
            this.loadInstalledSplits();
        }
    }

    private Intent createLastInstalledSplitFileIntent(SplitInfo splitInfo) {
        String splitName = splitInfo.getSplitName();
        File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
        File markFile = SplitPathManager.require().getSplitMarkFile(splitInfo);
        File splitApk = splitInfo.isBuiltIn() && splitInfo.getUrl().startsWith("native://") ? new File(this.getContext().getApplicationInfo().nativeLibraryDir, System.mapLibraryName("split_" + splitInfo.getSplitName())) : new File(splitDir, splitName + ".apk");
        if (markFile.exists()) {
            List dependencies = splitInfo.getDependencies();
            if (dependencies != null) {
                SplitLog.i((String)TAG, (String)"Split %s has dependencies %s !", (Object[])new Object[]{splitName, dependencies});
                for (String dependency : dependencies) {
                    SplitInfo dependencySplitInfo = SplitInfoManagerService.getInstance().getSplitInfo(this.getContext(), dependency);
                    File dependencyMarkFile = SplitPathManager.require().getSplitMarkFile(dependencySplitInfo);
                    if (dependencyMarkFile.exists()) continue;
                    SplitLog.i((String)TAG, (String)"Dependency %s mark file is not existed!", (Object[])new Object[]{dependency});
                    return null;
                }
            }
            ArrayList<String> addedDexPaths = null;
            if (splitInfo.hasDex()) {
                addedDexPaths = new ArrayList<String>();
                addedDexPaths.add(splitApk.getAbsolutePath());
                File[] results = SplitPathManager.require().getSplitCodeCacheDir(splitInfo).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".zip");
                    }
                });
                if (results != null && results.length > 0) {
                    for (File result : results) {
                        addedDexPaths.add(result.getAbsolutePath());
                    }
                }
            }
            Intent splitFileIntent = new Intent();
            splitFileIntent.putExtra("splitName", splitName);
            splitFileIntent.putExtra("apk", splitApk.getAbsolutePath());
            if (addedDexPaths != null) {
                splitFileIntent.putStringArrayListExtra("added-dex", addedDexPaths);
            }
            return splitFileIntent;
        }
        return null;
    }

    private void injectClassLoader(ClassLoader originalClassloader) {
        try {
            SplitDelegateClassloader.inject(originalClassloader, this.getBaseContext());
        }
        catch (Exception e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to hook PathClassloader", (Object[])new Object[0]);
        }
    }

    private Context getBaseContext() {
        Context ctx = this.getContext();
        while (ctx instanceof ContextWrapper) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx;
    }

    private boolean isProcessAllowedToWork() {
        if (this.workProcesses == null && this.forbiddenWorkProcesses == null) {
            return true;
        }
        if (this.getContext().getPackageName().equals(this.currentProcessName)) {
            return true;
        }
        if (this.forbiddenWorkProcesses != null) {
            for (String process : this.forbiddenWorkProcesses) {
                if (!this.getCompleteProcessName(process).equals(this.currentProcessName)) continue;
                return false;
            }
        }
        if (this.workProcesses != null) {
            for (String process : this.workProcesses) {
                if (!this.getCompleteProcessName(process).equals(this.currentProcessName)) continue;
                return true;
            }
        }
        return true;
    }

    private String getCompleteProcessName(@Nullable String process) {
        String packageName = this.getContext().getPackageName();
        if (TextUtils.isEmpty((CharSequence)process)) {
            return packageName;
        }
        if (process.startsWith(packageName)) {
            return process;
        }
        return packageName + process;
    }
}

