/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import java.util.ArrayList;
import java.util.List;

final class SplitActivator {
    private final AABExtension aabExtension;
    private final Context appContext;
    private static final List<Application> splitApplications = new ArrayList<Application>();

    SplitActivator(Context context) {
        this.appContext = context;
        this.aabExtension = AABExtension.getInstance();
    }

    void activate(ClassLoader classLoader, String splitName) throws SplitLoadException {
        Application app;
        try {
            app = this.aabExtension.createApplication(classLoader, splitName);
            this.aabExtension.activeApplication(app, this.appContext);
        }
        catch (Throwable e) {
            if (this.debuggable() && !(e instanceof AABExtensionException)) {
                throw new RuntimeException(e);
            }
            throw new SplitLoadException(-24, e);
        }
        try {
            this.aabExtension.activateSplitProviders(classLoader, splitName);
        }
        catch (AABExtensionException e) {
            throw new SplitLoadException(-25, (Throwable)e);
        }
        if (app != null) {
            try {
                app.onCreate();
                splitApplications.add(app);
            }
            catch (Throwable e) {
                if (this.debuggable()) {
                    throw new RuntimeException(e);
                }
                throw new SplitLoadException(-24, e);
            }
        }
    }

    private boolean debuggable() {
        try {
            ApplicationInfo info = this.appContext.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

