/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitApplicationLoaders;
import com.iqiyi.android.qigsaw.core.splitload.SplitDexClassLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitLibraryLoader {
    public static boolean loadSplitLibrary(Context context, String libraryName) {
        if (!SplitLoadManagerService.hasInstance()) {
            return false;
        }
        if (SplitLoadManagerService.getInstance().splitLoadMode() != 1) {
            return false;
        }
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        assert (manager != null);
        Collection splits = manager.getAllSplitInfo(context);
        if (splits == null) {
            return false;
        }
        for (SplitInfo info : splits) {
            SplitDexClassLoader classLoader;
            if (!info.hasLibs()) continue;
            List libs = info.getLibInfo().getLibs();
            boolean hitLib = false;
            for (SplitInfo.LibInfo.Lib lib : libs) {
                if (!lib.getName().equals(System.mapLibraryName(libraryName))) continue;
                hitLib = true;
                break;
            }
            if (!hitLib || (classLoader = SplitApplicationLoaders.getInstance().getClassLoader(info.getSplitName())) == null) continue;
            return SplitLibraryLoader.loadSplitLibrary0((ClassLoader)((Object)classLoader), libraryName);
        }
        return false;
    }

    private static boolean loadSplitLibrary0(ClassLoader classLoader, String name) {
        try {
            Method method = HiddenApiReflection.findMethod(Runtime.class, "loadLibrary0", ClassLoader.class, String.class);
            method.invoke((Object)Runtime.getRuntime(), classLoader, name);
            return true;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }
}

