/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SplitDexClassLoader
extends BaseDexClassLoader {
    private final Context appContext;
    private final String moduleName;

    private SplitDexClassLoader(Context context, String moduleName, String dexPath, File optimizedDirectory, String librarySearchPath, ClassLoader parent) {
        super(dexPath, optimizedDirectory, librarySearchPath, parent);
        this.moduleName = moduleName;
        this.appContext = context;
    }

    public static SplitDexClassLoader create(Context context, String moduleName, List<String> dexPaths, File optimizedDirectory, File librarySearchFile) {
        String dexPath = dexPaths == null ? "" : TextUtils.join((CharSequence)File.pathSeparator, dexPaths);
        return new SplitDexClassLoader(context, moduleName, dexPath, optimizedDirectory, librarySearchFile == null ? null : librarySearchFile.getAbsolutePath(), SplitDexClassLoader.class.getClassLoader());
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException error) {
            return this.appContext.getClassLoader().loadClass(name);
        }
    }

    String moduleName() {
        return this.moduleName;
    }

    Class<?> loadClassItself(String name) throws ClassNotFoundException {
        Class cl = this.findLoadedClass(name);
        if (cl != null) {
            return cl;
        }
        return super.findClass(name);
    }
}

