/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.util.Pair;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import dalvik.system.PathClassLoader;

final class SplitProxyClassloader
extends PathClassLoader {
    private static final String TAG = "SplitDexClassloader";
    private PathClassLoader originClassLoader;

    private SplitProxyClassloader(String dexPath, ClassLoader parent) {
        super(dexPath, parent);
        this.originClassLoader = (PathClassLoader)parent;
    }

    private static void reflectPackageInfoClassloader(Context baseContext, ClassLoader reflectClassLoader) throws Exception {
        Object basePackageInfo = HiddenApiReflection.findField(baseContext, "mPackageInfo").get(baseContext);
        HiddenApiReflection.findField(basePackageInfo, "mClassLoader").set(basePackageInfo, reflectClassLoader);
        Thread.currentThread().setContextClassLoader(reflectClassLoader);
    }

    static PathClassLoader inject(ClassLoader originalClassloader, Context baseContext) throws Exception {
        SplitProxyClassloader classLoader = new SplitProxyClassloader("", originalClassloader);
        SplitProxyClassloader.reflectPackageInfoClassloader(baseContext, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.originClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException error) {
            Pair result = AABExtension.getInstance().getSplitNameForComponent(name);
            if (result != null) {
                if (SplitLoadManagerService.hasInstance()) {
                    SplitLog.w((String)TAG, (String)"class %s is not found", (Object[])new Object[]{name});
                    SplitLoadManager loadManager = SplitLoadManagerService.getInstance();
                    loadManager.loadInstalledSplits();
                    if (loadManager.getLoadedSplitNames().contains(result.first)) {
                        try {
                            return this.originClassLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            SplitLog.w((String)TAG, (String)"Split component %s not found, return a %s to avoid crash", (Object[])new Object[]{name, ((Class)result.second).getSimpleName()});
                            return (Class)result.second;
                        }
                    }
                    SplitLog.w((String)TAG, (String)"Split component %s not found, return a %s to avoid crash", (Object[])new Object[]{name, ((Class)result.second).getSimpleName()});
                    return (Class)result.second;
                }
                SplitLog.e((String)TAG, (String)"SplitLoadManagerService has not been created!", (Object[])new Object[0]);
            }
            throw error;
        }
    }

    public String findLibrary(String name) {
        String mapLib = this.originClassLoader.findLibrary(name);
        if (mapLib == null || mapLib.length() == 0) {
            return super.findLibrary(name);
        }
        return mapLib;
    }
}

